/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.ui;

import java.net.URL;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.equinox.internal.p2.core.helpers.ServiceHelper;
import org.eclipse.equinox.internal.p2.ui.ProvUI;
import org.eclipse.equinox.internal.p2.ui.ProvUIProvisioningListener;
import org.eclipse.equinox.internal.provisional.p2.core.eventbus.IProvisioningEventBus;
import org.eclipse.equinox.internal.provisional.p2.core.eventbus.ProvisioningListener;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.operations.ProvisioningSession;
import org.eclipse.equinox.p2.ui.Policy;
import org.eclipse.equinox.p2.ui.ProvisioningUI;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.packageadmin.PackageAdmin;

public class ProvUIActivator
extends AbstractUIPlugin {
    private static BundleContext context;
    private static PackageAdmin packageAdmin;
    private static ServiceReference packageAdminRef;
    private static ProvUIActivator plugin;
    public static final String PLUGIN_ID = "org.eclipse.equinox.p2.ui";
    private ProvisioningSession session;
    private ProvisioningUI ui;

    static {
        packageAdmin = null;
        packageAdminRef = null;
    }

    public static BundleContext getContext() {
        return context;
    }

    public static ProvUIActivator getDefault() {
        return plugin;
    }

    public static Bundle getBundle(String symbolicName) {
        if (packageAdmin == null) {
            return null;
        }
        Bundle[] bundles = packageAdmin.getBundles(symbolicName, null);
        if (bundles == null) {
            return null;
        }
        int i = 0;
        while (i < bundles.length) {
            if ((bundles[i].getState() & 3) == 0) {
                return bundles[i];
            }
            ++i;
        }
        return null;
    }

    public void start(BundleContext bundleContext) throws Exception {
        Class<?> clazz;
        super.start(bundleContext);
        plugin = this;
        context = bundleContext;
        try {
            clazz = Class.forName("org.osgi.service.packageadmin.PackageAdmin");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        packageAdminRef = bundleContext.getServiceReference(clazz.getName());
        packageAdmin = (PackageAdmin)bundleContext.getService(packageAdminRef);
        this.initializeProvisioningUI();
    }

    private void initializeProvisioningUI() {
        Class<?> clazz;
        IProvisioningAgent agent = (IProvisioningAgent)ServiceHelper.getService((BundleContext)ProvUIActivator.getContext(), (String)IProvisioningAgent.SERVICE_NAME);
        this.session = new ProvisioningSession(agent);
        try {
            clazz = Class.forName("org.eclipse.equinox.p2.ui.Policy");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        Policy policy = (Policy)ServiceHelper.getService((BundleContext)ProvUIActivator.getContext(), (String)clazz.getName());
        if (policy == null) {
            policy = new Policy();
        }
        this.ui = new ProvisioningUI(this.session, "_SELF_", policy);
    }

    public void stop(BundleContext bundleContext) throws Exception {
        try {
            plugin = null;
            context = null;
            this.ui = null;
        }
        finally {
            super.stop(bundleContext);
        }
    }

    public void addProvisioningListener(ProvUIProvisioningListener listener) {
        this.getProvisioningEventBus().addListener((ProvisioningListener)listener);
    }

    public IProvisioningEventBus getProvisioningEventBus() {
        return ProvUI.getProvisioningEventBus(this.getSession());
    }

    public void removeProvisioningListener(ProvUIProvisioningListener listener) {
        this.getProvisioningEventBus().removeListener((ProvisioningListener)listener);
    }

    protected void initializeImageRegistry(ImageRegistry reg) {
        this.createImageDescriptor("obj/metadata_repo_obj.gif", reg);
        this.createImageDescriptor("obj/artifact_repo_obj.gif", reg);
        this.createImageDescriptor("obj/iu_obj.gif", reg);
        this.createImageDescriptor("obj/iu_disabled_obj.gif", reg);
        this.createImageDescriptor("obj/iu_update_obj.gif", reg);
        this.createImageDescriptor("obj/category_obj.gif", reg);
        this.createImageDescriptor("obj/profile_obj.gif", reg);
        this.createImageDescriptor("wizban/install_wiz.gif", reg);
        this.createImageDescriptor("wizban/revert_wiz.gif", reg);
        this.createImageDescriptor("wizban/uninstall_wiz.gif", reg);
        this.createImageDescriptor("wizban/update_wiz.gif", reg);
    }

    private void createImageDescriptor(String id, ImageRegistry reg) {
        URL url = FileLocator.find((Bundle)this.getBundle(), (IPath)new Path("$nl$/icons/" + id), null);
        ImageDescriptor desc = ImageDescriptor.createFromURL((URL)url);
        reg.put(id, desc);
    }

    public ProvisioningUI getProvisioningUI() {
        return this.ui;
    }

    public ProvisioningSession getSession() {
        return this.session;
    }
}

