/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.internal.search;

import org.eclipse.pde.api.tools.internal.provisional.descriptors.IComponentDescriptor;
import org.eclipse.pde.api.tools.internal.provisional.descriptors.IMemberDescriptor;
import org.eclipse.pde.api.tools.internal.search.IReferenceDescriptor;

public class ReferenceDescriptor
implements IReferenceDescriptor {
    private IMemberDescriptor origin;
    private IMemberDescriptor target;
    private IComponentDescriptor from;
    private IComponentDescriptor to;
    private int line;
    private int kind;
    private int flags;
    private int visibility;

    public ReferenceDescriptor(IComponentDescriptor from, IMemberDescriptor origin, int line, IComponentDescriptor to, IMemberDescriptor target, int kind, int flags, int vis) {
        this.origin = origin;
        this.target = target;
        this.from = from;
        this.to = to;
        this.line = line;
        this.kind = kind;
        this.flags = flags;
        this.visibility = vis;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ReferenceDescriptor) {
            ReferenceDescriptor rd = (ReferenceDescriptor)obj;
            return this.origin.equals(rd.origin) && this.target.equals(rd.target) && this.from.equals(rd.from) && this.to.equals(rd.to) && this.line == rd.line && this.kind == rd.kind && this.visibility == rd.visibility;
        }
        return false;
    }

    public int hashCode() {
        return this.origin.hashCode() + this.target.hashCode() + this.from.hashCode() + this.to.hashCode() + this.line + this.kind + this.visibility;
    }

    public IComponentDescriptor getComponent() {
        return this.from;
    }

    public int getLineNumber() {
        return this.line;
    }

    public IMemberDescriptor getMember() {
        return this.origin;
    }

    public int getReferenceKind() {
        return this.kind;
    }

    public int getReferenceFlags() {
        return this.flags;
    }

    public int getReferenceType() {
        switch (this.getReferencedMember().getElementType()) {
            case 2: {
                return 1;
            }
            case 6: {
                return 3;
            }
            case 5: {
                return 2;
            }
        }
        return -1;
    }

    public IComponentDescriptor getReferencedComponent() {
        return this.to;
    }

    public IMemberDescriptor getReferencedMember() {
        return this.target;
    }

    public int getVisibility() {
        return this.visibility;
    }
}

