/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.core.internal.contexts;

import javax.inject.Named;
import org.eclipse.e4.core.contexts.ContextChangeEvent;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.AbstractObjectSupplier;
import org.eclipse.e4.core.di.IInjector;
import org.eclipse.e4.core.di.IObjectDescriptor;
import org.eclipse.e4.core.di.IRequestor;
import org.eclipse.e4.core.internal.contexts.IRunAndTrackObject;

public class ContextObjectSupplier
extends AbstractObjectSupplier {
    private static final String ECLIPSE_CONTEXT_NAME = IEclipseContext.class.getName();
    private final IEclipseContext context;

    public ContextObjectSupplier(IEclipseContext context, IInjector injector) {
        this.context = context;
    }

    public IEclipseContext getContext() {
        return this.context;
    }

    public Object get(IObjectDescriptor descriptor, IRequestor requestor) {
        if (descriptor == null) {
            return IInjector.NOT_A_VALUE;
        }
        Object[] result = this.get(new IObjectDescriptor[]{descriptor}, requestor);
        if (result == null) {
            return null;
        }
        return result[0];
    }

    public Object[] get(IObjectDescriptor[] descriptors, IRequestor requestor) {
        Object[] result = new Object[descriptors.length];
        String[] keys = new String[descriptors.length];
        int i = 0;
        while (i < descriptors.length) {
            String string = keys[i] = descriptors[i] == null ? null : this.getKey(descriptors[i]);
            if (ECLIPSE_CONTEXT_NAME.equals(keys[i])) {
                result[i] = this.context;
                keys[i] = null;
            }
            ++i;
        }
        if (requestor != null && requestor.shouldTrack()) {
            ContextInjectionListener trackable = new ContextInjectionListener(this.context, result, keys, requestor);
            this.context.runAndTrack(trackable, null);
        } else {
            i = 0;
            while (i < descriptors.length) {
                if (keys[i] != null) {
                    result[i] = this.context.containsKey(keys[i]) ? this.context.get(keys[i]) : IInjector.NOT_A_VALUE;
                }
                ++i;
            }
        }
        return result;
    }

    private String getKey(IObjectDescriptor descriptor) {
        if (descriptor.hasQualifier(Named.class)) {
            Object namedAnnotation = descriptor.getQualifier(Named.class);
            String key = ((Named)namedAnnotation).value();
            return key;
        }
        Class elementClass = descriptor.getElementClass();
        if (elementClass != null) {
            return elementClass.getName();
        }
        return null;
    }

    public static ContextObjectSupplier getObjectSupplier(IEclipseContext context, IInjector injector) {
        String key = ContextObjectSupplier.class.getName();
        if (context.containsKey(key, true)) {
            return (ContextObjectSupplier)((Object)context.get(key));
        }
        ContextObjectSupplier objectSupplier = new ContextObjectSupplier(context, injector);
        context.set(key, (Object)objectSupplier);
        return objectSupplier;
    }

    private static class ContextInjectionListener
    implements IRunAndTrackObject {
        private final Object[] result;
        private final String[] keys;
        private final IRequestor requestor;
        private final IEclipseContext context;

        public ContextInjectionListener(IEclipseContext context, Object[] result, String[] keys, IRequestor requestor) {
            this.result = result;
            this.keys = keys;
            this.requestor = requestor;
            this.context = context;
        }

        public boolean notify(ContextChangeEvent event) {
            if (event.getEventType() == 0) {
                int i = 0;
                while (i < this.keys.length) {
                    if (this.keys[i] != null) {
                        this.result[i] = this.context.containsKey(this.keys[i]) ? this.context.get(this.keys[i]) : IInjector.NOT_A_VALUE;
                    }
                    ++i;
                }
                return true;
            }
            IInjector injector = this.requestor.getInjector();
            if (event.getEventType() == 3) {
                IEclipseContext originatingContext = event.getContext();
                if (originatingContext == this.context) {
                    ContextObjectSupplier originatingSupplier = ContextObjectSupplier.getObjectSupplier(originatingContext, injector);
                    injector.disposed((AbstractObjectSupplier)originatingSupplier);
                    return false;
                }
            } else if (event.getEventType() == 4) {
                IEclipseContext originatingContext = event.getContext();
                if (originatingContext == this.context) {
                    ContextObjectSupplier originatingSupplier = ContextObjectSupplier.getObjectSupplier(originatingContext, injector);
                    injector.uninject(event.getArguments()[0], (AbstractObjectSupplier)originatingSupplier);
                    return false;
                }
            } else {
                injector.update(new IRequestor[]{this.requestor}, this.requestor.getPrimarySupplier());
            }
            return true;
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.context == null ? 0 : this.context.hashCode());
            result = 31 * result + (this.requestor == null ? 0 : this.requestor.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ContextInjectionListener other = (ContextInjectionListener)obj;
            if (this.context == null ? other.context != null : !this.context.equals(other.context)) {
                return false;
            }
            return !(this.requestor == null ? other.requestor != null : !this.requestor.equals(other.requestor));
        }

        public Object getObject() {
            return null;
        }

        public boolean batchProcess() {
            return this.requestor.shouldGroupUpdates();
        }
    }
}

