/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.workbench.ui.renderers.swt;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.di.annotations.PostConstruct;
import org.eclipse.e4.core.di.annotations.PreDestroy;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.core.services.log.Logger;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.MContext;
import org.eclipse.e4.ui.model.application.MElementContainer;
import org.eclipse.e4.ui.model.application.MPart;
import org.eclipse.e4.ui.model.application.MPartStack;
import org.eclipse.e4.ui.model.application.MTrimContainer;
import org.eclipse.e4.ui.model.application.MUIElement;
import org.eclipse.e4.ui.model.application.MUILabel;
import org.eclipse.e4.ui.model.application.MWindow;
import org.eclipse.e4.ui.services.IStylingEngine;
import org.eclipse.e4.workbench.modeling.EPartService;
import org.eclipse.e4.workbench.modeling.ISaveHandler;
import org.eclipse.e4.workbench.ui.IPresentationEngine;
import org.eclipse.e4.workbench.ui.UIEvents;
import org.eclipse.e4.workbench.ui.renderers.swt.SWTPartRenderer;
import org.eclipse.e4.workbench.ui.renderers.swt.TrimmedPartLayout;
import org.eclipse.e4.workbench.ui.renderers.swt.dnd.DnDManager;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.osgi.service.event.EventHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WBWRenderer
extends SWTPartRenderer {
    WindowSizeUpdateJob boundsJob;
    boolean ignoreSizeChanges = false;
    @Inject
    Logger logger;
    @Inject
    private IEventBroker eventBroker;
    private EventHandler shellUpdater;
    private EventHandler visibilityHandler;
    private EventHandler sizeHandler;
    MPart activePart = null;
    @Inject
    private IEclipseContext context;

    void clearSizeUpdate() {
        this.boundsJob = null;
    }

    @Inject
    void trackActivePart(@Optional @Named(value="e4ActivePart") MPart p) {
        MElementContainer parent;
        if (this.activePart != null) {
            this.activePart.getTags().remove((Object)"active");
            parent = this.activePart.getParent();
            if (parent instanceof MPartStack) {
                parent.getTags().remove((Object)"active");
                this.setCSSInfo((MUIElement)parent, parent.getWidget());
            } else {
                this.setCSSInfo((MUIElement)this.activePart, this.activePart.getWidget());
            }
        }
        this.activePart = p;
        if (this.activePart != null) {
            this.activePart.getTags().add((Object)"active");
            parent = this.activePart.getParent();
            if (parent instanceof MPartStack) {
                parent.getTags().add((Object)"active");
                this.setCSSInfo((MUIElement)parent, parent.getWidget());
            } else {
                this.setCSSInfo((MUIElement)this.activePart, this.activePart.getWidget());
            }
        }
    }

    @PostConstruct
    public void init() {
        this.shellUpdater = new EventHandler(){

            public void handleEvent(org.osgi.service.event.Event event) {
                Object objElement = event.getProperty("ChangedElement");
                if (!(event.getProperty("ChangedElement") instanceof MWindow)) {
                    return;
                }
                MWindow windowModel = (MWindow)objElement;
                if (windowModel.getRenderer() != WBWRenderer.this) {
                    return;
                }
                Shell theShell = (Shell)windowModel.getWidget();
                if (theShell == null) {
                    return;
                }
                String attName = (String)event.getProperty("AttName");
                if ("label".equals(attName)) {
                    String newTitle = (String)event.getProperty("NewValue");
                    theShell.setText(newTitle);
                } else if ("iconURI".equals(attName)) {
                    theShell.setImage(WBWRenderer.this.getImage((MUILabel)windowModel));
                } else if ("tooltip".equals(attName)) {
                    String newTTip = (String)event.getProperty("NewValue");
                    theShell.setToolTipText(newTTip);
                }
            }
        };
        this.eventBroker.subscribe(UIEvents.buildTopic((String)"org/eclipse/e4/ui/model/application/UILabel"), this.shellUpdater);
        this.visibilityHandler = new EventHandler(){

            public void handleEvent(org.osgi.service.event.Event event) {
                Object objElement = event.getProperty("ChangedElement");
                if (!(objElement instanceof MWindow)) {
                    return;
                }
                MWindow windowModel = (MWindow)objElement;
                if (windowModel.getRenderer() != WBWRenderer.this) {
                    return;
                }
                Shell theShell = (Shell)windowModel.getWidget();
                if (theShell == null) {
                    return;
                }
                String attName = (String)event.getProperty("AttName");
                if ("visible".equals(attName)) {
                    boolean isVisible = (Boolean)event.getProperty("NewValue");
                    theShell.setVisible(isVisible);
                }
            }
        };
        this.eventBroker.subscribe(UIEvents.buildTopic((String)"org/eclipse/e4/ui/model/application/UIElement", (String)"visible"), this.visibilityHandler);
        this.sizeHandler = new EventHandler(){

            public void handleEvent(org.osgi.service.event.Event event) {
                if (WBWRenderer.this.ignoreSizeChanges) {
                    return;
                }
                Object objElement = event.getProperty("ChangedElement");
                if (!(objElement instanceof MWindow)) {
                    return;
                }
                MWindow windowModel = (MWindow)objElement;
                if (windowModel.getRenderer() != WBWRenderer.this) {
                    return;
                }
                Shell theShell = (Shell)windowModel.getWidget();
                if (theShell == null) {
                    return;
                }
                String attName = (String)event.getProperty("AttName");
                if ("x".equals(attName) || "y".equals(attName) || "width".equals(attName) || "height".equals(attName)) {
                    if (WBWRenderer.this.boundsJob == null) {
                        WBWRenderer.this.boundsJob = new WindowSizeUpdateJob();
                        WBWRenderer.this.boundsJob.windowsToUpdate.add(windowModel);
                        theShell.getDisplay().asyncExec((Runnable)WBWRenderer.this.boundsJob);
                    } else if (!WBWRenderer.this.boundsJob.windowsToUpdate.contains(windowModel)) {
                        WBWRenderer.this.boundsJob.windowsToUpdate.add(windowModel);
                    }
                }
            }
        };
        this.eventBroker.subscribe(UIEvents.buildTopic((String)"org/eclipse/e4/ui/model/application/Window"), this.sizeHandler);
        this.context.set(ISaveHandler.class.getName(), (Object)new ISaveHandler(){

            public ISaveHandler.Save promptToSave(MPart dirtyPart) {
                Shell shell = (Shell)WBWRenderer.this.context.get("activeShell");
                Object[] elements = WBWRenderer.this.promptForSave(shell, Collections.singleton(dirtyPart));
                if (elements == null) {
                    return ISaveHandler.Save.CANCEL;
                }
                return elements.length == 0 ? ISaveHandler.Save.NO : ISaveHandler.Save.YES;
            }

            public ISaveHandler.Save[] promptToSave(Collection<MPart> dirtyParts) {
                ArrayList<MPart> parts = new ArrayList<MPart>(dirtyParts);
                Shell shell = (Shell)WBWRenderer.this.context.get("activeShell");
                Object[] response = new ISaveHandler.Save[dirtyParts.size()];
                Object[] elements = WBWRenderer.this.promptForSave(shell, parts);
                if (elements == null) {
                    Arrays.fill(response, ISaveHandler.Save.CANCEL);
                } else {
                    Arrays.fill(response, ISaveHandler.Save.NO);
                    int i = 0;
                    while (i < elements.length) {
                        response[parts.indexOf((Object)elements[i])] = ISaveHandler.Save.YES;
                        ++i;
                    }
                }
                return response;
            }
        });
    }

    @PreDestroy
    public void contextDisposed() {
        this.eventBroker.unsubscribe(this.shellUpdater);
        this.eventBroker.unsubscribe(this.visibilityHandler);
        this.eventBroker.unsubscribe(this.sizeHandler);
    }

    public Object createWidget(MUIElement element, Object parent) {
        Shell wbwShell;
        if (!(element instanceof MWindow) || parent != null && !(parent instanceof Control)) {
            return null;
        }
        MWindow wbwModel = (MWindow)element;
        Shell parentShell = parent == null ? null : ((Control)parent).getShell();
        IEclipseContext parentContext = this.getContextForParent(element);
        if (parentShell == null) {
            wbwShell = new Shell(Display.getCurrent(), 1264);
        } else if (wbwModel.getTags().contains((Object)"dragHost")) {
            wbwShell = new Shell(parentShell, 2048);
            wbwShell.setAlpha(110);
        } else {
            wbwShell = new Shell(parentShell, 1076);
        }
        wbwShell.setBackgroundMode(1);
        wbwShell.setBounds(wbwModel.getX(), wbwModel.getY(), wbwModel.getWidth(), wbwModel.getHeight());
        TrimmedPartLayout tl = new TrimmedPartLayout((Composite)wbwShell);
        wbwShell.setLayout((Layout)tl);
        Shell newWidget = wbwShell;
        this.bindWidget(element, newWidget);
        IEclipseContext localContext = this.getContext((MUIElement)wbwModel);
        localContext.set("debugString", (Object)"MWindow");
        parentContext.set("activeChildContext", (Object)localContext);
        localContext.set(Shell.class.getName(), (Object)wbwShell);
        localContext.set("localActiveShell", (Object)wbwShell);
        localContext.set(IShellProvider.class.getName(), (Object)new IShellProvider(){

            public Shell getShell() {
                return wbwShell;
            }
        });
        if (wbwModel.getLabel() != null) {
            wbwShell.setText(wbwModel.getLabel());
        }
        wbwShell.setImage(this.getImage((MUILabel)wbwModel));
        wbwShell.setImages(Window.getDefaultImages());
        if (!wbwModel.getTags().contains((Object)"dragHost")) {
            new DnDManager(wbwModel);
        }
        return newWidget;
    }

    @Override
    public void hookControllerLogic(MUIElement me) {
        super.hookControllerLogic(me);
        Widget widget = (Widget)me.getWidget();
        if (widget instanceof Shell && me instanceof MWindow) {
            final Shell shell = (Shell)widget;
            final MWindow w = (MWindow)me;
            shell.addControlListener(new ControlListener(){

                public void controlResized(ControlEvent e) {
                    try {
                        WBWRenderer.this.ignoreSizeChanges = true;
                        w.setWidth(shell.getSize().x);
                        w.setHeight(shell.getSize().y);
                    }
                    finally {
                        WBWRenderer.this.ignoreSizeChanges = false;
                    }
                }

                public void controlMoved(ControlEvent e) {
                    try {
                        WBWRenderer.this.ignoreSizeChanges = true;
                        w.setX(shell.getLocation().x);
                        w.setY(shell.getLocation().y);
                    }
                    finally {
                        WBWRenderer.this.ignoreSizeChanges = false;
                    }
                }
            });
            shell.addShellListener((ShellListener)new ShellAdapter(){

                public void shellClosed(ShellEvent e) {
                    MContext context = (MContext)e.widget.getData("modelElement");
                    EPartService partService = (EPartService)context.getContext().get(EPartService.class.getName());
                    if (partService != null) {
                        e.doit = partService.saveAll(true);
                    }
                }
            });
            shell.addListener(26, new Listener(){

                public void handleEvent(Event event) {
                    IEclipseContext parentContext = WBWRenderer.this.getContextForParent((MUIElement)w);
                    MApplication app = (MApplication)w.getContext().get(MApplication.class.getName());
                    if (app != null && parentContext != null) {
                        if (app.getSelectedElement() == w) {
                            return;
                        }
                        app.setSelectedElement((MUIElement)w);
                        parentContext.set("activeChildContext", (Object)w.getContext());
                    }
                }
            });
        }
    }

    @Override
    public void processContents(MElementContainer<MUIElement> me) {
        if (!(me instanceof MWindow)) {
            return;
        }
        MWindow wbwModel = (MWindow)me;
        super.processContents(me);
        if (wbwModel.getMainMenu() != null) {
            IPresentationEngine renderer = (IPresentationEngine)this.context.get(IPresentationEngine.class.getName());
            renderer.createGui((MUIElement)wbwModel.getMainMenu(), me.getWidget());
            Shell shell = (Shell)me.getWidget();
            shell.setMenuBar((Menu)wbwModel.getMainMenu().getWidget());
        }
    }

    public Object getUIContainer(MUIElement element) {
        if (element instanceof MTrimContainer) {
            return super.getUIContainer(element);
        }
        Composite shellComp = (Composite)element.getParent().getWidget();
        if (element instanceof MWindow) {
            return shellComp;
        }
        TrimmedPartLayout tpl = (TrimmedPartLayout)shellComp.getLayout();
        return tpl.clientArea;
    }

    public void postProcess(MUIElement childME) {
        super.postProcess(childME);
        Shell shell = (Shell)childME.getWidget();
        shell.layout(true);
        if (childME.isVisible()) {
            shell.open();
        } else {
            shell.setVisible(false);
        }
    }

    private Object[] promptForSave(Shell parentShell, Collection<MPart> saveableParts) {
        SaveablePartPromptDialog dialog = new SaveablePartPromptDialog(parentShell, saveableParts);
        if (dialog.open() == 1) {
            return null;
        }
        return dialog.getCheckedElements();
    }

    private void applyDialogStyles(Control control) {
        IStylingEngine engine = (IStylingEngine)this.context.get(IStylingEngine.SERVICE_NAME);
        if (engine != null) {
            Shell shell = control.getShell();
            if (shell.getBackgroundMode() == 0) {
                shell.setBackgroundMode(1);
            }
            engine.style((Object)shell);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class SaveablePartPromptDialog
    extends Dialog {
        private Collection<MPart> collection;
        private CheckboxTableViewer tableViewer;
        private Object[] checkedElements;

        SaveablePartPromptDialog(Shell shell, Collection<MPart> collection) {
            super(shell);
            this.checkedElements = new Object[0];
            this.collection = collection;
        }

        protected Control createDialogArea(Composite parent) {
            parent = (Composite)super.createDialogArea(parent);
            Label label = new Label(parent, 16384);
            label.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            label.setText("Select the parts to save:");
            this.tableViewer = CheckboxTableViewer.newCheckList((Composite)parent, (int)2052);
            GridData data = new GridData(4, 4, true, true);
            data.heightHint = 250;
            data.widthHint = 300;
            this.tableViewer.getControl().setLayoutData((Object)data);
            this.tableViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

                public String getText(Object element) {
                    return ((MPart)element).getLabel();
                }
            });
            this.tableViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
            this.tableViewer.setInput(this.collection);
            this.tableViewer.setAllChecked(true);
            return parent;
        }

        public void create() {
            super.create();
            WBWRenderer.this.applyDialogStyles((Control)this.getShell());
        }

        protected void okPressed() {
            this.checkedElements = this.tableViewer.getCheckedElements();
            super.okPressed();
        }

        public Object[] getCheckedElements() {
            return this.checkedElements;
        }
    }

    private class WindowSizeUpdateJob
    implements Runnable {
        public List<MWindow> windowsToUpdate = new ArrayList<MWindow>();

        private WindowSizeUpdateJob() {
        }

        public void run() {
            WBWRenderer.this.clearSizeUpdate();
            while (!this.windowsToUpdate.isEmpty()) {
                MWindow window = this.windowsToUpdate.remove(0);
                Shell shell = (Shell)window.getWidget();
                if (shell == null || shell.isDisposed()) continue;
                shell.setBounds(window.getX(), window.getY(), window.getWidth(), window.getHeight());
            }
        }
    }
}

