/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.css.swt.properties.css2;

import org.eclipse.e4.ui.css.core.dom.properties.css2.AbstractCSSPropertyPaddingHandler;
import org.eclipse.e4.ui.css.core.dom.properties.css2.ICSSPropertyPaddingHandler;
import org.eclipse.e4.ui.css.core.engine.CSSEngine;
import org.eclipse.e4.ui.css.swt.helpers.SWTElementHelpers;
import org.eclipse.swt.widgets.Widget;
import org.w3c.css.sac.CSSException;
import org.w3c.dom.css.CSSValue;
import org.w3c.dom.css.CSSValueList;

public class CSSPropertyPaddingSWTHandler
extends AbstractCSSPropertyPaddingHandler {
    public static final ICSSPropertyPaddingHandler INSTANCE = new CSSPropertyPaddingSWTHandler();
    private static final int TOP = 0;
    private static final int RIGHT = 1;
    private static final int BOTTOM = 2;
    private static final int LEFT = 3;

    public boolean applyCSSProperty(Object element, String property, CSSValue value, String pseudo, CSSEngine engine) throws Exception {
        Widget widget = SWTElementHelpers.getWidget(element);
        if (widget == null) {
            return false;
        }
        super.applyCSSProperty(element, property, value, pseudo, engine);
        return true;
    }

    public void applyCSSPropertyPadding(Object element, CSSValue value, String pseudo, CSSEngine engine) throws Exception {
        if (value.getCssValueType() == 1) {
            this.setPadding(element, 0, value, pseudo);
            this.setPadding(element, 1, value, pseudo);
            this.setPadding(element, 2, value, pseudo);
            this.setPadding(element, 3, value, pseudo);
            return;
        }
        if (value.getCssValueType() == 2) {
            CSSValueList valueList = (CSSValueList)value;
            int length = valueList.getLength();
            if (length < 2 || length > 4) {
                throw new CSSException("Invalid padding property list length");
            }
            switch (length) {
                case 4: {
                    this.setPadding(element, 0, valueList.item(0), pseudo);
                    this.setPadding(element, 1, valueList.item(1), pseudo);
                    this.setPadding(element, 2, valueList.item(2), pseudo);
                    this.setPadding(element, 3, valueList.item(3), pseudo);
                    break;
                }
                case 3: {
                    this.setPadding(element, 0, valueList.item(0), pseudo);
                    this.setPadding(element, 1, valueList.item(1), pseudo);
                    this.setPadding(element, 2, valueList.item(2), pseudo);
                    this.setPadding(element, 3, valueList.item(1), pseudo);
                }
                case 2: {
                    this.setPadding(element, 0, valueList.item(0), pseudo);
                    this.setPadding(element, 1, valueList.item(1), pseudo);
                    this.setPadding(element, 2, valueList.item(0), pseudo);
                    this.setPadding(element, 3, valueList.item(1), pseudo);
                }
            }
        } else {
            throw new CSSException("Invalid padding property value");
        }
    }

    public void applyCSSPropertyPaddingTop(Object element, CSSValue value, String pseudo, CSSEngine engine) throws Exception {
        this.setPadding(element, 0, value, pseudo);
    }

    public void applyCSSPropertyPaddingRight(Object element, CSSValue value, String pseudo, CSSEngine engine) throws Exception {
        this.setPadding(element, 1, value, pseudo);
    }

    public void applyCSSPropertyPaddingBottom(Object element, CSSValue value, String pseudo, CSSEngine engine) throws Exception {
        this.setPadding(element, 2, value, pseudo);
    }

    public void applyCSSPropertyPaddingLeft(Object element, CSSValue value, String pseudo, CSSEngine engine) throws Exception {
        this.setPadding(element, 3, value, pseudo);
    }

    public String retrieveCSSPropertyPadding(Object element, String pseudo, CSSEngine engine) throws Exception {
        return null;
    }

    public String retrieveCSSPropertyPaddingTop(Object element, String pseudo, CSSEngine engine) throws Exception {
        return null;
    }

    public String retrieveCSSPropertyPaddingRight(Object element, String pseudo, CSSEngine engine) throws Exception {
        return null;
    }

    public String retrieveCSSPropertyPaddingBottom(Object element, String pseudo, CSSEngine engine) throws Exception {
        return null;
    }

    public String retrieveCSSPropertyPaddingLeft(Object element, String pseudo, CSSEngine engine) throws Exception {
        return null;
    }

    private void setPadding(Object element, int side, CSSValue value, String pseudo) {
        if (value.getCssValueType() != 1) {
            return;
        }
        SWTElementHelpers.getWidget(element);
    }
}

