/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.views.markers;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.jface.resource.JFaceColors;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.internal.views.markers.ExtendedMarkersView;
import org.eclipse.ui.preferences.ViewSettingsDialog;
import org.eclipse.ui.views.markers.MarkerField;
import org.eclipse.ui.views.markers.internal.MarkerMessages;

public class MarkerPreferencesDialog
extends ViewSettingsDialog {
    private IntegerFieldEditor limitEditor;
    private Button enablementButton;
    private Composite editArea;
    private Label messageLabel;
    private ExtendedMarkersView extendedView;
    private ArrayList visible;
    private ArrayList hidden;
    private ListViewer visibleViewer;
    private ListViewer nonVisibleViewer;

    public MarkerPreferencesDialog(ExtendedMarkersView view) {
        super(view.getSite().getShell());
        this.extendedView = view;
        MarkerField[] visibleFields = view.getVisibleFields();
        Object[] hiddenFields = view.getHiddenFields();
        this.visible = new ArrayList();
        this.hidden = new ArrayList();
        int i = 0;
        while (i < visibleFields.length) {
            this.visible.add(visibleFields[i]);
            ++i;
        }
        i = 0;
        while (i < hiddenFields.length) {
            this.hidden.add(hiddenFields[i]);
            ++i;
        }
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(MarkerMessages.MarkerPreferences_DialogTitle);
    }

    protected int getShellStyle() {
        return super.getShellStyle() | 0x10;
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        boolean checked = IDEWorkbenchPlugin.getDefault().getPreferenceStore().getBoolean("USE_MARKER_LIMITS");
        this.enablementButton = new Button(dialogArea, 32);
        this.enablementButton.setText(MarkerMessages.MarkerPreferences_MarkerLimits);
        this.enablementButton.setSelection(checked);
        this.editArea = new Composite(dialogArea, 0);
        this.editArea.setLayout((Layout)new GridLayout());
        GridData editData = new GridData(1808);
        editData.horizontalIndent = 10;
        this.editArea.setLayoutData((Object)editData);
        this.limitEditor = new IntegerFieldEditor("limit", MarkerMessages.MarkerPreferences_VisibleItems, this.editArea){

            protected boolean checkState() {
                boolean state = super.checkState();
                MarkerPreferencesDialog.this.setValid(state, this.getErrorMessage());
                return state;
            }
        };
        this.limitEditor.setPreferenceStore(IDEWorkbenchPlugin.getDefault().getPreferenceStore());
        this.limitEditor.setPreferenceName("MARKER_LIMITS_VALUE");
        this.limitEditor.load();
        GridData checkedData = new GridData(4, 0, true, false);
        checkedData.horizontalSpan = this.limitEditor.getNumberOfControls();
        this.enablementButton.setLayoutData((Object)checkedData);
        this.enablementButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MarkerPreferencesDialog.this.setLimitEditorEnablement(MarkerPreferencesDialog.this.editArea, MarkerPreferencesDialog.this.enablementButton.getSelection());
            }
        });
        this.setLimitEditorEnablement(this.editArea, checked);
        this.messageLabel = new Label(dialogArea, 0);
        this.messageLabel.setBackground(JFaceColors.getErrorBackground((Display)dialogArea.getDisplay()));
        this.messageLabel.setForeground(JFaceColors.getErrorText((Display)dialogArea.getDisplay()));
        this.messageLabel.setLayoutData((Object)new GridData(4, 0, true, false));
        this.createColumnsArea(dialogArea);
        MarkerPreferencesDialog.applyDialogFont((Control)dialogArea);
        return dialogArea;
    }

    private void createColumnsArea(Composite dialogArea) {
        this.initializeDialogUnits((Control)dialogArea);
        Group columnsComposite = new Group(dialogArea, 0);
        columnsComposite.setText(MarkerMessages.MarkerPreferences_ColumnGroupTitle);
        FormLayout layout = new FormLayout();
        columnsComposite.setLayout((Layout)layout);
        columnsComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        Label visibleItemsLabel = new Label((Composite)columnsComposite, 0);
        visibleItemsLabel.setText(MarkerMessages.MarkerPreferences_VisibleColumnsTitle);
        FormData visibleLabelData = new FormData();
        visibleLabelData.right = new FormAttachment(45, 0);
        visibleLabelData.left = new FormAttachment(4);
        visibleLabelData.top = new FormAttachment(0);
        visibleItemsLabel.setLayoutData((Object)visibleLabelData);
        int rightMargin = -4;
        Label nonVisibleLabel = new Label((Composite)columnsComposite, 0);
        nonVisibleLabel.setText(MarkerMessages.MarkerPreferences_HiddenColumnsTitle);
        FormData nonVisibleLabelData = new FormData();
        nonVisibleLabelData.right = new FormAttachment(100);
        nonVisibleLabelData.left = new FormAttachment(55, 0);
        nonVisibleLabelData.top = new FormAttachment(0);
        nonVisibleLabel.setLayoutData((Object)nonVisibleLabelData);
        this.visibleViewer = new ListViewer((Composite)columnsComposite, 2048);
        FormData visibleViewerData = new FormData();
        visibleViewerData.right = new FormAttachment((Control)visibleItemsLabel, 0, 131072);
        visibleViewerData.left = new FormAttachment((Control)visibleItemsLabel, 0, 16384);
        visibleViewerData.top = new FormAttachment((Control)visibleItemsLabel, 4);
        visibleViewerData.bottom = new FormAttachment(100, rightMargin);
        visibleViewerData.height = this.convertHeightInCharsToPixels(15);
        visibleViewerData.width = this.convertWidthInCharsToPixels(25);
        this.visibleViewer.getControl().setLayoutData((Object)visibleViewerData);
        this.visibleViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                return MarkerPreferencesDialog.this.visible.toArray();
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.visibleViewer.setLabelProvider((IBaseLabelProvider)this.markerFieldLabelProvider());
        this.visibleViewer.setInput((Object)this);
        this.nonVisibleViewer = new ListViewer((Composite)columnsComposite, 2048);
        this.nonVisibleViewer.setLabelProvider((IBaseLabelProvider)this.markerFieldLabelProvider());
        this.nonVisibleViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                return MarkerPreferencesDialog.this.hidden.toArray();
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.nonVisibleViewer.setInput((Object)this);
        FormData nonVisibleViewerData = new FormData();
        nonVisibleViewerData.right = new FormAttachment((Control)nonVisibleLabel, 0, 131072);
        nonVisibleViewerData.left = new FormAttachment((Control)nonVisibleLabel, 0, 16384);
        nonVisibleViewerData.top = new FormAttachment((Control)nonVisibleLabel, 4);
        nonVisibleViewerData.bottom = new FormAttachment(100, rightMargin);
        nonVisibleViewerData.height = this.convertHeightInCharsToPixels(15);
        nonVisibleViewerData.width = this.convertWidthInCharsToPixels(25);
        this.nonVisibleViewer.getControl().setLayoutData((Object)nonVisibleViewerData);
        Button toNonVisibleButton = new Button((Composite)columnsComposite, 8);
        toNonVisibleButton.setText(MarkerPreferencesDialog.getDefaultOrientation() == 0x4000000 ? MarkerMessages.MarkerPreferences_MoveLeft : MarkerMessages.MarkerPreferences_MoveRight);
        FormData toNonVisibleButtonData = new FormData();
        toNonVisibleButtonData.top = new FormAttachment(this.visibleViewer.getControl(), 25, 128);
        toNonVisibleButtonData.left = new FormAttachment(this.visibleViewer.getControl(), 4);
        toNonVisibleButtonData.right = new FormAttachment(this.nonVisibleViewer.getControl(), rightMargin);
        toNonVisibleButton.setLayoutData((Object)toNonVisibleButtonData);
        toNonVisibleButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                List selection = ((IStructuredSelection)MarkerPreferencesDialog.this.visibleViewer.getSelection()).toList();
                MarkerPreferencesDialog.this.hidden.addAll(selection);
                MarkerPreferencesDialog.this.visible.removeAll(selection);
                MarkerPreferencesDialog.this.visibleViewer.refresh();
                MarkerPreferencesDialog.this.nonVisibleViewer.refresh();
                MarkerPreferencesDialog.this.setValid(MarkerPreferencesDialog.this.visible.size() > 0, MarkerMessages.MarkerPreferences_AtLeastOneVisibleColumn);
            }
        });
        Button toVisibleButton = new Button((Composite)columnsComposite, 8);
        toVisibleButton.setText(MarkerPreferencesDialog.getDefaultOrientation() == 0x4000000 ? MarkerMessages.MarkerPreferences_MoveRight : MarkerMessages.MarkerPreferences_MoveLeft);
        FormData toVisibleButtonData = new FormData();
        toVisibleButtonData.top = new FormAttachment((Control)toNonVisibleButton, 4);
        toVisibleButtonData.left = new FormAttachment(this.visibleViewer.getControl(), 4);
        toVisibleButtonData.right = new FormAttachment(this.nonVisibleViewer.getControl(), rightMargin);
        toVisibleButton.setLayoutData((Object)toVisibleButtonData);
        toVisibleButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                List selection = ((IStructuredSelection)MarkerPreferencesDialog.this.nonVisibleViewer.getSelection()).toList();
                MarkerPreferencesDialog.this.hidden.removeAll(selection);
                MarkerPreferencesDialog.this.visible.addAll(selection);
                MarkerPreferencesDialog.this.visibleViewer.refresh();
                MarkerPreferencesDialog.this.nonVisibleViewer.refresh();
                MarkerPreferencesDialog.this.setValid(MarkerPreferencesDialog.this.visible.size() > 0, MarkerMessages.MarkerPreferences_AtLeastOneVisibleColumn);
            }
        });
    }

    private LabelProvider markerFieldLabelProvider() {
        return new LabelProvider(){

            public String getText(Object element) {
                return ((MarkerField)element).getName();
            }
        };
    }

    protected void setValid(boolean state, String errorMessage) {
        Button okButton = this.getButton(0);
        if (okButton == null) {
            return;
        }
        if (state) {
            this.messageLabel.setText("");
        } else {
            this.messageLabel.setText(errorMessage);
        }
        okButton.setEnabled(state);
    }

    private void setLimitEditorEnablement(Composite control, boolean checked) {
        this.limitEditor.setEnabled(checked, control);
    }

    protected void okPressed() {
        this.limitEditor.store();
        IDEWorkbenchPlugin.getDefault().getPreferenceStore().setValue("USE_MARKER_LIMITS", this.enablementButton.getSelection());
        IDEWorkbenchPlugin.getDefault().savePluginPreferences();
        this.extendedView.setVisibleFields(this.visible);
        super.okPressed();
    }

    protected void performDefaults() {
        super.performDefaults();
        this.limitEditor.loadDefault();
        boolean checked = IDEWorkbenchPlugin.getDefault().getPreferenceStore().getDefaultBoolean("USE_MARKER_LIMITS");
        this.enablementButton.setSelection(checked);
        this.setLimitEditorEnablement(this.editArea, checked);
        MarkerField[] visibleFields = this.extendedView.getBuilder().getGenerator().getInitialVisible();
        MarkerField[] allFields = this.extendedView.getBuilder().getGenerator().getAllFields();
        this.visible.clear();
        this.hidden.clear();
        int i = 0;
        while (i < allFields.length) {
            this.hidden.add(allFields[i]);
            ++i;
        }
        i = 0;
        while (i < visibleFields.length) {
            this.hidden.remove(visibleFields[i]);
            this.visible.add(visibleFields[i]);
            ++i;
        }
        this.visibleViewer.refresh();
        this.nonVisibleViewer.refresh();
    }
}

