/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.operations;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.equinox.internal.p2.core.helpers.CollectionUtils;
import org.eclipse.equinox.internal.p2.operations.Messages;
import org.eclipse.equinox.internal.p2.operations.PlanAnalyzer;
import org.eclipse.equinox.internal.provisional.p2.director.ProfileChangeRequest;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.engine.query.UserVisibleRootQuery;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IVersionedId;
import org.eclipse.equinox.p2.operations.ProfileChangeOperation;
import org.eclipse.equinox.p2.operations.ProvisioningSession;
import org.eclipse.equinox.p2.operations.Update;
import org.eclipse.equinox.p2.planner.ProfileInclusionRules;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.QueryUtil;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UpdateOperation
extends ProfileChangeOperation {
    public static final int STATUS_NOTHING_TO_UPDATE = 10000;
    private Collection<IInstallableUnit> iusToUpdate;
    private HashMap<IInstallableUnit, List<Update>> possibleUpdatesByIU = new HashMap();
    private List<Update> defaultUpdates;

    public UpdateOperation(ProvisioningSession session, Collection<IInstallableUnit> toBeUpdated) {
        super(session);
        this.iusToUpdate = toBeUpdated;
    }

    public UpdateOperation(ProvisioningSession session) {
        this(session, null);
    }

    public void setSelectedUpdates(Update[] defaultUpdates) {
        this.defaultUpdates = new ArrayList<Update>(Arrays.asList(defaultUpdates));
    }

    public Update[] getSelectedUpdates() {
        if (this.defaultUpdates == null) {
            return new Update[0];
        }
        return this.defaultUpdates.toArray(new Update[this.defaultUpdates.size()]);
    }

    public Update[] getPossibleUpdates() {
        ArrayList<Update> all = new ArrayList<Update>();
        for (List<Update> updates : this.possibleUpdatesByIU.values()) {
            all.addAll(updates);
        }
        return all.toArray(new Update[all.size()]);
    }

    private Update[] updatesFor(IInstallableUnit iu, IProfile profile, IProgressMonitor monitor) {
        List<Update> updates;
        if (this.possibleUpdatesByIU.containsKey(iu)) {
            updates = this.possibleUpdatesByIU.get(iu);
        } else {
            IQueryResult replacements = this.session.getPlanner().updatesFor(iu, this.context, monitor);
            updates = new ArrayList<Update>();
            for (IInstallableUnit replacementIU : replacements) {
                IQueryResult alreadyInstalled = profile.query(QueryUtil.createIUQuery((IVersionedId)replacementIU), null);
                if (!alreadyInstalled.isEmpty()) continue;
                Update update = new Update(iu, replacementIU);
                updates.add(update);
            }
            this.possibleUpdatesByIU.put(iu, updates);
        }
        return updates.toArray(new Update[updates.size()]);
    }

    @Override
    protected void computeProfileChangeRequest(MultiStatus status, IProgressMonitor monitor) {
        HashSet<IInstallableUnit> toBeUpdated = new HashSet<IInstallableUnit>();
        HashSet<Update> elementsToPlan = new HashSet<Update>();
        boolean selectionSpecified = this.defaultUpdates != null;
        IProfile profile = this.session.getProfileRegistry().getProfile(this.profileId);
        if (profile == null) {
            return;
        }
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.UpdateOperation_ProfileChangeRequestProgress, (int)(100 * this.iusToUpdate.size()));
        for (IInstallableUnit iuToUpdate : this.iusToUpdate) {
            SubMonitor iuMon = sub.newChild(100);
            Update[] updates = this.updatesFor(iuToUpdate, profile, (IProgressMonitor)iuMon);
            int j = 0;
            while (j < updates.length) {
                toBeUpdated.add(iuToUpdate);
                if (this.defaultUpdates != null && this.defaultUpdates.contains(updates[j])) {
                    elementsToPlan.add(updates[j]);
                }
                ++j;
            }
            if (!selectionSpecified) {
                HashMap<String, Update> latestVersions = new HashMap<String, Update>();
                boolean foundUpdate = false;
                boolean foundPatch = false;
                int j2 = 0;
                while (j2 < updates.length) {
                    IInstallableUnit latestIU;
                    String key;
                    if (QueryUtil.isPatch((IInstallableUnit)updates[j2].replacement)) {
                        foundPatch = true;
                        key = updates[j2].replacement.getId();
                    } else {
                        foundUpdate = true;
                        key = updates[j2].toUpdate.getId();
                    }
                    Update latestUpdate = (Update)latestVersions.get(key);
                    IInstallableUnit iInstallableUnit = latestIU = latestUpdate == null ? null : latestUpdate.replacement;
                    if (latestIU == null || updates[j2].replacement.getVersion().compareTo((Object)latestIU.getVersion()) > 0) {
                        latestVersions.put(key, updates[j2]);
                    }
                    ++j2;
                }
                if (foundPatch && foundUpdate) {
                    HashSet keys = new HashSet();
                    keys.addAll(latestVersions.keySet());
                    for (String id : keys) {
                        if (id.equals(iuToUpdate.getId())) continue;
                        latestVersions.remove(id);
                    }
                }
                elementsToPlan.addAll(latestVersions.values());
            }
            sub.worked(100);
        }
        if (toBeUpdated.size() <= 0 || elementsToPlan.isEmpty()) {
            sub.done();
            status.add(PlanAnalyzer.getStatus(10000, null));
            return;
        }
        this.request = ProfileChangeRequest.createByProfileId((IProvisioningAgent)this.session.getProvisioningAgent(), (String)this.profileId);
        for (Update update : elementsToPlan) {
            IInstallableUnit theUpdate = update.replacement;
            if (this.defaultUpdates == null) {
                this.defaultUpdates = new ArrayList<Update>();
                this.defaultUpdates.add(update);
            } else if (!this.defaultUpdates.contains(update)) {
                this.defaultUpdates.add(update);
            }
            this.request.add(theUpdate);
            this.request.setInstallableUnitProfileProperty(theUpdate, "org.eclipse.equinox.p2.type.root", Boolean.toString(true));
            if (QueryUtil.isPatch((IInstallableUnit)theUpdate)) {
                this.request.setInstallableUnitInclusionRules(theUpdate, ProfileInclusionRules.createOptionalInclusionRule((IInstallableUnit)theUpdate));
                continue;
            }
            this.request.remove(update.toUpdate);
        }
        sub.done();
    }

    @Override
    protected String getProvisioningJobName() {
        return Messages.UpdateOperation_UpdateJobName;
    }

    @Override
    protected String getResolveJobName() {
        return Messages.UpdateOperation_ResolveJobName;
    }

    @Override
    protected void prepareToResolve() {
        super.prepareToResolve();
        if (this.iusToUpdate == null) {
            this.iusToUpdate = this.getInstalledIUs();
        }
    }

    private Collection<IInstallableUnit> getInstalledIUs() {
        IProfile profile = this.session.getProfileRegistry().getProfile(this.profileId);
        if (profile == null) {
            return CollectionUtils.emptyList();
        }
        UserVisibleRootQuery query = new UserVisibleRootQuery();
        IQueryResult queryResult = profile.query((IQuery)query, null);
        return queryResult.toUnmodifiableSet();
    }
}

