/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.HelpListener;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.cocoa.NSApplication;
import org.eclipse.swt.internal.cocoa.NSEvent;
import org.eclipse.swt.internal.cocoa.NSMenu;
import org.eclipse.swt.internal.cocoa.NSMenuItem;
import org.eclipse.swt.internal.cocoa.NSPoint;
import org.eclipse.swt.internal.cocoa.NSString;
import org.eclipse.swt.internal.cocoa.NSView;
import org.eclipse.swt.internal.cocoa.NSWindow;
import org.eclipse.swt.internal.cocoa.OS;
import org.eclipse.swt.internal.cocoa.SWTMenu;
import org.eclipse.swt.internal.cocoa.SWTMenuItem;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TrayItem;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.widgets.Widget;

public class Menu
extends Widget {
    NSMenu nsMenu;
    int x;
    int y;
    int itemCount;
    boolean hasLocation;
    boolean visible;
    MenuItem[] items;
    MenuItem cascade;
    MenuItem defaultItem;
    Decorations parent;

    public Menu(Control parent) {
        this(Menu.checkNull(parent).menuShell(), 8);
    }

    public Menu(Decorations parent, int style) {
        super(parent, Menu.checkStyle(style));
        this.parent = parent;
        this.createWidget();
    }

    public Menu(Menu parentMenu) {
        this(Menu.checkNull((Menu)parentMenu).parent, 4);
    }

    public Menu(MenuItem parentItem) {
        this(Menu.checkNull((MenuItem)parentItem).parent);
    }

    static Control checkNull(Control control) {
        if (control == null) {
            SWT.error(4);
        }
        return control;
    }

    static Menu checkNull(Menu menu) {
        if (menu == null) {
            SWT.error(4);
        }
        return menu;
    }

    static MenuItem checkNull(MenuItem item) {
        if (item == null) {
            SWT.error(4);
        }
        return item;
    }

    static int checkStyle(int style) {
        return Menu.checkBits(style, 8, 2, 4, 0, 0, 0);
    }

    void _setVisible(boolean visible) {
        if ((this.style & 6) != 0) {
            return;
        }
        TrayItem trayItem = this.display.currentTrayItem;
        if (trayItem != null && visible) {
            trayItem.showMenu(this);
            return;
        }
        if (visible) {
            Shell shell = this.getShell();
            NSWindow window = shell.view.window();
            NSPoint location = null;
            if (this.hasLocation) {
                NSView topView = window.contentView();
                Point shellCoord = this.display.map(null, (Control)shell, new Point(this.x, this.y));
                location = new NSPoint();
                double scaleFactor = window.userSpaceScaleFactor();
                location.x = (double)shellCoord.x * scaleFactor;
                location.y = (topView.frame().height - (double)shellCoord.y) * scaleFactor;
            } else {
                location = window.mouseLocationOutsideOfEventStream();
            }
            window.retain();
            NSEvent nsEvent = NSEvent.otherEventWithType(15L, location, 0L, 0.0, window.windowNumber(), window.graphicsContext(), (short)0, 0L, 0L);
            NSMenu.popUpContextMenu(this.nsMenu, nsEvent, shell.view);
            window.release();
        } else {
            this.nsMenu.cancelTracking();
        }
    }

    public void addHelpListener(HelpListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(28, typedListener);
    }

    public void addMenuListener(MenuListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(23, typedListener);
        this.addListener(22, typedListener);
    }

    void createHandle() {
        this.display.addMenu(this);
        NSMenu widget = (NSMenu)new SWTMenu().alloc();
        widget = widget.initWithTitle(NSString.string());
        widget.setAutoenablesItems(false);
        widget.setDelegate(widget);
        this.nsMenu = widget;
    }

    void createItem(MenuItem item, int index) {
        NSApplication application;
        NSMenu menubar;
        if (index < 0 || index > this.itemCount) {
            this.error(6);
        }
        NSMenuItem nsItem = null;
        if ((item.style & 2) != 0) {
            nsItem = NSMenuItem.separatorItem();
            nsItem.retain();
        } else {
            nsItem = (NSMenuItem)new SWTMenuItem().alloc();
            NSString empty = NSString.string();
            nsItem.initWithTitle(empty, 0L, empty);
            nsItem.setTarget(nsItem);
            nsItem.setAction(OS.sel_sendSelection);
        }
        item.nsItem = nsItem;
        item.createJNIRef();
        item.register();
        this.nsMenu.insertItem(nsItem, index);
        if (this.itemCount == this.items.length) {
            MenuItem[] newItems = new MenuItem[this.items.length + 4];
            System.arraycopy(this.items, 0, newItems, 0, this.items.length);
            this.items = newItems;
        }
        System.arraycopy(this.items, index, this.items, index + 1, this.itemCount++ - index);
        this.items[index] = item;
        NSMenu emptyMenu = item.createEmptyMenu();
        if (emptyMenu != null) {
            nsItem.setSubmenu(emptyMenu);
            emptyMenu.release();
        }
        if (this.display.menuBar == this && (menubar = (application = this.display.application).mainMenu()) != null) {
            nsItem.setMenu(null);
            menubar.insertItem(nsItem, index + 1);
        }
        if (!this.getEnabled()) {
            nsItem.setEnabled(false);
        }
    }

    void createWidget() {
        this.checkOrientation(this.parent);
        super.createWidget();
        this.items = new MenuItem[4];
    }

    void deregister() {
        super.deregister();
        this.display.removeWidget(this.nsMenu);
    }

    void destroyItem(MenuItem item) {
        NSApplication application;
        NSMenu menubar;
        int index = 0;
        while (index < this.itemCount) {
            if (this.items[index] == item) break;
            ++index;
        }
        if (index == this.itemCount) {
            return;
        }
        System.arraycopy(this.items, index + 1, this.items, index, --this.itemCount - index);
        this.items[this.itemCount] = null;
        if (this.itemCount == 0) {
            this.items = new MenuItem[4];
        }
        this.nsMenu.removeItem(item.nsItem);
        if (this.display.menuBar == this && (menubar = (application = this.display.application).mainMenu()) != null) {
            NSMenuItem nsItem = item.nsItem;
            menubar.removeItem(nsItem);
        }
    }

    void fixMenus(Decorations newParent) {
        this.parent = newParent;
    }

    public MenuItem getDefaultItem() {
        this.checkWidget();
        return this.defaultItem;
    }

    public boolean getEnabled() {
        this.checkWidget();
        return (this.state & 8) == 0;
    }

    public MenuItem getItem(int index) {
        this.checkWidget();
        if (index < 0 || index >= this.itemCount) {
            this.error(6);
        }
        return this.items[index];
    }

    public int getItemCount() {
        this.checkWidget();
        return this.itemCount;
    }

    public MenuItem[] getItems() {
        this.checkWidget();
        MenuItem[] result = new MenuItem[this.itemCount];
        int index = 0;
        if (this.items != null) {
            int i = 0;
            while (i < this.itemCount) {
                MenuItem item = this.items[i];
                if (item != null && !item.isDisposed()) {
                    result[index++] = item;
                }
                ++i;
            }
        }
        if (index != result.length) {
            MenuItem[] newItems = new MenuItem[index];
            System.arraycopy(result, 0, newItems, 0, index);
            result = newItems;
        }
        return result;
    }

    String getNameText() {
        String result = "";
        MenuItem[] items = this.getItems();
        int length = items.length;
        if (length > 0) {
            int i = 0;
            while (i < length - 1) {
                result = String.valueOf(result) + items[i].getNameText() + ", ";
                ++i;
            }
            result = String.valueOf(result) + items[length - 1].getNameText();
        }
        return result;
    }

    public Decorations getParent() {
        this.checkWidget();
        return this.parent;
    }

    public MenuItem getParentItem() {
        this.checkWidget();
        return this.cascade;
    }

    public Menu getParentMenu() {
        this.checkWidget();
        if (this.cascade != null) {
            return this.cascade.parent;
        }
        return null;
    }

    public Shell getShell() {
        this.checkWidget();
        return this.parent.getShell();
    }

    public boolean getVisible() {
        this.checkWidget();
        if ((this.style & 2) != 0) {
            return this == this.parent.menuShell().menuBar;
        }
        if ((this.style & 8) != 0) {
            Menu[] popups = this.display.popups;
            if (popups == null) {
                return false;
            }
            int i = 0;
            while (i < popups.length) {
                if (popups[i] == this) {
                    return true;
                }
                ++i;
            }
        }
        return this.visible;
    }

    public int indexOf(MenuItem item) {
        this.checkWidget();
        if (item == null) {
            this.error(4);
        }
        int i = 0;
        while (i < this.itemCount) {
            if (this.items[i] == item) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public boolean isEnabled() {
        this.checkWidget();
        Menu parentMenu = this.getParentMenu();
        if (parentMenu == null) {
            return this.getEnabled() && this.parent.isEnabled();
        }
        return this.getEnabled() && parentMenu.isEnabled();
    }

    public boolean isVisible() {
        this.checkWidget();
        return this.getVisible();
    }

    void menu_willHighlightItem(long id2, long sel, long menu, long itemID) {
        Widget widget = this.display.getWidget(itemID);
        if (widget instanceof MenuItem) {
            MenuItem item = (MenuItem)widget;
            item.sendEvent(30);
        }
    }

    void menuNeedsUpdate(long id2, long sel, long menu) {
    }

    void menuWillOpen(long id2, long sel, long menu) {
        this.visible = true;
        this.sendEvent(22);
        if (this.isDisposed()) {
            return;
        }
        int i = 0;
        while (i < this.items.length) {
            MenuItem item = this.items[i];
            if (item != null) {
                item.updateAccelerator(true);
            }
            ++i;
        }
    }

    void menuDidClose(long id2, long sel, long menu) {
        this.sendEvent(23);
        if (this.isDisposed()) {
            return;
        }
        this.visible = false;
        int i = 0;
        while (i < this.items.length) {
            MenuItem item = this.items[i];
            if (item != null) {
                item.updateAccelerator(false);
            }
            ++i;
        }
    }

    void register() {
        super.register();
        this.display.addWidget(this.nsMenu, this);
    }

    void releaseChildren(boolean destroy) {
        if (this.items != null) {
            int i = 0;
            while (i < this.items.length) {
                MenuItem item = this.items[i];
                if (item != null && !item.isDisposed()) {
                    item.release(false);
                }
                ++i;
            }
            this.items = null;
        }
        super.releaseChildren(destroy);
    }

    void releaseHandle() {
        super.releaseHandle();
        if (this.nsMenu != null) {
            this.nsMenu.release();
        }
        this.nsMenu = null;
    }

    void releaseParent() {
        super.releaseParent();
        if (this.cascade != null) {
            this.cascade.setMenu(null);
        }
        if ((this.style & 2) != 0 && this == this.parent.menuBar) {
            this.parent.setMenuBar(null);
        }
    }

    void releaseWidget() {
        super.releaseWidget();
        this.display.removeMenu(this);
        this.parent = null;
        this.defaultItem = null;
        this.cascade = null;
    }

    public void removeHelpListener(HelpListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(28, listener);
    }

    public void removeMenuListener(MenuListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(23, listener);
        this.eventTable.unhook(22, listener);
    }

    void reskinChildren(int flags) {
        MenuItem[] items = this.getItems();
        int i = 0;
        while (i < items.length) {
            MenuItem item = items[i];
            item.reskin(flags);
            ++i;
        }
        super.reskinChildren(flags);
    }

    public void setDefaultItem(MenuItem item) {
        this.checkWidget();
        if (item != null && item.isDisposed()) {
            this.error(5);
        }
        this.defaultItem = item;
    }

    public void setEnabled(boolean enabled) {
        this.checkWidget();
        this.state = enabled ? (this.state &= 0xFFFFFFF7) : (this.state |= 8);
        int i = 0;
        while (i < this.items.length) {
            MenuItem item = this.items[i];
            if (item != null) {
                item.nsItem.setEnabled(enabled && item.getEnabled());
            }
            ++i;
        }
    }

    public void setLocation(int x, int y) {
        this.checkWidget();
        this.x = x;
        this.y = y;
        this.hasLocation = true;
    }

    public void setLocation(Point location) {
        this.checkWidget();
        if (location == null) {
            this.error(4);
        }
        this.setLocation(location.x, location.y);
    }

    public void setVisible(boolean visible) {
        this.checkWidget();
        if ((this.style & 6) != 0) {
            return;
        }
        if (visible) {
            this.display.addPopup(this);
        } else {
            this.display.removePopup(this);
        }
    }
}

