/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.cocoa.NSArray;
import org.eclipse.swt.internal.cocoa.NSEvent;
import org.eclipse.swt.internal.cocoa.NSGraphicsContext;
import org.eclipse.swt.internal.cocoa.NSMutableArray;
import org.eclipse.swt.internal.cocoa.NSNumber;
import org.eclipse.swt.internal.cocoa.NSPoint;
import org.eclipse.swt.internal.cocoa.NSRect;
import org.eclipse.swt.internal.cocoa.NSString;
import org.eclipse.swt.internal.cocoa.NSView;
import org.eclipse.swt.internal.cocoa.OS;
import org.eclipse.swt.internal.cocoa.SWTView;
import org.eclipse.swt.internal.cocoa.id;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.TypedListener;

public class Sash
extends Control {
    Cursor sizeCursor;
    boolean dragging;
    int lastX;
    int lastY;
    int startX;
    int startY;
    private static final int INCREMENT = 1;
    private static final int PAGE_INCREMENT = 9;
    NSArray accessibilityAttributes = null;

    public Sash(Composite parent, int style) {
        super(parent, Sash.checkStyle(style));
        int cursorStyle = (style & 0x200) != 0 ? 9 : 7;
        this.sizeCursor = new Cursor(this.display, cursorStyle);
    }

    long accessibilityAttributeNames(long id2, long sel) {
        if (this.accessibilityAttributes == null) {
            NSMutableArray ourAttributes = NSMutableArray.arrayWithCapacity(10L);
            ourAttributes.addObject(OS.NSAccessibilityRoleAttribute);
            ourAttributes.addObject(OS.NSAccessibilityRoleDescriptionAttribute);
            ourAttributes.addObject(OS.NSAccessibilityParentAttribute);
            ourAttributes.addObject(OS.NSAccessibilityPositionAttribute);
            ourAttributes.addObject(OS.NSAccessibilitySizeAttribute);
            ourAttributes.addObject(OS.NSAccessibilityWindowAttribute);
            ourAttributes.addObject(OS.NSAccessibilityTopLevelUIElementAttribute);
            ourAttributes.addObject(OS.NSAccessibilityFocusedAttribute);
            ourAttributes.addObject(OS.NSAccessibilityValueAttribute);
            ourAttributes.addObject(OS.NSAccessibilityMaxValueAttribute);
            ourAttributes.addObject(OS.NSAccessibilityMinValueAttribute);
            ourAttributes.addObject(OS.NSAccessibilityNextContentsAttribute);
            ourAttributes.addObject(OS.NSAccessibilityPreviousContentsAttribute);
            ourAttributes.addObject(OS.NSAccessibilityOrientationAttribute);
            if (this.accessible != null) {
                NSMutableArray extraAttributes = NSMutableArray.arrayWithCapacity(3L);
                extraAttributes.addObject(OS.NSAccessibilityHelpAttribute);
                extraAttributes.addObject(OS.NSAccessibilityDescriptionAttribute);
                extraAttributes.addObject(OS.NSAccessibilityTitleAttribute);
                int i = (int)extraAttributes.count() - 1;
                while (i >= 0) {
                    NSString attribute = new NSString(extraAttributes.objectAtIndex((long)((long)i)).id);
                    if (this.accessible.internal_accessibilityAttributeValue(attribute, -1) != null) {
                        ourAttributes.addObject(extraAttributes.objectAtIndex(i));
                    }
                    --i;
                }
            }
            this.accessibilityAttributes = ourAttributes;
            this.accessibilityAttributes.retain();
        }
        return this.accessibilityAttributes.id;
    }

    long accessibilityAttributeValue(long id2, long sel, long arg0) {
        Control[] children;
        id returnObject;
        long returnValue = 0L;
        NSString attributeName = new NSString(arg0);
        if (this.accessible != null && (returnObject = this.accessible.internal_accessibilityAttributeValue(attributeName, -1)) != null) {
            returnValue = returnObject.id;
        }
        if (returnValue != 0L) {
            return returnValue;
        }
        if (attributeName.isEqualToString(OS.NSAccessibilityRoleAttribute) || attributeName.isEqualToString(OS.NSAccessibilityRoleDescriptionAttribute)) {
            NSString roleText = OS.NSAccessibilitySplitterRole;
            if (attributeName.isEqualToString(OS.NSAccessibilityRoleAttribute)) {
                return roleText.id;
            }
            return OS.NSAccessibilityRoleDescription(roleText.id, 0L);
        }
        if (attributeName.isEqualToString(OS.NSAccessibilityEnabledAttribute)) {
            return NSNumber.numberWithBool((boolean)this.isEnabled()).id;
        }
        if (attributeName.isEqualToString(OS.NSAccessibilityOrientationAttribute)) {
            NSString orientation = (this.style & 0x200) != 0 ? OS.NSAccessibilityVerticalOrientationValue : OS.NSAccessibilityHorizontalOrientationValue;
            return orientation.id;
        }
        if (attributeName.isEqualToString(OS.NSAccessibilityValueAttribute)) {
            Point location = this.getLocation();
            int value = (this.style & 0x200) != 0 ? location.x : location.y;
            return NSNumber.numberWithInt((int)value).id;
        }
        if (attributeName.isEqualToString(OS.NSAccessibilityMaxValueAttribute)) {
            NSRect parentBounds = this.view.bounds();
            double maxValue = (this.style & 0x200) != 0 ? parentBounds.width : parentBounds.height;
            return NSNumber.numberWithInt((int)((int)maxValue)).id;
        }
        if (attributeName.isEqualToString(OS.NSAccessibilityMinValueAttribute)) {
            return NSNumber.numberWithInt((int)0).id;
        }
        if (attributeName.isEqualToString(OS.NSAccessibilityNextContentsAttribute)) {
            children = this.parent._getChildren();
            Control nextView = null;
            int i = 0;
            while (i < children.length) {
                if (children[i] == this && i < children.length - 1) {
                    nextView = children[i + 1];
                    break;
                }
                ++i;
            }
            if (nextView != null) {
                return NSArray.arrayWithObject((id)nextView.view).id;
            }
            return NSArray.array().id;
        }
        if (attributeName.isEqualToString(OS.NSAccessibilityPreviousContentsAttribute)) {
            children = this.parent._getChildren();
            Control nextView = null;
            int i = 0;
            while (i < children.length) {
                if (children[i] == this && i > 0) {
                    nextView = children[i - 1];
                    break;
                }
                ++i;
            }
            if (nextView != null) {
                return NSArray.arrayWithObject((id)nextView.view).id;
            }
            return NSArray.array().id;
        }
        return super.accessibilityAttributeValue(id2, sel, arg0);
    }

    boolean accessibilityIsIgnored(long id2, long sel) {
        return false;
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    static int checkStyle(int style) {
        return Sash.checkBits(style |= 0x10000, 256, 512, 0, 0, 0, 0);
    }

    boolean becomeFirstResponder(long id2, long sel) {
        boolean result = super.becomeFirstResponder(id2, sel);
        NSRect frame = this.view.frame();
        this.lastX = (int)frame.x;
        this.lastY = (int)frame.y;
        return result;
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        int width = 0;
        int height = 0;
        if ((this.style & 0x100) != 0) {
            width += 64;
            height += 5;
        } else {
            width += 5;
            height += 64;
        }
        if (wHint != -1) {
            width = wHint;
        }
        if (hHint != -1) {
            height = hHint;
        }
        return new Point(width, height);
    }

    void createHandle() {
        this.state |= 0x800;
        NSView widget = (NSView)new SWTView().alloc();
        widget.init();
        this.view = widget;
    }

    void drawBackground(long id2, NSGraphicsContext context, NSRect rect) {
        if (id2 != this.view.id) {
            return;
        }
        this.fillBackground(this.view, context, rect, -1);
    }

    Cursor findCursor() {
        Cursor cursor = super.findCursor();
        if (cursor == null) {
            int cursorType = (this.style & 0x100) != 0 ? 7 : 9;
            cursor = this.display.getSystemCursor(cursorType);
        }
        return cursor;
    }

    boolean sendKeyEvent(NSEvent nsEvent, int type) {
        super.sendKeyEvent(nsEvent, type);
        if (type == 1) {
            short keyCode = nsEvent.keyCode();
            switch (keyCode) {
                case 123: 
                case 124: 
                case 125: 
                case 126: {
                    int xChange = 0;
                    int yChange = 0;
                    int stepSize = 9;
                    long modifiers = nsEvent.modifierFlags();
                    if ((modifiers & 0x40000L) != 0L) {
                        stepSize = 1;
                    }
                    if ((this.style & 0x200) != 0) {
                        if (keyCode == 126 || keyCode == 125) break;
                        xChange = keyCode == 123 ? -stepSize : stepSize;
                    } else {
                        if (keyCode == 123 || keyCode == 124) break;
                        yChange = keyCode == 126 ? -stepSize : stepSize;
                    }
                    Rectangle bounds = this.getBounds();
                    int width = bounds.width;
                    int height = bounds.height;
                    Rectangle parentBounds = this.parent.getBounds();
                    int parentWidth = parentBounds.width;
                    int parentHeight = parentBounds.height;
                    int newX = this.lastX;
                    int newY = this.lastY;
                    if ((this.style & 0x200) != 0) {
                        newX = Math.min(Math.max(0, this.lastX + xChange), parentWidth - width);
                    } else {
                        newY = Math.min(Math.max(0, this.lastY + yChange), parentHeight - height);
                    }
                    if (newX == this.lastX && newY == this.lastY) {
                        return true;
                    }
                    Event event = new Event();
                    event.x = newX;
                    event.y = newY;
                    event.width = width;
                    event.height = height;
                    this.sendSelectionEvent(13, event, true);
                    if (this.isDisposed() || !event.doit) break;
                    this.setBounds(event.x, event.y, width, height);
                    if (this.isDisposed()) break;
                    this.lastX = event.x;
                    this.lastY = event.y;
                    if (this.isDisposed()) {
                        return false;
                    }
                    int cursorX = event.x;
                    int cursorY = event.y;
                    if ((this.style & 0x200) != 0) {
                        cursorY += height / 2;
                    } else {
                        cursorX += width / 2;
                    }
                    this.display.setCursorLocation(this.parent.toDisplay(cursorX, cursorY));
                }
            }
        }
        return true;
    }

    void mouseDown(long id2, long sel, long theEvent) {
        super.mouseDown(id2, sel, theEvent);
        if (this.isDisposed()) {
            return;
        }
        NSEvent nsEvent = new NSEvent(theEvent);
        if (nsEvent.clickCount() != 1L) {
            return;
        }
        NSPoint location = nsEvent.locationInWindow();
        NSPoint point = this.view.convertPoint_fromView_(location, null);
        this.startX = (int)point.x;
        this.startY = (int)point.y;
        NSRect frame = this.view.frame();
        Event event = new Event();
        event.x = (int)frame.x;
        event.y = (int)frame.y;
        event.width = (int)frame.width;
        event.height = (int)frame.height;
        this.sendSelectionEvent(13, event, true);
        if (this.isDisposed()) {
            return;
        }
        if (event.doit) {
            this.lastX = event.x;
            this.lastY = event.y;
            this.dragging = true;
            this.setLocation(event.x, event.y);
        }
    }

    boolean mouseEvent(long id2, long sel, long theEvent, int type) {
        super.mouseEvent(id2, sel, theEvent, type);
        return new NSEvent(theEvent).type() != 1L;
    }

    void mouseDragged(long id2, long sel, long theEvent) {
        super.mouseDragged(id2, sel, theEvent);
        if (this.isDisposed()) {
            return;
        }
        if (!this.dragging) {
            return;
        }
        NSEvent nsEvent = new NSEvent(theEvent);
        NSPoint location = nsEvent.locationInWindow();
        NSPoint point = this.view.convertPoint_fromView_(location, null);
        NSRect frame = this.view.frame();
        NSRect parentFrame = this.parent.topView().frame();
        int newX = this.lastX;
        int newY = this.lastY;
        if ((this.style & 0x200) != 0) {
            newX = Math.min(Math.max(0, (int)(point.x + frame.x - (double)this.startX)), (int)(parentFrame.width - frame.width));
        } else {
            newY = Math.min(Math.max(0, (int)(point.y + frame.y - (double)this.startY)), (int)(parentFrame.height - frame.height));
        }
        if (newX == this.lastX && newY == this.lastY) {
            return;
        }
        Event event = new Event();
        event.x = newX;
        event.y = newY;
        event.width = (int)frame.width;
        event.height = (int)frame.height;
        this.sendSelectionEvent(13, event, true);
        if (this.isDisposed()) {
            return;
        }
        if (event.doit) {
            this.lastX = event.x;
            this.lastY = event.y;
            this.setBounds(event.x, event.y, (int)frame.width, (int)frame.height);
        }
    }

    void mouseUp(long id2, long sel, long theEvent) {
        super.mouseUp(id2, sel, theEvent);
        if (this.isDisposed()) {
            return;
        }
        if (!this.dragging) {
            return;
        }
        this.dragging = false;
        NSRect frame = this.view.frame();
        Event event = new Event();
        event.x = this.lastX;
        event.y = this.lastY;
        event.width = (int)frame.width;
        event.height = (int)frame.height;
        this.sendSelectionEvent(13, event, true);
        if (this.isDisposed()) {
            return;
        }
        if (event.doit) {
            this.setBounds(event.x, event.y, (int)frame.width, (int)frame.height);
        }
    }

    void releaseHandle() {
        super.releaseHandle();
        if (this.accessibilityAttributes != null) {
            this.accessibilityAttributes.release();
        }
        this.accessibilityAttributes = null;
    }

    void releaseWidget() {
        super.releaseWidget();
        if (this.sizeCursor != null) {
            this.sizeCursor.dispose();
        }
        this.sizeCursor = null;
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, listener);
        this.eventTable.unhook(14, listener);
    }

    void superKeyDown(long id2, long sel, long theEvent) {
    }

    void superKeyUp(long id2, long sel, long theEvent) {
    }

    int traversalCode(int key, NSEvent theEvent) {
        return 0;
    }
}

