/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.C;
import org.eclipse.swt.internal.cocoa.NSArray;
import org.eclipse.swt.internal.cocoa.NSAttributedString;
import org.eclipse.swt.internal.cocoa.NSButtonCell;
import org.eclipse.swt.internal.cocoa.NSCell;
import org.eclipse.swt.internal.cocoa.NSClipView;
import org.eclipse.swt.internal.cocoa.NSColor;
import org.eclipse.swt.internal.cocoa.NSControl;
import org.eclipse.swt.internal.cocoa.NSCursor;
import org.eclipse.swt.internal.cocoa.NSDictionary;
import org.eclipse.swt.internal.cocoa.NSEvent;
import org.eclipse.swt.internal.cocoa.NSFont;
import org.eclipse.swt.internal.cocoa.NSGraphicsContext;
import org.eclipse.swt.internal.cocoa.NSImage;
import org.eclipse.swt.internal.cocoa.NSLayoutManager;
import org.eclipse.swt.internal.cocoa.NSMutableParagraphStyle;
import org.eclipse.swt.internal.cocoa.NSNotification;
import org.eclipse.swt.internal.cocoa.NSParagraphStyle;
import org.eclipse.swt.internal.cocoa.NSPoint;
import org.eclipse.swt.internal.cocoa.NSRange;
import org.eclipse.swt.internal.cocoa.NSRect;
import org.eclipse.swt.internal.cocoa.NSScrollView;
import org.eclipse.swt.internal.cocoa.NSSearchField;
import org.eclipse.swt.internal.cocoa.NSSearchFieldCell;
import org.eclipse.swt.internal.cocoa.NSSize;
import org.eclipse.swt.internal.cocoa.NSString;
import org.eclipse.swt.internal.cocoa.NSText;
import org.eclipse.swt.internal.cocoa.NSTextContainer;
import org.eclipse.swt.internal.cocoa.NSTextField;
import org.eclipse.swt.internal.cocoa.NSTextFieldCell;
import org.eclipse.swt.internal.cocoa.NSTextStorage;
import org.eclipse.swt.internal.cocoa.NSTextTab;
import org.eclipse.swt.internal.cocoa.NSTextView;
import org.eclipse.swt.internal.cocoa.NSView;
import org.eclipse.swt.internal.cocoa.OS;
import org.eclipse.swt.internal.cocoa.SWTScrollView;
import org.eclipse.swt.internal.cocoa.SWTSearchField;
import org.eclipse.swt.internal.cocoa.SWTSecureTextField;
import org.eclipse.swt.internal.cocoa.SWTTextField;
import org.eclipse.swt.internal.cocoa.SWTTextView;
import org.eclipse.swt.internal.cocoa.id;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Scrollable;
import org.eclipse.swt.widgets.TypedListener;

public class Text
extends Scrollable {
    int textLimit = LIMIT;
    int tabs = 8;
    char echoCharacter;
    boolean doubleClick;
    boolean receivingFocus;
    String hiddenText;
    String message;
    NSRange selectionRange;
    id targetSearch;
    id targetCancel;
    long actionSearch;
    long actionCancel;
    public static final int LIMIT = Integer.MAX_VALUE;
    public static final String DELIMITER = "\r";
    static final char PASSWORD = '\u2022';

    public Text(Composite parent, int style) {
        super(parent, Text.checkStyle(style));
        if ((style & 0x80) != 0) {
            NSSearchFieldCell cell = new NSSearchFieldCell(((NSSearchField)this.view).cell());
            if ((style & 0x100) != 0) {
                this.style |= 0x100;
                NSButtonCell cancelCell = cell.cancelButtonCell();
                this.targetCancel = cancelCell.target();
                this.actionCancel = cancelCell.action();
                cancelCell.setTarget(this.view);
                cancelCell.setAction(OS.sel_sendCancelSelection);
            } else {
                cell.setCancelButtonCell(null);
            }
            if ((style & 0x200) != 0) {
                this.style |= 0x200;
                NSButtonCell searchCell = cell.searchButtonCell();
                this.targetSearch = searchCell.target();
                this.actionSearch = searchCell.action();
                searchCell.setTarget(this.view);
                searchCell.setAction(OS.sel_sendSearchSelection);
            } else {
                cell.setSearchButtonCell(null);
            }
        }
    }

    public void addModifyListener(ModifyListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(24, typedListener);
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    public void addVerifyListener(VerifyListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(25, typedListener);
    }

    public void append(String string) {
        int charCount;
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if ((this.hooks(25) || this.filters(25)) && (string = this.verifyText(string, charCount = this.getCharCount(), charCount, null)) == null) {
            return;
        }
        NSString str = NSString.stringWith(string);
        if ((this.style & 4) != 0) {
            this.setSelection(this.getCharCount());
            this.insertEditText(string);
        } else {
            NSTextView widget = (NSTextView)this.view;
            NSTextStorage storage = widget.textStorage();
            NSRange range = new NSRange();
            range.location = storage.length();
            storage.replaceCharactersInRange(range, str);
            range.location = storage.length();
            widget.scrollRangeToVisible(range);
            widget.setSelectedRange(range);
        }
        if (string.length() != 0) {
            this.sendEvent(24);
        }
    }

    boolean becomeFirstResponder(long id2, long sel) {
        this.receivingFocus = true;
        boolean result = super.becomeFirstResponder(id2, sel);
        this.receivingFocus = false;
        return result;
    }

    static int checkStyle(int style) {
        if ((style & 0x80) != 0) {
            style |= 0x804;
            style &= 0xFFBFFFFF;
        }
        if ((style & 4) != 0 && (style & 2) != 0) {
            style &= 0xFFFFFFFD;
        }
        if (((style = Text.checkBits(style, 16384, 0x1000000, 131072, 0, 0, 0)) & 4) != 0) {
            style &= 0xFFFFFCBF;
        }
        if ((style & 0x40) != 0) {
            style |= 2;
            style &= 0xFFFFFEFF;
        }
        if ((style & 2) != 0) {
            style &= 0xFFBFFFFF;
        }
        if ((style & 6) != 0) {
            return style;
        }
        if ((style & 0x300) != 0) {
            return style | 2;
        }
        return style | 4;
    }

    public void clearSelection() {
        this.checkWidget();
        Point selection = this.getSelection();
        this.setSelection(selection.x);
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        int width = 0;
        int height = 0;
        if ((this.style & 4) != 0) {
            NSCell cell = ((NSTextField)this.view).cell();
            NSSize size = cell.cellSize();
            if (cell.title().length() > 0L) {
                width = (int)Math.ceil(size.width);
            }
            height = (int)Math.ceil(size.height);
            Point border = null;
            if ((this.style & 0x800) != 0 && (wHint != -1 || hHint != -1)) {
                NSRect insets = cell.titleRectForBounds(new NSRect());
                border = new Point(-((int)Math.ceil(insets.width)), -((int)Math.ceil(insets.height)));
                width -= border.x;
                height -= border.y;
            }
            if (width <= 0) {
                width = 64;
            }
            if (height <= 0) {
                height = 64;
            }
            if (wHint != -1) {
                width = wHint;
            }
            if (hHint != -1) {
                height = hHint;
            }
            if (border != null) {
                width += border.x;
                height += border.y;
            }
        } else {
            NSLayoutManager layoutManager = (NSLayoutManager)new NSLayoutManager().alloc().init();
            NSTextContainer textContainer = (NSTextContainer)new NSTextContainer().alloc();
            NSSize size = new NSSize();
            size.height = 3.4028234663852886E38;
            size.width = 3.4028234663852886E38;
            if ((this.style & 0x40) != 0) {
                if (wHint != -1) {
                    size.width = wHint;
                }
                if (hHint != -1) {
                    size.height = hHint;
                }
            }
            textContainer.initWithContainerSize(size);
            layoutManager.addTextContainer(textContainer);
            NSTextStorage textStorage = (NSTextStorage)new NSTextStorage().alloc().init();
            textStorage.setAttributedString(((NSTextView)this.view).textStorage());
            layoutManager.setTextStorage(textStorage);
            layoutManager.glyphRangeForTextContainer(textContainer);
            NSRect rect = layoutManager.usedRectForTextContainer(textContainer);
            width = layoutManager.numberOfGlyphs() == 0L ? 64 : (int)Math.ceil(rect.width);
            height = (int)Math.ceil(rect.height);
            textStorage.release();
            textContainer.release();
            layoutManager.release();
            if (width <= 0) {
                width = 64;
            }
            if (height <= 0) {
                height = 64;
            }
            if (wHint != -1) {
                width = wHint;
            }
            if (hHint != -1) {
                height = hHint;
            }
            Rectangle trim = this.computeTrim(0, 0, width, height);
            width = trim.width;
            height = trim.height;
        }
        return new Point(width, height);
    }

    public Rectangle computeTrim(int x, int y, int width, int height) {
        Rectangle result = super.computeTrim(x, y, width, height);
        if ((this.style & 4) != 0) {
            NSTextField widget = (NSTextField)this.view;
            if ((this.style & 0x80) != 0) {
                NSSearchFieldCell cell = new NSSearchFieldCell(widget.cell());
                int testWidth = 100;
                NSRect rect = new NSRect();
                rect.width = testWidth;
                rect = cell.searchTextRectForBounds(rect);
                int leftIndent = (int)rect.x;
                int rightIndent = testWidth - leftIndent - (int)Math.ceil(rect.width);
                result.x -= leftIndent;
                result.width += leftIndent + rightIndent;
            }
            NSRect inset = widget.cell().titleRectForBounds(new NSRect());
            result.x = (int)((double)result.x - inset.x);
            result.y = (int)((double)result.y - inset.y);
            result.width = (int)((double)result.width - inset.width);
            result.height = (int)((double)result.height - inset.height);
        }
        return result;
    }

    public void copy() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            Point selection = this.getSelection();
            if (selection.x == selection.y) {
                return;
            }
            this.copyToClipboard(this.getEditText(selection.x, selection.y - 1));
        } else {
            NSText text = (NSText)this.view;
            if (text.selectedRange().length == 0L) {
                return;
            }
            text.copy(null);
        }
    }

    void createHandle() {
        if ((this.style & 8) != 0 && (this.style & 0xB00) == 0) {
            this.state |= 0x800;
        }
        if ((this.style & 4) != 0) {
            NSTextField widget = (this.style & 0x400000) != 0 ? (NSTextField)new SWTSecureTextField().alloc() : ((this.style & 0x80) != 0 ? (NSTextField)new SWTSearchField().alloc() : (NSTextField)new SWTTextField().alloc());
            widget.init();
            widget.setSelectable(true);
            widget.setEditable((this.style & 8) == 0);
            if ((this.style & 0x800) == 0) {
                widget.setFocusRingType(1L);
                widget.setBordered(false);
            }
            int align = 0;
            if ((this.style & 0x1000000) != 0) {
                align = 2;
            }
            if ((this.style & 0x20000) != 0) {
                align = 1;
            }
            widget.setAlignment(align);
            NSCell cell = widget.cell();
            cell.setWraps(false);
            cell.setScrollable(true);
            this.view = widget;
        } else {
            NSScrollView scrollWidget = (NSScrollView)new SWTScrollView().alloc();
            scrollWidget.init();
            scrollWidget.setHasVerticalScroller((this.style & 0x200) != 0);
            scrollWidget.setHasHorizontalScroller((this.style & 0x100) != 0);
            scrollWidget.setAutoresizesSubviews(true);
            if ((this.style & 0x800) != 0) {
                scrollWidget.setBorderType(2L);
            }
            NSTextView widget = (NSTextView)new SWTTextView().alloc();
            widget.init();
            widget.setEditable((this.style & 8) == 0);
            NSSize size = new NSSize();
            size.height = 3.4028234663852886E38;
            size.width = 3.4028234663852886E38;
            widget.setMaxSize(size);
            widget.setAutoresizingMask(18L);
            if ((this.style & 0x40) == 0) {
                NSTextContainer textContainer = widget.textContainer();
                widget.setHorizontallyResizable(true);
                textContainer.setWidthTracksTextView(false);
                NSSize csize = new NSSize();
                csize.height = 3.4028234663852886E38;
                csize.width = 3.4028234663852886E38;
                textContainer.setContainerSize(csize);
            }
            int align = 0;
            if ((this.style & 0x1000000) != 0) {
                align = 2;
            }
            if ((this.style & 0x20000) != 0) {
                align = 1;
            }
            widget.setAlignment(align);
            widget.setRichText(false);
            widget.setDelegate(widget);
            widget.setFont(this.display.getSystemFont().handle);
            this.view = widget;
            this.scrollView = scrollWidget;
        }
    }

    void createWidget() {
        super.createWidget();
        if ((this.style & 0x400000) != 0) {
            NSText fieldEditor = this.view.window().fieldEditor(true, this.view);
            long nsSecureTextViewClass = OS.objc_lookUpClass("NSSecureTextView");
            if (fieldEditor != null && nsSecureTextViewClass != 0L && fieldEditor.isKindOfClass(nsSecureTextViewClass)) {
                long editorClass = OS.objc_getClass("SWTSecureEditorView");
                OS.object_setClass(fieldEditor.id, editorClass);
            }
        }
        this.doubleClick = true;
        this.message = "";
    }

    public void cut() {
        this.checkWidget();
        if ((this.style & 8) != 0) {
            return;
        }
        boolean cut = true;
        char[] oldText = null;
        Point oldSelection = this.getSelection();
        if ((this.hooks(25) || this.filters(25)) && oldSelection.x != oldSelection.y) {
            oldText = this.getEditText(oldSelection.x, oldSelection.y - 1);
            String newText = this.verifyText("", oldSelection.x, oldSelection.y, null);
            if (newText == null) {
                return;
            }
            if (newText.length() != 0) {
                this.copyToClipboard(oldText);
                if ((this.style & 4) != 0) {
                    this.insertEditText(newText);
                } else {
                    NSTextView widget = (NSTextView)this.view;
                    widget.replaceCharactersInRange(widget.selectedRange(), NSString.stringWith(newText));
                }
                cut = false;
            }
        }
        if (cut) {
            if ((this.style & 4) != 0) {
                if (oldText == null) {
                    oldText = this.getEditText(oldSelection.x, oldSelection.y - 1);
                }
                this.copyToClipboard(oldText);
                this.insertEditText("");
            } else {
                ((NSTextView)this.view).cut(null);
            }
        }
        Point newSelection = this.getSelection();
        if (!cut || !oldSelection.equals(newSelection)) {
            this.sendEvent(24);
        }
    }

    Color defaultBackground() {
        return this.display.getWidgetColor(25);
    }

    NSFont defaultNSFont() {
        if ((this.style & 2) != 0) {
            return this.display.textViewFont;
        }
        if ((this.style & 0x80) != 0) {
            return this.display.searchFieldFont;
        }
        if ((this.style & 0x400000) != 0) {
            return this.display.secureTextFieldFont;
        }
        return this.display.textFieldFont;
    }

    Color defaultForeground() {
        return this.display.getWidgetColor(24);
    }

    void deregister() {
        super.deregister();
        if ((this.style & 4) != 0) {
            this.display.removeWidget(((NSControl)this.view).cell());
        }
    }

    void drawBackground(long id2, NSGraphicsContext context, NSRect rect) {
        if ((this.style & 4) != 0) {
            NSText text;
            if (this.backgroundImage == null) {
                return;
            }
            if (new NSView(id2).isKindOfClass(OS.class_NSText) && !(text = new NSText(id2)).isFieldEditor()) {
                return;
            }
        }
        if ((this.style & 2) != 0 && id2 != this.scrollView.id) {
            return;
        }
        this.fillBackground(this.view, context, rect, -1);
    }

    void drawInteriorWithFrame_inView(int id2, int sel, NSRect cellFrame, int viewid) {
        Image image;
        Control control = this.findBackgroundControl();
        if (control == null) {
            control = this;
        }
        if ((image = control.backgroundImage) != null && !image.isDisposed()) {
            NSGraphicsContext context = NSGraphicsContext.currentContext();
            control.fillBackground(this.view, context, cellFrame, -1);
        }
        super.drawInteriorWithFrame_inView(id2, sel, cellFrame, viewid);
    }

    boolean dragDetect(int x, int y, boolean filter, boolean[] consume) {
        long position;
        Point selection = this.getSelection();
        if (selection.x != selection.y && (long)selection.x <= (position = this.getPosition(x, y)) && position < (long)selection.y && super.dragDetect(x, y, filter, consume)) {
            if (consume != null) {
                consume[0] = true;
            }
            return true;
        }
        return false;
    }

    public int getCaretLineNumber() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            return 0;
        }
        return (this.getTopPixel() + this.getCaretLocation().y) / this.getLineHeight();
    }

    boolean acceptsFirstResponder(long id2, long sel) {
        if ((this.style & 8) != 0) {
            return true;
        }
        return super.acceptsFirstResponder(id2, sel);
    }

    public Point getCaretLocation() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            return new Point(0, 0);
        }
        NSTextView widget = (NSTextView)this.view;
        NSLayoutManager layoutManager = widget.layoutManager();
        NSTextContainer container = widget.textContainer();
        NSRange range = widget.selectedRange();
        long pRectCount = OS.malloc(C.PTR_SIZEOF);
        long pArray = layoutManager.rectArrayForCharacterRange(range, range, container, pRectCount);
        long[] rectCount = new long[1];
        OS.memmove(rectCount, pRectCount, (long)C.PTR_SIZEOF);
        OS.free(pRectCount);
        NSRect rect = new NSRect();
        if (rectCount[0] > 0L) {
            OS.memmove(rect, pArray, (long)NSRect.sizeof);
        }
        return new Point((int)rect.x, (int)rect.y);
    }

    public int getCaretPosition() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            return this.selectionRange != null ? (int)this.selectionRange.location : 0;
        }
        NSRange range = ((NSTextView)this.view).selectedRange();
        return (int)range.location;
    }

    public int getCharCount() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            return (int)new NSCell(((NSControl)this.view).cell()).title().length();
        }
        return (int)((NSTextView)this.view).textStorage().length();
    }

    public boolean getDoubleClickEnabled() {
        this.checkWidget();
        return this.doubleClick;
    }

    public char getEchoChar() {
        this.checkWidget();
        return this.echoCharacter;
    }

    public boolean getEditable() {
        this.checkWidget();
        return (this.style & 8) == 0;
    }

    char[] getEditText() {
        NSString str = null;
        str = (this.style & 4) != 0 ? new NSTextFieldCell(((NSTextField)this.view).cell()).title() : ((NSTextView)this.view).textStorage().string();
        int length = (int)str.length();
        char[] buffer = new char[length];
        if (this.hiddenText != null) {
            this.hiddenText.getChars(0, length, buffer, 0);
        } else {
            NSRange range = new NSRange();
            range.length = length;
            str.getCharacters(buffer, range);
        }
        return buffer;
    }

    char[] getEditText(int start, int end) {
        NSString str = null;
        str = (this.style & 4) != 0 ? new NSTextFieldCell(((NSTextField)this.view).cell()).title() : ((NSTextView)this.view).textStorage().string();
        int length = (int)str.length();
        if (start > (end = Math.min(end, length - 1))) {
            return new char[0];
        }
        start = Math.max(0, start);
        NSRange range = new NSRange();
        range.location = start;
        range.length = Math.max(0, end - start + 1);
        char[] buffer = new char[(int)range.length];
        if (this.hiddenText != null) {
            this.hiddenText.getChars((int)range.location, (int)(range.location + range.length), buffer, 0);
        } else {
            str.getCharacters(buffer, range);
        }
        return buffer;
    }

    public int getLineCount() {
        long c;
        this.checkWidget();
        if ((this.style & 4) != 0) {
            return 1;
        }
        NSTextStorage storage = ((NSTextView)this.view).textStorage();
        int count = (int)storage.paragraphs().count();
        NSString string = storage.string();
        long length = string.length();
        if (length == 0L || (c = string.characterAtIndex(length - 1L)) == 10L || c == 13L) {
            ++count;
        }
        return count;
    }

    public String getLineDelimiter() {
        this.checkWidget();
        return DELIMITER;
    }

    public int getLineHeight() {
        Font font;
        this.checkWidget();
        Font font2 = font = this.font != null ? this.font : this.defaultFont();
        if ((this.style & 4) != 0) {
            NSDictionary dict = NSDictionary.dictionaryWithObject(font.handle, OS.NSFontAttributeName);
            NSString str = NSString.stringWith(" ");
            NSAttributedString attribStr = ((NSAttributedString)new NSAttributedString().alloc()).initWithString(str, dict);
            NSSize size = attribStr.size();
            attribStr.release();
            return (int)size.height;
        }
        NSTextView widget = (NSTextView)this.view;
        return (int)Math.ceil(widget.layoutManager().defaultLineHeightForFont(font.handle));
    }

    public int getOrientation() {
        this.checkWidget();
        return this.style & 0x6000000;
    }

    public String getMessage() {
        this.checkWidget();
        return this.message;
    }

    long getPosition(long x, long y) {
        if ((this.style & 2) != 0) {
            NSTextView widget = (NSTextView)this.view;
            NSPoint viewLocation = new NSPoint();
            viewLocation.x = x;
            viewLocation.y = y;
            return widget.characterIndexForInsertionAtPoint(viewLocation);
        }
        return 0L;
    }

    public Point getSelection() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            if (this.selectionRange == null) {
                NSString str = new NSTextFieldCell(((NSTextField)this.view).cell()).title();
                return new Point((int)str.length(), (int)str.length());
            }
            return new Point((int)this.selectionRange.location, (int)(this.selectionRange.location + this.selectionRange.length));
        }
        NSTextView widget = (NSTextView)this.view;
        NSRange range = widget.selectedRange();
        return new Point((int)range.location, (int)(range.location + range.length));
    }

    public int getSelectionCount() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            return this.selectionRange != null ? (int)this.selectionRange.length : 0;
        }
        NSTextView widget = (NSTextView)this.view;
        NSRange range = widget.selectedRange();
        return (int)range.length;
    }

    public String getSelectionText() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            Point selection = this.getSelection();
            if (selection.x == selection.y) {
                return "";
            }
            return new String(this.getEditText(selection.x, selection.y - 1));
        }
        NSTextView widget = (NSTextView)this.view;
        NSRange range = widget.selectedRange();
        NSString str = widget.textStorage().string();
        char[] buffer = new char[(int)range.length];
        str.getCharacters(buffer, range);
        return new String(buffer);
    }

    public int getTabs() {
        this.checkWidget();
        return this.tabs;
    }

    public String getText() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            return new String(this.getEditText());
        }
        NSString str = ((NSTextView)this.view).textStorage().string();
        return str.getString();
    }

    public String getText(int start, int end) {
        this.checkWidget();
        if (start > end || end < 0) {
            return "";
        }
        if ((this.style & 4) != 0) {
            return new String(this.getEditText(start, end));
        }
        NSTextStorage storage = ((NSTextView)this.view).textStorage();
        if (start > (end = Math.min(end, (int)storage.length() - 1))) {
            return "";
        }
        start = Math.max(0, start);
        NSRange range = new NSRange();
        range.location = start;
        range.length = end - start + 1;
        NSAttributedString substring = storage.attributedSubstringFromRange(range);
        NSString string = substring.string();
        return string.getString();
    }

    public int getTextLimit() {
        this.checkWidget();
        return this.textLimit;
    }

    public int getTopIndex() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            return 0;
        }
        return this.getTopPixel() / this.getLineHeight();
    }

    public int getTopPixel() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            return 0;
        }
        return (int)this.scrollView.contentView().bounds().y;
    }

    public void insert(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if (this.hooks(25) || this.filters(25)) {
            Point selection = this.getSelection();
            if ((string = this.verifyText(string, selection.x, selection.y, null)) == null) {
                return;
            }
        }
        if ((this.style & 4) != 0) {
            this.insertEditText(string);
        } else {
            NSString str = NSString.stringWith(string);
            NSTextView widget = (NSTextView)this.view;
            NSRange range = widget.selectedRange();
            widget.textStorage().replaceCharactersInRange(range, str);
        }
        if (string.length() != 0) {
            this.sendEvent(24);
        }
    }

    void insertEditText(String string) {
        int length = string.length();
        Point selection = this.getSelection();
        if (this.hasFocus() && this.hiddenText == null) {
            int charCount;
            if (this.textLimit != LIMIT && (charCount = this.getCharCount()) - (selection.y - selection.x) + length > this.textLimit) {
                length = this.textLimit - charCount + (selection.y - selection.x);
                length = Math.max(0, length);
            }
            char[] buffer = new char[length];
            string.getChars(0, buffer.length, buffer, 0);
            NSString nsstring = NSString.stringWithCharacters(buffer, buffer.length);
            NSText fieldEditor = ((NSTextField)this.view).currentEditor();
            if (fieldEditor != null) {
                fieldEditor.replaceCharactersInRange(fieldEditor.selectedRange(), nsstring);
            }
            this.selectionRange = null;
        } else {
            int charCount;
            String oldText = this.getText();
            if (this.textLimit != LIMIT && (charCount = oldText.length()) - (selection.y - selection.x) + length > this.textLimit) {
                string = string.substring(0, this.textLimit - charCount + (selection.y - selection.x));
            }
            String newText = String.valueOf(oldText.substring(0, selection.x)) + string + oldText.substring(selection.y);
            this.setEditText(newText);
            this.setSelection(selection.x + string.length());
        }
    }

    boolean isEventView(long id2) {
        if ((this.style & 2) != 0) {
            return super.isEventView(id2);
        }
        return true;
    }

    boolean isNeeded(ScrollBar scrollbar) {
        boolean result = false;
        if ((this.style & 2) != 0) {
            NSRect docFrame = this.scrollView.documentView().frame();
            NSRect contentFrame = this.scrollView.contentView().frame();
            result = (scrollbar.style & 0x200) != 0 ? docFrame.height > contentFrame.height : docFrame.width > contentFrame.width;
        }
        return result;
    }

    public void paste() {
        this.checkWidget();
        if ((this.style & 8) != 0) {
            return;
        }
        boolean paste = true;
        String oldText = null;
        if ((this.hooks(25) || this.filters(25)) && (oldText = this.getClipboardText()) != null) {
            Point selection = this.getSelection();
            String newText = this.verifyText(oldText, selection.x, selection.y, null);
            if (newText == null) {
                return;
            }
            if (!newText.equals(oldText)) {
                if ((this.style & 4) != 0) {
                    this.insertEditText(newText);
                } else {
                    NSTextView textView = (NSTextView)this.view;
                    textView.replaceCharactersInRange(textView.selectedRange(), NSString.stringWith(newText));
                }
                paste = false;
            }
        }
        if (paste) {
            if ((this.style & 4) != 0) {
                if (oldText == null) {
                    oldText = this.getClipboardText();
                }
                if (oldText == null) {
                    return;
                }
                this.insertEditText(oldText);
            } else {
                ((NSTextView)this.view).paste(null);
            }
        }
        this.sendEvent(24);
    }

    void register() {
        super.register();
        if ((this.style & 4) != 0) {
            this.display.addWidget(((NSControl)this.view).cell(), this);
        }
    }

    void releaseWidget() {
        super.releaseWidget();
        if ((this.style & 4) != 0) {
            ((NSControl)this.view).abortEditing();
        }
        this.message = null;
        this.hiddenText = null;
        this.selectionRange = null;
    }

    public void removeModifyListener(ModifyListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(24, listener);
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, listener);
        this.eventTable.unhook(14, listener);
    }

    public void removeVerifyListener(VerifyListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(25, listener);
    }

    public void selectAll() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            this.setSelection(0, this.getCharCount());
        } else {
            ((NSTextView)this.view).selectAll(null);
        }
    }

    boolean sendKeyEvent(NSEvent nsEvent, int type) {
        short keyCode;
        boolean result = super.sendKeyEvent(nsEvent, type);
        if (!result) {
            return result;
        }
        if (type != 1) {
            return result;
        }
        int stateMask = 0;
        long modifierFlags = nsEvent.modifierFlags();
        if ((modifierFlags & 0x80000L) != 0L) {
            stateMask |= 0x10000;
        }
        if ((modifierFlags & 0x20000L) != 0L) {
            stateMask |= 0x20000;
        }
        if ((modifierFlags & 0x40000L) != 0L) {
            stateMask |= 0x40000;
        }
        if ((modifierFlags & 0x100000L) != 0L) {
            stateMask |= 0x400000;
        }
        if (stateMask == 0x400000) {
            keyCode = nsEvent.keyCode();
            switch (keyCode) {
                case 7: {
                    if ((this.style & 0x400000) == 0) {
                        this.cut();
                    }
                    return false;
                }
                case 8: {
                    if ((this.style & 0x400000) == 0) {
                        this.copy();
                    }
                    return false;
                }
                case 9: {
                    this.paste();
                    return false;
                }
            }
        }
        if ((this.style & 4) != 0) {
            keyCode = nsEvent.keyCode();
            switch (keyCode) {
                case 36: 
                case 76: {
                    this.sendSelectionEvent(14);
                }
            }
        }
        return result;
    }

    void sendSearchSelection() {
        if (this.targetSearch != null) {
            ((NSSearchField)this.view).sendAction(this.actionSearch, this.targetSearch);
        }
        Event event = new Event();
        event.detail = 512;
        this.sendSelectionEvent(14, event, false);
    }

    void sendCancelSelection() {
        if (this.targetCancel != null) {
            ((NSSearchField)this.view).sendAction(this.actionCancel, this.targetCancel);
        }
        Event event = new Event();
        event.detail = 256;
        this.sendSelectionEvent(14, event, false);
    }

    void setBackgroundColor(NSColor nsColor) {
        if ((this.style & 4) != 0) {
            ((NSTextField)this.view).setBackgroundColor(nsColor);
        } else {
            ((NSTextView)this.view).setBackgroundColor(nsColor);
        }
    }

    void setBackgroundImage(NSImage image) {
        if ((this.style & 4) != 0) {
            NSTextField widget = (NSTextField)this.view;
            widget.setDrawsBackground(image == null);
        } else {
            ((NSTextView)this.view).setDrawsBackground(image == null);
            this.scrollView.setDrawsBackground(image == null);
        }
    }

    public void setDoubleClickEnabled(boolean doubleClick) {
        this.checkWidget();
        this.doubleClick = doubleClick;
    }

    public void setEchoChar(char echo) {
        this.checkWidget();
        if ((this.style & 2) != 0) {
            return;
        }
        if ((this.style & 0x400000) == 0) {
            Point selection = this.getSelection();
            String text = this.getText();
            this.echoCharacter = echo;
            this.setEditText(text);
            this.setSelection(selection);
        }
        this.echoCharacter = echo;
    }

    public void setEditable(boolean editable) {
        this.checkWidget();
        this.style = editable ? (this.style &= 0xFFFFFFF7) : (this.style |= 8);
        if ((this.style & 4) != 0) {
            ((NSTextField)this.view).setEditable(editable);
        } else {
            ((NSTextView)this.view).setEditable(editable);
        }
    }

    void setEditText(String string) {
        char[] buffer;
        if ((this.style & 0x400000) == 0 && this.echoCharacter != '\u0000') {
            this.hiddenText = string;
            buffer = new char[Math.min(this.hiddenText.length(), this.textLimit)];
            int i = 0;
            while (i < buffer.length) {
                buffer[i] = this.echoCharacter;
                ++i;
            }
        } else {
            this.hiddenText = null;
            buffer = new char[Math.min(string.length(), this.textLimit)];
            string.getChars(0, buffer.length, buffer, 0);
        }
        NSString nsstring = NSString.stringWithCharacters(buffer, buffer.length);
        new NSCell(((NSTextField)this.view).cell()).setTitle(nsstring);
        this.selectionRange = null;
    }

    void setFrameSize(long id2, long sel, NSSize size) {
        NSArray subviews;
        NSSearchField widget;
        NSText editor;
        super.setFrameSize(id2, sel, size);
        if ((this.style & 0x80) != 0 && (editor = (widget = (NSSearchField)this.view).currentEditor()) != null && (subviews = widget.subviews()).count() > 0L) {
            NSRect rect = widget.cell().drawingRectForBounds(widget.bounds());
            new NSView(subviews.objectAtIndex(0L)).setFrame(rect);
        }
    }

    void setFont(NSFont font) {
        if ((this.style & 2) != 0) {
            ((NSTextView)this.view).setFont(font);
            return;
        }
        super.setFont(font);
    }

    void setForeground(double[] color) {
        NSColor nsColor = color == null ? NSColor.textColor() : NSColor.colorWithDeviceRed(color[0], color[1], color[2], 1.0);
        if ((this.style & 4) != 0) {
            ((NSTextField)this.view).setTextColor(nsColor);
        } else {
            ((NSTextView)this.view).setTextColor(nsColor);
        }
    }

    public void setOrientation(int orientation) {
        this.checkWidget();
    }

    void setOrientation() {
        int direction;
        int n = direction = (this.style & 0x4000000) != 0 ? 1 : 0;
        if ((this.style & 4) != 0) {
            NSTextField widget = (NSTextField)this.view;
            widget.setBaseWritingDirection(direction);
        } else {
            NSTextView widget = (NSTextView)this.view;
            widget.setBaseWritingDirection(direction);
        }
    }

    public void setMessage(String message) {
        this.checkWidget();
        if (message == null) {
            this.error(4);
        }
        this.message = message;
        if ((this.style & 4) != 0) {
            NSString str = NSString.stringWith(message);
            NSTextFieldCell cell = new NSTextFieldCell(((NSTextField)this.view).cell());
            cell.setPlaceholderString(str);
        }
    }

    public void setSelection(int start) {
        this.checkWidget();
        this.setSelection(start, start);
    }

    public void setSelection(int start, int end) {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            NSString str = new NSCell(((NSTextField)this.view).cell()).title();
            int length = (int)str.length();
            int selStart = Math.min(Math.max(Math.min(start, end), 0), length);
            int selEnd = Math.min(Math.max(Math.max(start, end), 0), length);
            this.selectionRange = new NSRange();
            this.selectionRange.location = selStart;
            this.selectionRange.length = selEnd - selStart;
            NSText fieldEditor = ((NSControl)this.view).currentEditor();
            if (fieldEditor != null) {
                fieldEditor.setSelectedRange(this.selectionRange);
                fieldEditor.scrollRangeToVisible(this.selectionRange);
            }
        } else {
            int length = (int)((NSTextView)this.view).textStorage().length();
            int selStart = Math.min(Math.max(Math.min(start, end), 0), length);
            int selEnd = Math.min(Math.max(Math.max(start, end), 0), length);
            NSRange range = new NSRange();
            range.location = selStart;
            range.length = selEnd - selStart;
            NSTextView widget = (NSTextView)this.view;
            widget.setSelectedRange(range);
            widget.scrollRangeToVisible(range);
        }
    }

    public void setSelection(Point selection) {
        this.checkWidget();
        if (selection == null) {
            this.error(4);
        }
        this.setSelection(selection.x, selection.y);
    }

    public void setTabs(int tabs) {
        this.checkWidget();
        if (this.tabs == tabs) {
            return;
        }
        this.tabs = tabs;
        if ((this.style & 4) != 0) {
            return;
        }
        double size = this.textExtent((String)"s").width * (double)tabs;
        NSTextView widget = (NSTextView)this.view;
        NSParagraphStyle defaultStyle = widget.defaultParagraphStyle();
        NSMutableParagraphStyle paragraphStyle = new NSMutableParagraphStyle(defaultStyle.mutableCopy());
        paragraphStyle.setTabStops(NSArray.array());
        NSTextTab tab = (NSTextTab)new NSTextTab().alloc();
        tab = tab.initWithType(0L, size);
        paragraphStyle.addTabStop(tab);
        tab.release();
        paragraphStyle.setDefaultTabInterval(size);
        widget.setDefaultParagraphStyle(paragraphStyle);
        paragraphStyle.release();
    }

    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if ((this.hooks(25) || this.filters(25)) && (string = this.verifyText(string, 0, this.getCharCount(), null)) == null) {
            return;
        }
        if ((this.style & 4) != 0) {
            this.setEditText(string);
            NSText fieldEditor = ((NSControl)this.view).currentEditor();
            if (fieldEditor != null) {
                NSRange range = new NSRange();
                fieldEditor.setSelectedRange(range);
                fieldEditor.scrollRangeToVisible(range);
            }
        } else {
            NSTextView widget = (NSTextView)this.view;
            char[] buffer = new char[Math.min(string.length(), this.textLimit)];
            string.getChars(0, buffer.length, buffer, 0);
            NSString str = NSString.stringWithCharacters(buffer, buffer.length);
            widget.setString(str);
            widget.setSelectedRange(new NSRange());
        }
        this.sendEvent(24);
    }

    public void setTextLimit(int limit) {
        this.checkWidget();
        if (limit == 0) {
            this.error(7);
        }
        this.textLimit = limit;
    }

    public void setTopIndex(int index) {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            return;
        }
        int row = Math.max(0, Math.min(index, this.getLineCount() - 1));
        NSPoint pt = new NSPoint();
        pt.x = this.scrollView.contentView().bounds().x;
        pt.y = this.getLineHeight() * row;
        this.view.scrollPoint(pt);
    }

    boolean shouldChangeTextInRange_replacementString(long id2, long sel, long affectedCharRange, long replacementString) {
        NSRange range = new NSRange();
        OS.memmove(range, affectedCharRange, (long)NSRange.sizeof);
        boolean result = this.callSuperBoolean(id2, sel, range, replacementString);
        String text = new NSString(replacementString).getString();
        if (!this.hooks(25) && this.echoCharacter == '\u0000') {
            return result && (long)this.getCharCount() - range.length + (long)text.length() <= (long)this.textLimit;
        }
        String newText = text;
        if (this.hooks(25)) {
            NSEvent currentEvent = this.display.application.currentEvent();
            long type = currentEvent.type();
            if (type != 10L && type != 11L) {
                currentEvent = null;
            }
            newText = this.verifyText(text, (int)range.location, (int)(range.location + range.length), currentEvent);
        }
        if (newText == null) {
            return false;
        }
        if ((long)this.getCharCount() - range.length + (long)newText.length() > (long)this.textLimit) {
            return false;
        }
        if ((this.style & 4) != 0) {
            if (text != newText || this.echoCharacter != '\u0000') {
                if (range.length == 1L) {
                    NSText editor = new NSText(id2);
                    editor.setSelectedRange(range);
                }
                this.insertEditText(newText);
                result = false;
            }
        } else if (text != newText) {
            NSTextView widget = (NSTextView)this.view;
            NSRange selRange = new NSRange();
            Point selection = this.getSelection();
            selRange.location = selection.x;
            selRange.length = selection.x + selection.y;
            widget.textStorage().replaceCharactersInRange(selRange, NSString.stringWith(newText));
            result = false;
        }
        if (!result) {
            this.sendEvent(24);
        }
        return result;
    }

    public void showSelection() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            this.setSelection(this.getSelection());
        } else {
            NSTextView widget = (NSTextView)this.view;
            widget.scrollRangeToVisible(widget.selectedRange());
        }
    }

    void textViewDidChangeSelection(long id2, long sel, long aNotification) {
        NSNotification notification = new NSNotification(aNotification);
        NSText editor = new NSText(notification.object().id);
        this.selectionRange = editor.selectedRange();
    }

    void textDidChange(long id2, long sel, long aNotification) {
        if ((this.style & 4) != 0) {
            super.textDidChange(id2, sel, aNotification);
        }
        this.postEvent(24);
    }

    NSRange textView_willChangeSelectionFromCharacterRange_toCharacterRange(long id2, long sel, long aTextView, long oldSelectedCharRange, long newSelectedCharRange) {
        if (this.receivingFocus && this.selectionRange != null) {
            return this.selectionRange;
        }
        NSRange result = new NSRange();
        OS.memmove(result, newSelectedCharRange, (long)NSRange.sizeof);
        return result;
    }

    int traversalCode(int key, NSEvent theEvent) {
        int bits = super.traversalCode(key, theEvent);
        if ((this.style & 8) != 0) {
            return bits;
        }
        if ((this.style & 2) != 0) {
            bits &= 0xFFFFFFFB;
            if (key == 48 && theEvent != null) {
                boolean next;
                long modifiers = theEvent.modifierFlags();
                boolean bl = next = (modifiers & 0x20000L) == 0L;
                if (next && (modifiers & 0x40000L) == 0L) {
                    bits &= 0xFFFFFFE7;
                }
            }
        }
        return bits;
    }

    void updateCursorRects(boolean enabled) {
        super.updateCursorRects(enabled);
        if (this.scrollView == null) {
            return;
        }
        NSClipView contentView = this.scrollView.contentView();
        contentView.setDocumentCursor(enabled ? NSCursor.IBeamCursor() : null);
    }

    String verifyText(String string, int start, int end, NSEvent keyEvent) {
        Event event = new Event();
        if (keyEvent != null) {
            this.setKeyState(event, 3, keyEvent);
        }
        event.text = string;
        event.start = start;
        event.end = end;
        this.sendEvent(25, event);
        if (!event.doit || this.isDisposed()) {
            return null;
        }
        return event.text;
    }
}

