/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.internal.CycleBaseHandler;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPage;

public class CycleViewHandler
extends CycleBaseHandler {
    protected void addItems(Table table, WorkbenchPage page) {
        TableItem item;
        IViewReference[] refs = page.getViewReferences();
        int i = refs.length - 1;
        while (i >= 0) {
            item = new TableItem(table, 0);
            item.setText(refs[i].getTitle());
            item.setImage(refs[i].getTitleImage());
            item.setData((Object)refs[i]);
            --i;
        }
        IEditorPart activeEditor = page.getActiveEditor();
        if (activeEditor != null) {
            item = new TableItem(table, 0);
            item.setText(WorkbenchMessages.CyclePartAction_editor);
            item.setImage(activeEditor.getTitleImage());
            item.setData((Object)activeEditor);
        }
    }

    protected ParameterizedCommand getBackwardCommand() {
        ICommandService commandService = (ICommandService)this.window.getWorkbench().getService(ICommandService.class);
        Command command = commandService.getCommand("org.eclipse.ui.window.previousView");
        ParameterizedCommand commandBack = new ParameterizedCommand(command, null);
        return commandBack;
    }

    protected ParameterizedCommand getForwardCommand() {
        ICommandService commandService = (ICommandService)this.window.getWorkbench().getService(ICommandService.class);
        Command command = commandService.getCommand("org.eclipse.ui.window.nextView");
        ParameterizedCommand commandF = new ParameterizedCommand(command, null);
        return commandF;
    }

    protected String getTableHeader(IWorkbenchPart activePart) {
        return WorkbenchMessages.CyclePartAction_header;
    }
}

