/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.dynamichelpers.IExtensionTracker;
import org.eclipse.e4.core.contexts.ContextFunction;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.PostConstruct;
import org.eclipse.e4.ui.model.application.MElementContainer;
import org.eclipse.e4.ui.model.application.MUIElement;
import org.eclipse.e4.ui.model.application.MWindow;
import org.eclipse.e4.ui.services.EContextService;
import org.eclipse.e4.workbench.ui.IPresentationEngine;
import org.eclipse.e4.workbench.ui.internal.Activator;
import org.eclipse.e4.workbench.ui.renderers.swt.TrimmedPartLayout;
import org.eclipse.jface.action.ContributionManager;
import org.eclipse.jface.action.CoolBarManager;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.ICoolBarManager;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.StatusLineManager;
import org.eclipse.jface.commands.ActionHandler;
import org.eclipse.jface.internal.provisional.action.CoolBarManager2;
import org.eclipse.jface.internal.provisional.action.IToolBarManager2;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.operation.ModalContext;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.osgi.util.TextProcessor;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.ActiveShellExpression;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPageListener;
import org.eclipse.ui.IPartService;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveListener;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.application.ActionBarAdvisor;
import org.eclipse.ui.application.WorkbenchAdvisor;
import org.eclipse.ui.application.WorkbenchWindowAdvisor;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.handlers.IHandlerActivation;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.internal.IBackgroundSaveListener;
import org.eclipse.ui.internal.PageListenerList;
import org.eclipse.ui.internal.PerspectiveListenerList;
import org.eclipse.ui.internal.StartupThreading;
import org.eclipse.ui.internal.WWinActionBars;
import org.eclipse.ui.internal.Workbench;
import org.eclipse.ui.internal.WorkbenchPage;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.WorkbenchWindowConfigurer;
import org.eclipse.ui.internal.actions.CommandAction;
import org.eclipse.ui.internal.e4.compatibility.E4Util;
import org.eclipse.ui.internal.e4.compatibility.SelectionService;
import org.eclipse.ui.internal.expressions.WorkbenchWindowExpression;
import org.eclipse.ui.internal.handlers.ActionCommandMappingService;
import org.eclipse.ui.internal.handlers.ActionDelegateHandlerProxy;
import org.eclipse.ui.internal.handlers.IActionCommandMappingService;
import org.eclipse.ui.internal.handlers.LegacyHandlerService;
import org.eclipse.ui.internal.layout.ITrimManager;
import org.eclipse.ui.internal.menus.IActionSetsListener;
import org.eclipse.ui.internal.menus.WorkbenchMenuService;
import org.eclipse.ui.internal.misc.UIListenerLogging;
import org.eclipse.ui.internal.progress.ProgressRegion;
import org.eclipse.ui.internal.provisional.application.IActionBarConfigurer2;
import org.eclipse.ui.internal.provisional.presentations.IActionBarPresentationFactory;
import org.eclipse.ui.internal.registry.UIExtensionTracker;
import org.eclipse.ui.internal.services.EvaluationReference;
import org.eclipse.ui.internal.services.IServiceLocatorCreator;
import org.eclipse.ui.internal.services.IWorkbenchLocationService;
import org.eclipse.ui.internal.services.ServiceLocator;
import org.eclipse.ui.internal.services.WorkbenchLocationService;
import org.eclipse.ui.internal.util.PrefUtil;
import org.eclipse.ui.menus.IMenuService;
import org.eclipse.ui.presentations.AbstractPresentationFactory;
import org.eclipse.ui.services.IDisposable;
import org.eclipse.ui.services.IEvaluationService;

public class WorkbenchWindow
implements IWorkbenchWindow {
    public static final String ACTION_SET_CMD_PREFIX = "AS::";
    @Inject
    private IWorkbench workbench;
    @Inject
    private MWindow model;
    @Inject
    private IPresentationEngine engine;
    private WorkbenchPage page;
    private WorkbenchWindowAdvisor windowAdvisor;
    private ActionBarAdvisor actionBarAdvisor;
    private int number;
    private PageListenerList pageListeners = new PageListenerList();
    private PerspectiveListenerList perspectiveListeners = new PerspectiveListenerList();
    private WWinActionBars actionBars;
    private boolean updateDisabled = true;
    private boolean closing = false;
    private boolean shellActivated = false;
    ProgressRegion progressRegion = null;
    private ServiceLocator serviceLocator;
    private int submenus = 0;
    private WorkbenchWindowConfigurer windowConfigurer = null;
    private ListenerList genericPropertyListeners = new ListenerList();
    private IAdaptable input;
    private IPerspectiveDescriptor perspective;
    static final String TEXT_DELIMITERS = String.valueOf(TextProcessor.getDefaultDelimiters()) + "-";
    static final String GRP_PAGES = "pages";
    static final String GRP_PERSPECTIVES = "perspectives";
    static final String GRP_FAST_VIEWS = "fastViews";
    static final int VGAP = 0;
    static final int CLIENT_INSET = 3;
    static final int BAR_SIZE = 23;
    public static final String PROP_COOLBAR_VISIBLE = "coolbarVisible";
    public static final String PROP_PERSPECTIVEBAR_VISIBLE = "perspectiveBarVisible";
    public static final String PROP_STATUS_LINE_VISIBLE = "statusLineVisible";
    public static final int SHOW_VIEW_SUBMENU = 1;
    public static final int OPEN_PERSPECTIVE_SUBMENU = 2;
    public static final int NEW_WIZARD_SUBMENU = 4;
    private static final int FILL_ALL_ACTION_BARS = 14;
    private boolean coolBarVisible = true;
    private boolean perspectiveBarVisible = true;
    private boolean fastViewBarVisible = true;
    private boolean statusLineVisible = true;
    private Map globalActionHandlersByCommandId = new HashMap();
    private List handlerActivations = new ArrayList();
    private int largeUpdates = 0;
    private IExtensionTracker tracker;
    private Set menuRestrictions = new HashSet();
    private ListenerList actionSetListeners = null;
    private ListenerList backgroundSaveListeners = new ListenerList(1);
    private ISelectionService selectionService;
    StatusLineManager statusLineManager = null;
    CoolBarManager2 cm2 = new CoolBarManager2();
    MenuManager menuManager = new MenuManager();

    public void addSubmenu(int type) {
        this.submenus |= type;
    }

    public boolean containsSubmenu(int type) {
        return (this.submenus & type) != 0;
    }

    public WorkbenchWindow(IAdaptable input, IPerspectiveDescriptor pers) {
        this.input = input;
        this.perspective = pers;
    }

    @PostConstruct
    public void setup() {
        IEclipseContext windowContext = this.model.getContext();
        IServiceLocatorCreator slc = (IServiceLocatorCreator)this.workbench.getService(IServiceLocatorCreator.class);
        this.serviceLocator = (ServiceLocator)slc.createServiceLocator(this.workbench, null, new IDisposable(){

            public void dispose() {
                Shell shell = WorkbenchWindow.this.getShell();
                if (shell != null && !shell.isDisposed()) {
                    WorkbenchWindow.this.close();
                }
            }
        });
        this.serviceLocator.setContext(windowContext);
        windowContext.set(IExtensionTracker.class.getName(), (Object)new ContextFunction(){

            public Object compute(IEclipseContext context, Object[] arguments) {
                if (WorkbenchWindow.this.tracker == null) {
                    WorkbenchWindow.this.tracker = (IExtensionTracker)new UIExtensionTracker(WorkbenchWindow.this.getWorkbench().getDisplay());
                }
                return WorkbenchWindow.this.tracker;
            }
        });
        try {
            this.page = new WorkbenchPage(this, this.input);
        }
        catch (WorkbenchException e) {
            WorkbenchPlugin.log((Throwable)((Object)e));
        }
        windowContext.set(IWorkbenchWindow.class.getName(), (Object)this);
        windowContext.set(IWorkbenchPage.class.getName(), (Object)this.page);
        windowContext.set("activeWorkbenchWindow", (Object)this);
        windowContext.set("activeWorkbenchWindowShell", (Object)this.getShell());
        EContextService cs = (EContextService)windowContext.get(EContextService.class.getName());
        cs.activateContext("org.eclipse.ui.contexts.window");
        cs.getActiveContextIds();
        this.initializeDefaultServices();
        this.fireWindowOpening();
        this.fillActionBars(14);
    }

    public static String getId(IConfigurationElement element) {
        String id = element.getAttribute("id");
        if (id == null || id.length() == 0) {
            id = WorkbenchWindow.getCommandId(element);
        }
        if (id == null || id.length() == 0) {
            id = element.toString();
        }
        return id;
    }

    public static String getCommandId(IConfigurationElement element) {
        return element.getAttribute("commandId");
    }

    public static String getActionSetCommandId(IConfigurationElement element) {
        String id = WorkbenchWindow.getDefinitionId(element);
        if (id != null) {
            return id;
        }
        id = WorkbenchWindow.getId(element);
        String actionSetId = null;
        Object obj = element.getParent();
        while (obj instanceof IConfigurationElement && actionSetId == null) {
            IConfigurationElement parent = (IConfigurationElement)obj;
            if (parent.getName().equals("actionSet")) {
                actionSetId = WorkbenchWindow.getId(parent);
            }
            obj = parent.getParent();
        }
        return ACTION_SET_CMD_PREFIX + actionSetId + '/' + id;
    }

    public static String getDefinitionId(IConfigurationElement element) {
        return element.getAttribute("definitionId");
    }

    public static boolean getRetarget(IConfigurationElement element) {
        String r = element.getAttribute("retarget");
        return Boolean.valueOf(r);
    }

    private void readActionSets() {
        IConfigurationElement[] actionSetElements;
        IEclipseContext windowContext = this.model.getContext();
        WorkbenchWindowExpression windowExpression = new WorkbenchWindowExpression(this);
        ICommandService cs = (ICommandService)windowContext.get(ICommandService.class.getName());
        IExtensionRegistry registry = (IExtensionRegistry)windowContext.get(IExtensionRegistry.class.getName());
        IExtensionPoint extPoint = registry.getExtensionPoint("org.eclipse.ui.actionSets");
        IConfigurationElement[] iConfigurationElementArray = actionSetElements = extPoint.getConfigurationElements();
        int n = actionSetElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement[] elements;
            IConfigurationElement ase = iConfigurationElementArray[n2];
            IConfigurationElement[] iConfigurationElementArray2 = elements = ase.getChildren("action");
            int n3 = elements.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement configElement = iConfigurationElementArray2[n4];
                String id = WorkbenchWindow.getId(configElement);
                String cmdId = WorkbenchWindow.getActionSetCommandId(configElement);
                if (id != null && id.length() != 0 && !WorkbenchWindow.getRetarget(configElement)) {
                    Command cmd = cs.getCommand(cmdId);
                    if (!cmd.isDefined()) {
                        Activator.trace((String)"/trace/commands", (String)("Still no command for " + cmdId), null);
                    } else {
                        LegacyHandlerService.registerLegacyHandler(windowContext, id, cmdId, (IHandler)new ActionDelegateHandlerProxy(configElement, "class", id, new ParameterizedCommand(cmd, null), this, null, null, null), windowExpression);
                    }
                }
                ++n4;
            }
            ++n2;
        }
    }

    protected int perspectiveBarStyle() {
        return 8520000;
    }

    void registerGlobalAction(IAction globalAction) {
        String commandId = globalAction.getActionDefinitionId();
        if (commandId != null) {
            Object value = this.globalActionHandlersByCommandId.get(commandId);
            if (value instanceof ActionHandler) {
                ActionHandler handler = (ActionHandler)value;
                handler.dispose();
            }
            if (globalAction instanceof CommandAction) {
                String actionId = globalAction.getId();
                if (actionId != null) {
                    IActionCommandMappingService mappingService = (IActionCommandMappingService)this.serviceLocator.getService(IActionCommandMappingService.class);
                    mappingService.map(actionId, commandId);
                }
            } else {
                this.globalActionHandlersByCommandId.put(commandId, new ActionHandler(globalAction));
            }
        }
        this.submitGlobalActions();
    }

    void submitGlobalActions() {
        IHandlerService handlerService = (IHandlerService)this.getWorkbench().getService(IHandlerService.class);
        HashMap handlersByCommandId = new HashMap();
        handlersByCommandId.putAll(this.globalActionHandlersByCommandId);
        ArrayList<IHandlerActivation> newHandlers = new ArrayList<IHandlerActivation>(handlersByCommandId.size());
        for (IHandlerActivation next : this.handlerActivations) {
            String cmdId = next.getCommandId();
            Object handler = handlersByCommandId.get(cmdId);
            if (handler == next.getHandler()) {
                handlersByCommandId.remove(cmdId);
                newHandlers.add(next);
                continue;
            }
            handlerService.deactivateHandler(next);
        }
        Shell shell = this.getShell();
        if (shell != null) {
            ActiveShellExpression expression = new ActiveShellExpression(shell);
            for (Map.Entry entry : handlersByCommandId.entrySet()) {
                String commandId = (String)entry.getKey();
                IHandler handler = (IHandler)entry.getValue();
                newHandlers.add(handlerService.activateHandler(commandId, handler, expression));
            }
        }
        this.handlerActivations = newHandlers;
    }

    public void addPropertyChangeListener(IPropertyChangeListener listener) {
        this.genericPropertyListeners.add((Object)listener);
    }

    public void removePropertyChangeListener(IPropertyChangeListener listener) {
        this.genericPropertyListeners.remove((Object)listener);
    }

    private void firePropertyChanged(String property, Object oldValue, Object newValue) {
        PropertyChangeEvent event = new PropertyChangeEvent((Object)this, property, oldValue, newValue);
        Object[] listeners = this.genericPropertyListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            IPropertyChangeListener listener = (IPropertyChangeListener)listeners[i];
            listener.propertyChange(event);
            ++i;
        }
    }

    public void addPageListener(IPageListener l) {
        this.pageListeners.addPageListener(l);
    }

    public void addPerspectiveListener(IPerspectiveListener l) {
        this.perspectiveListeners.addPerspectiveListener(l);
    }

    private boolean busyClose() {
        boolean windowClosed = false;
        this.closing = true;
        this.updateDisabled = true;
        try {
            Workbench workbench = this.getWorkbenchImpl();
            int count = workbench.getWorkbenchWindowCount();
            if (!workbench.isStarting() && !workbench.isClosing() && count <= 1 && workbench.getWorkbenchConfigurer().getExitOnLastWindowClose()) {
                windowClosed = workbench.close();
            } else if (this.okToClose()) {
                windowClosed = this.hardClose();
            }
        }
        finally {
            if (!windowClosed) {
                this.closing = false;
                this.updateDisabled = false;
            }
        }
        if (windowClosed && this.tracker != null) {
            this.tracker.close();
        }
        return windowClosed;
    }

    public Shell getShell() {
        return (Shell)this.model.getWidget();
    }

    public boolean close() {
        final boolean[] ret = new boolean[1];
        BusyIndicator.showWhile(null, (Runnable)new Runnable(){

            public void run() {
                ret[0] = WorkbenchWindow.this.busyClose();
            }
        });
        return ret[0];
    }

    protected boolean isClosing() {
        return this.closing || this.getWorkbenchImpl().isClosing();
    }

    private void fireWindowOpening() {
        this.getWindowAdvisor().preWindowOpen();
    }

    void fireWindowRestored() throws WorkbenchException {
        StartupThreading.runWithWorkbenchExceptions(new StartupThreading.StartupRunnable(){

            public void runWithException() throws Throwable {
                WorkbenchWindow.this.getWindowAdvisor().postWindowRestore();
            }
        });
    }

    private void fireWindowClosed() {
        this.getWindowAdvisor().postWindowClose();
        this.getWorkbenchImpl().fireWindowClosed(this);
    }

    void firePerspectiveActivated(IWorkbenchPage page, IPerspectiveDescriptor perspective) {
        UIListenerLogging.logPerspectiveEvent(this, page, perspective, "perspectiveActivated");
        this.perspectiveListeners.firePerspectiveActivated(page, perspective);
    }

    void firePerspectivePreDeactivate(IWorkbenchPage page, IPerspectiveDescriptor perspective) {
        UIListenerLogging.logPerspectiveEvent(this, page, perspective, "perspectivePreDeactivate");
        this.perspectiveListeners.firePerspectivePreDeactivate(page, perspective);
    }

    void firePerspectiveDeactivated(IWorkbenchPage page, IPerspectiveDescriptor perspective) {
        UIListenerLogging.logPerspectiveEvent(this, page, perspective, "perspectiveDeactivated");
        this.perspectiveListeners.firePerspectiveDeactivated(page, perspective);
    }

    public void firePerspectiveChanged(IWorkbenchPage page, IPerspectiveDescriptor perspective, String changeId) {
        if (perspective != null) {
            UIListenerLogging.logPerspectiveChangedEvent(this, page, perspective, null, changeId);
            this.perspectiveListeners.firePerspectiveChanged(page, perspective, changeId);
        }
    }

    public void firePerspectiveChanged(IWorkbenchPage page, IPerspectiveDescriptor perspective, IWorkbenchPartReference partRef, String changeId) {
        if (perspective != null) {
            UIListenerLogging.logPerspectiveChangedEvent(this, page, perspective, partRef, changeId);
            this.perspectiveListeners.firePerspectiveChanged(page, perspective, partRef, changeId);
        }
    }

    void firePerspectiveClosed(IWorkbenchPage page, IPerspectiveDescriptor perspective) {
        UIListenerLogging.logPerspectiveEvent(this, page, perspective, "perspectiveClosed");
        this.perspectiveListeners.firePerspectiveClosed(page, perspective);
    }

    void firePerspectiveOpened(IWorkbenchPage page, IPerspectiveDescriptor perspective) {
        UIListenerLogging.logPerspectiveEvent(this, page, perspective, "perspectiveOpened");
        this.perspectiveListeners.firePerspectiveOpened(page, perspective);
    }

    void firePerspectiveSavedAs(IWorkbenchPage page, IPerspectiveDescriptor oldPerspective, IPerspectiveDescriptor newPerspective) {
        UIListenerLogging.logPerspectiveSavedAs(this, page, oldPerspective, newPerspective);
        this.perspectiveListeners.firePerspectiveSavedAs(page, oldPerspective, newPerspective);
    }

    public WWinActionBars getActionBars() {
        if (this.actionBars == null) {
            this.actionBars = new WWinActionBars(this);
        }
        return this.actionBars;
    }

    public IWorkbenchPage getActivePage() {
        return this.page;
    }

    public int getNumber() {
        return this.number;
    }

    public IWorkbenchPage[] getPages() {
        return new IWorkbenchPage[]{this.page};
    }

    public IPartService getPartService() {
        return this.page;
    }

    protected Layout getLayout() {
        return null;
    }

    public ISelectionService getSelectionService() {
        return this.selectionService;
    }

    public boolean getShellActivated() {
        return this.shellActivated;
    }

    public IWorkbench getWorkbench() {
        return PlatformUI.getWorkbench();
    }

    private boolean hardClose() {
        try {
            IWorkbench workbench = this.getWorkbench();
            IHandlerService handlerService = (IHandlerService)workbench.getService(IHandlerService.class);
            handlerService.deactivateHandlers(this.handlerActivations);
            for (IHandlerActivation activation : this.handlerActivations) {
                activation.getHandler().dispose();
            }
            this.handlerActivations.clear();
            this.globalActionHandlersByCommandId.clear();
            IContextService contextService = (IContextService)workbench.getService(IContextService.class);
            contextService.unregisterShell(this.getShell());
            MElementContainer parent = this.model.getParent();
            this.model.getParent().getChildren().remove((Object)this.model);
            if (parent.getSelectedElement() == this.model && !parent.getChildren().isEmpty()) {
                parent.setSelectedElement((MUIElement)parent.getChildren().get(0));
            }
            this.engine.removeGui((MUIElement)this.model);
            this.fireWindowClosed();
            IMenuService menuService = (IMenuService)workbench.getService(IMenuService.class);
            menuService.releaseContributions((ContributionManager)this.getActionBars().getMenuManager());
            ICoolBarManager coolbar = this.getActionBars().getCoolBarManager();
            if (coolbar != null) {
                menuService.releaseContributions((ContributionManager)coolbar);
            }
            this.getActionBarAdvisor().dispose();
            this.getWindowAdvisor().dispose();
            this.progressRegion = null;
        }
        finally {
            try {
                this.serviceLocator.dispose();
            }
            catch (Exception ex) {
                WorkbenchPlugin.log(ex);
            }
            this.menuRestrictions.clear();
        }
        return true;
    }

    public boolean isApplicationMenu(String menuID) {
        return this.getActionBarAdvisor().isApplicationMenu(menuID);
    }

    public boolean okToClose() {
        this.getWorkbenchImpl().isClosing();
        return true;
    }

    public IWorkbenchPage openPage(String perspectiveId, IAdaptable input) throws WorkbenchException {
        return this.workbench.openWorkbenchWindow(perspectiveId, input).getActivePage();
    }

    public IWorkbenchPage openPage(IAdaptable input) throws WorkbenchException {
        return this.openPage(this.workbench.getPerspectiveRegistry().getDefaultPerspective(), input);
    }

    public void removePageListener(IPageListener l) {
        this.pageListeners.removePageListener(l);
    }

    public void removePerspectiveListener(IPerspectiveListener l) {
        this.perspectiveListeners.removePerspectiveListener(l);
    }

    public void run(final boolean fork, boolean cancelable, final IRunnableWithProgress runnable) throws InvocationTargetException, InterruptedException {
        final StatusLineManager manager = this.getStatusLineManager();
        if (manager == null) {
            runnable.run((IProgressMonitor)new NullProgressMonitor());
        } else {
            boolean wasCancelEnabled = manager.isCancelEnabled();
            try {
                manager.setCancelEnabled(cancelable);
                final InvocationTargetException[] ite = new InvocationTargetException[1];
                final InterruptedException[] ie = new InterruptedException[1];
                BusyIndicator.showWhile((Display)this.getShell().getDisplay(), (Runnable)new Runnable(){

                    public void run() {
                        try {
                            ModalContext.run((IRunnableWithProgress)runnable, (boolean)fork, (IProgressMonitor)manager.getProgressMonitor(), (Display)WorkbenchWindow.this.getShell().getDisplay());
                        }
                        catch (InvocationTargetException e) {
                            ite[0] = e;
                        }
                        catch (InterruptedException e) {
                            ie[0] = e;
                        }
                    }
                });
                if (ite[0] != null) {
                    throw ite[0];
                }
                if (ie[0] != null) {
                    throw ie[0];
                }
            }
            finally {
                manager.setCancelEnabled(wasCancelEnabled);
            }
        }
    }

    public void setActivePage(IWorkbenchPage in) {
        if (this.getActivePage() == in) {
            return;
        }
        E4Util.unsupported("setActivePage(page) == broken");
        this.page = (WorkbenchPage)in;
    }

    private Boolean valueOf(boolean result) {
        return result ? Boolean.TRUE : Boolean.FALSE;
    }

    public Set getMenuRestrictions() {
        return this.menuRestrictions;
    }

    void liftRestrictions() {
        IMenuService ms;
        if (this.menuRestrictions.isEmpty()) {
            return;
        }
        EvaluationReference[] refs = this.menuRestrictions.toArray(new EvaluationReference[this.menuRestrictions.size()]);
        IEvaluationService es = (IEvaluationService)this.serviceLocator.getService(IEvaluationService.class);
        IEvaluationContext currentState = es.getCurrentState();
        boolean changeDetected = false;
        int i = 0;
        while (i < refs.length) {
            EvaluationReference reference = refs[i];
            reference.setPostingChanges(true);
            boolean os = reference.evaluate(currentState);
            reference.clearResult();
            boolean ns = reference.evaluate(currentState);
            if (os != ns) {
                changeDetected = true;
                reference.getListener().propertyChange(new PropertyChangeEvent((Object)reference, reference.getProperty(), (Object)this.valueOf(os), (Object)this.valueOf(ns)));
            }
            ++i;
        }
        if (changeDetected && (ms = (IMenuService)this.getWorkbench().getService(IMenuService.class)) instanceof WorkbenchMenuService) {
            ((WorkbenchMenuService)ms).updateManagers();
        }
    }

    void imposeRestrictions() {
        for (EvaluationReference ref : this.menuRestrictions) {
            ref.setPostingChanges(false);
        }
    }

    void trackShellActivation(Shell shell) {
        this.getShell().addShellListener((ShellListener)new ShellAdapter(){

            public void shellActivated(ShellEvent event) {
                WorkbenchWindow.this.shellActivated = true;
                WorkbenchWindow.this.serviceLocator.activate();
                WorkbenchWindow.this.getWorkbenchImpl().setActivatedWindow(WorkbenchWindow.this);
                WorkbenchPage currentPage = (WorkbenchPage)WorkbenchWindow.this.getActivePage();
                if (currentPage != null) {
                    IWorkbenchPart part = currentPage.getActivePart();
                    IEditorPart editor = currentPage.getActiveEditor();
                    WorkbenchWindow.this.getWorkbenchImpl().fireWindowActivated(WorkbenchWindow.this);
                }
                WorkbenchWindow.this.liftRestrictions();
            }

            public void shellDeactivated(ShellEvent event) {
                WorkbenchWindow.this.shellActivated = false;
                WorkbenchWindow.this.imposeRestrictions();
                WorkbenchWindow.this.serviceLocator.deactivate();
                WorkbenchPage currentPage = (WorkbenchPage)WorkbenchWindow.this.getActivePage();
                if (currentPage != null) {
                    IWorkbenchPart part = currentPage.getActivePart();
                    IEditorPart editor = currentPage.getActiveEditor();
                    WorkbenchWindow.this.getWorkbenchImpl().fireWindowDeactivated(WorkbenchWindow.this);
                }
            }
        });
    }

    public void updateActionBars() {
        if (this.updateDisabled || this.updatesDeferred()) {
            return;
        }
    }

    private boolean updatesDeferred() {
        return this.largeUpdates > 0;
    }

    public final void largeUpdateStart() {
        ++this.largeUpdates;
    }

    public final void largeUpdateEnd() {
        if (--this.largeUpdates == 0) {
            this.updateActionBars();
        }
    }

    public void updateActionSets() {
        if (this.updateDisabled) {
            return;
        }
    }

    final void addActionSetsListener(IActionSetsListener listener) {
        if (this.actionSetListeners == null) {
            this.actionSetListeners = new ListenerList();
        }
        this.actionSetListeners.add((Object)listener);
    }

    final void removeActionSetsListener(IActionSetsListener listener) {
        if (this.actionSetListeners != null) {
            this.actionSetListeners.remove((Object)listener);
            if (this.actionSetListeners.isEmpty()) {
                this.actionSetListeners = null;
            }
        }
    }

    void createProgressIndicator(Shell shell) {
        if (this.getWindowConfigurer().getShowProgressIndicator()) {
            this.progressRegion = new ProgressRegion();
            this.progressRegion.createContents((Composite)shell, this);
        }
    }

    WorkbenchWindowConfigurer getWindowConfigurer() {
        if (this.windowConfigurer == null) {
            this.windowConfigurer = new WorkbenchWindowConfigurer(this);
        }
        return this.windowConfigurer;
    }

    private WorkbenchAdvisor getAdvisor() {
        return this.getWorkbenchImpl().getAdvisor();
    }

    WorkbenchWindowAdvisor getWindowAdvisor() {
        if (this.windowAdvisor == null) {
            this.windowAdvisor = this.getAdvisor().createWorkbenchWindowAdvisor(this.getWindowConfigurer());
            Assert.isNotNull((Object)this.windowAdvisor);
        }
        return this.windowAdvisor;
    }

    private ActionBarAdvisor getActionBarAdvisor() {
        if (this.actionBarAdvisor == null) {
            this.actionBarAdvisor = this.getWindowAdvisor().createActionBarAdvisor(this.getWindowConfigurer().getActionBarConfigurer());
            Assert.isNotNull((Object)this.actionBarAdvisor);
        }
        return this.actionBarAdvisor;
    }

    private Workbench getWorkbenchImpl() {
        return Workbench.getInstance();
    }

    public void fillActionBars(int flags) {
        Workbench workbench = this.getWorkbenchImpl();
        workbench.largeUpdateStart();
        try {
            this.getActionBarAdvisor().fillActionBars(flags);
            IMenuService menuService = (IMenuService)this.serviceLocator.getService(IMenuService.class);
            menuService.populateContributionManager((ContributionManager)this.getActionBars().getMenuManager(), "menu:org.eclipse.ui.main.menu");
            ICoolBarManager coolbar = this.getActionBars().getCoolBarManager();
            if (coolbar != null) {
                menuService.populateContributionManager((ContributionManager)coolbar, "toolbar:org.eclipse.ui.main.toolbar");
            }
        }
        finally {
            workbench.largeUpdateEnd();
        }
    }

    public void fillActionBars(IActionBarConfigurer2 proxyBars, int flags) {
        Assert.isNotNull((Object)proxyBars);
        WorkbenchWindowConfigurer.WindowActionBarConfigurer wab = (WorkbenchWindowConfigurer.WindowActionBarConfigurer)this.getWindowConfigurer().getActionBarConfigurer();
        wab.setProxy(proxyBars);
        try {
            this.getActionBarAdvisor().fillActionBars(flags | 1);
        }
        finally {
            wab.setProxy(null);
        }
    }

    public void setCoolBarVisible(boolean visible) {
        boolean oldValue = this.coolBarVisible;
        this.coolBarVisible = visible;
        if (oldValue != this.coolBarVisible) {
            this.firePropertyChanged(PROP_COOLBAR_VISIBLE, oldValue ? Boolean.TRUE : Boolean.FALSE, this.coolBarVisible ? Boolean.TRUE : Boolean.FALSE);
        }
    }

    public boolean getCoolBarVisible() {
        return this.getWindowConfigurer().getShowCoolBar() && this.coolBarVisible;
    }

    public void setPerspectiveBarVisible(boolean visible) {
        boolean oldValue = this.perspectiveBarVisible;
        this.perspectiveBarVisible = visible;
        if (oldValue != this.perspectiveBarVisible) {
            this.firePropertyChanged(PROP_PERSPECTIVEBAR_VISIBLE, oldValue ? Boolean.TRUE : Boolean.FALSE, this.perspectiveBarVisible ? Boolean.TRUE : Boolean.FALSE);
        }
    }

    public boolean getPerspectiveBarVisible() {
        return this.getWindowConfigurer().getShowPerspectiveBar() && this.perspectiveBarVisible;
    }

    public void setFastViewBarVisible(boolean visible) {
        boolean oldValue = this.fastViewBarVisible;
        this.fastViewBarVisible = visible;
    }

    public boolean getFastViewBarVisible() {
        return this.fastViewBarVisible;
    }

    public void setStatusLineVisible(boolean visible) {
        boolean oldValue = this.statusLineVisible;
        this.statusLineVisible = visible;
        if (oldValue != this.statusLineVisible) {
            this.firePropertyChanged(PROP_STATUS_LINE_VISIBLE, oldValue ? Boolean.TRUE : Boolean.FALSE, this.statusLineVisible ? Boolean.TRUE : Boolean.FALSE);
        }
    }

    public boolean getStatusLineVisible() {
        return this.statusLineVisible;
    }

    public boolean getShowFastViewBars() {
        return this.getWindowConfigurer().getShowFastViewBars();
    }

    public IActionBarPresentationFactory getActionBarPresentationFactory() {
        E4Util.unsupported("getActionBarPresentationFactory: doesn't do anything useful, should cause NPE");
        IActionBarPresentationFactory actionBarPresentation = null;
        AbstractPresentationFactory presentationFactory = this.getWindowConfigurer().getPresentationFactory();
        if (presentationFactory instanceof IActionBarPresentationFactory) {
            actionBarPresentation = (IActionBarPresentationFactory)((Object)presentationFactory);
        }
        return actionBarPresentation;
    }

    protected boolean showTopSeperator() {
        return false;
    }

    public ProgressRegion getProgressRegion() {
        return this.progressRegion;
    }

    public IExtensionTracker getExtensionTracker() {
        return (IExtensionTracker)this.model.getContext().get(IExtensionTracker.class.getName());
    }

    IAdaptable getDefaultPageInput() {
        return this.getWorkbenchImpl().getDefaultPageInput();
    }

    public ITrimManager getTrimManager() {
        return null;
    }

    private final void initializeDefaultServices() {
        IEclipseContext windowContext = this.model.getContext();
        this.serviceLocator.registerService(IWorkbenchLocationService.class, new WorkbenchLocationService("org.eclipse.ui.IWorkbenchWindow", this.getWorkbench(), this, null, null, null, 1));
        this.serviceLocator.registerService(IWorkbenchWindow.class, this);
        ActionCommandMappingService mappingService = new ActionCommandMappingService();
        this.serviceLocator.registerService(IActionCommandMappingService.class, mappingService);
        try {
            this.selectionService = (ISelectionService)ContextInjectionFactory.make(SelectionService.class, (IEclipseContext)this.model.getContext());
        }
        catch (InvocationTargetException e) {
            WorkbenchPlugin.log(e);
        }
        catch (InstantiationException e) {
            WorkbenchPlugin.log(e);
        }
        ContextInjectionFactory.inject((Object)this.page, (IEclipseContext)this.model.getContext());
        this.page.setPerspective(this.perspective);
        LegacyHandlerService hs = new LegacyHandlerService(windowContext);
        windowContext.set(IHandlerService.class.getName(), (Object)hs);
        this.readActionSets();
    }

    public final Object getService(Class key) {
        return this.serviceLocator.getService(key);
    }

    public final boolean hasService(Class key) {
        return this.serviceLocator.hasService(key);
    }

    public void toggleToolbarVisibility() {
        boolean coolbarVisible = this.getCoolBarVisible();
        boolean perspectivebarVisible = this.getPerspectiveBarVisible();
        IPreferenceStore prefs = PrefUtil.getInternalPreferenceStore();
        if (this.getWindowConfigurer().getShowCoolBar()) {
            this.setCoolBarVisible(!coolbarVisible);
            prefs.setValue("coolBarVisible", !coolbarVisible);
        }
        if (this.getWindowConfigurer().getShowPerspectiveBar()) {
            this.setPerspectiveBarVisible(!perspectivebarVisible);
            prefs.setValue(PROP_PERSPECTIVEBAR_VISIBLE, !perspectivebarVisible);
        }
        this.getShell().layout();
    }

    void addBackgroundSaveListener(IBackgroundSaveListener listener) {
        this.backgroundSaveListeners.add((Object)listener);
    }

    void fireBackgroundSaveStarted() {
        Object[] listeners = this.backgroundSaveListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            IBackgroundSaveListener listener = (IBackgroundSaveListener)listeners[i];
            listener.handleBackgroundSaveStarted();
            ++i;
        }
    }

    void removeBackgroundSaveListener(IBackgroundSaveListener listener) {
        this.backgroundSaveListeners.remove((Object)listener);
    }

    public MWindow getModel() {
        return this.model;
    }

    public StatusLineManager getStatusLineManager() {
        Shell shell;
        if (this.statusLineManager == null && (shell = (Shell)this.model.getWidget()) != null) {
            TrimmedPartLayout layout = (TrimmedPartLayout)shell.getLayout();
            Composite trimComposite = layout.getTrimComposite((Composite)shell, 1024);
            trimComposite.setLayout((Layout)new FillLayout());
            this.statusLineManager = new StatusLineManager();
            Control control = this.statusLineManager.createControl(trimComposite);
            control.setSize(control.computeSize(-1, -1));
        }
        return this.statusLineManager;
    }

    public ICoolBarManager getCoolBarManager2() {
        return this.cm2;
    }

    public CoolBarManager getCoolBarManager() {
        return this.cm2;
    }

    public MenuManager getMenuManager() {
        return this.menuManager;
    }

    public IMenuManager getMenuBarManager() {
        return this.menuManager;
    }

    public IToolBarManager2 getToolBarManager2() {
        return null;
    }

    public IToolBarManager getToolBarManager() {
        return this.getToolBarManager2();
    }
}

