/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.registry;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.MPartDescriptor;
import org.eclipse.e4.ui.workbench.swt.util.ISWTResourceUtiltities;
import org.eclipse.e4.workbench.ui.IResourceUtiltities;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IPluginContribution;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.registry.RegistryReader;
import org.eclipse.ui.views.IViewDescriptor;

public class ViewDescriptor
implements IViewDescriptor,
IPluginContribution {
    private MApplication application;
    private MPartDescriptor descriptor;
    private IConfigurationElement element;
    private String[] categoryPath;
    private ImageDescriptor imageDescriptor;

    public ViewDescriptor(MApplication application, MPartDescriptor descriptor, IConfigurationElement element) {
        this.application = application;
        this.descriptor = descriptor;
        this.element = element;
        String category = descriptor.getCategory();
        if (category != null) {
            this.categoryPath = category.split("/");
        }
    }

    public IViewPart createView() throws CoreException {
        if (this.element == null) {
            throw new CoreException((IStatus)new Status(4, WorkbenchPlugin.PI_WORKBENCH, "Unable to create an e4 view of id " + this.descriptor.getId()));
        }
        return (IViewPart)this.element.createExecutableExtension("class");
    }

    public String[] getCategoryPath() {
        return this.categoryPath;
    }

    public String getDescription() {
        return this.element == null ? "" : RegistryReader.getDescription(this.element);
    }

    public String getId() {
        return this.descriptor.getId();
    }

    public ImageDescriptor getImageDescriptor() {
        if (this.imageDescriptor == null) {
            String iconURI = this.descriptor.getIconURI();
            if (iconURI == null) {
                IWorkbench workbench = (IWorkbench)this.application.getContext().get(IWorkbench.class.getName());
                this.imageDescriptor = workbench.getSharedImages().getImageDescriptor("IMG_DEF_VIEW");
            } else {
                ISWTResourceUtiltities utility = (ISWTResourceUtiltities)this.application.getContext().get(IResourceUtiltities.class.getName());
                this.imageDescriptor = (ImageDescriptor)utility.imageDescriptorFromURI(URI.createURI((String)iconURI));
            }
        }
        return this.imageDescriptor;
    }

    public String getLabel() {
        return this.descriptor.getLabel();
    }

    public float getFastViewWidthRatio() {
        return 0.0f;
    }

    public boolean getAllowMultiple() {
        return this.descriptor.isAllowMultiple();
    }

    public boolean isRestorable() {
        return this.element == null ? false : Boolean.parseBoolean(this.element.getAttribute("restorable"));
    }

    public Object getAdapter(Class adapter) {
        if (adapter != null && adapter.equals(IConfigurationElement.class)) {
            return this.getConfigurationElement();
        }
        return null;
    }

    public IConfigurationElement getConfigurationElement() {
        return this.element;
    }

    public String getLocalId() {
        return this.getId();
    }

    public String getPluginId() {
        return this.getConfigurationElement().getNamespaceIdentifier();
    }
}

