/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.services;

import org.eclipse.core.expressions.EvaluationResult;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.e4.core.contexts.ContextChangeEvent;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.contexts.IRunAndTrack;
import org.eclipse.e4.workbench.ui.internal.Activator;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.ui.internal.services.LegacyEvalContext;
import org.eclipse.ui.internal.services.SourcePriorityNameMapping;
import org.eclipse.ui.services.IEvaluationReference;

public class EvaluationReference
implements IEvaluationReference,
IRunAndTrack {
    final IEclipseContext context;
    final Expression expression;
    final IPropertyChangeListener listener;
    final String property;
    final int sourcePriority;
    boolean cache;
    boolean participating = true;
    boolean postingChanges = true;

    public EvaluationReference(IEclipseContext context, Expression expression, IPropertyChangeListener listener, String property) {
        this.context = context;
        this.expression = expression;
        this.listener = listener;
        this.property = property;
        this.sourcePriority = SourcePriorityNameMapping.computeSourcePriority(expression);
    }

    public void clearResult() {
    }

    public Expression getExpression() {
        return this.expression;
    }

    public int getSourcePriority() {
        return this.sourcePriority;
    }

    public boolean evaluate(IEvaluationContext context) {
        if (this.expression == null) {
            this.cache = true;
        } else {
            try {
                this.cache = this.expression.evaluate(context) != EvaluationResult.FALSE;
            }
            catch (CoreException e) {
                Activator.trace((String)"/trace/commands", (String)"Failed to calculate active", (Throwable)e);
            }
        }
        return this.cache;
    }

    public void setResult(boolean result) {
    }

    public boolean notify(ContextChangeEvent event) {
        if (event.getEventType() == 3) {
            return false;
        }
        if (!this.participating) {
            return false;
        }
        this.evaluate();
        return this.participating;
    }

    public void evaluate() {
        boolean value = this.cache;
        this.evaluate(new LegacyEvalContext(this.context));
        if (!this.postingChanges) {
            return;
        }
        if (value != this.cache) {
            this.getListener().propertyChange(new PropertyChangeEvent((Object)this, this.getProperty(), (Object)value, (Object)this.cache));
        }
    }

    public IPropertyChangeListener getListener() {
        return this.listener;
    }

    public String getProperty() {
        return this.property;
    }

    public void setPostingChanges(boolean b) {
        this.postingChanges = b;
    }

    public boolean isPostingChanges() {
        return this.postingChanges;
    }
}

