/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.operations;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.p2.operations.Messages;
import org.eclipse.equinox.internal.p2.operations.PlanAnalyzer;
import org.eclipse.equinox.internal.p2.operations.ResolutionResult;
import org.eclipse.equinox.internal.provisional.p2.director.ProfileChangeRequest;
import org.eclipse.equinox.p2.engine.IProvisioningPlan;
import org.eclipse.equinox.p2.engine.ProvisioningContext;
import org.eclipse.equinox.p2.operations.IProfileChangeJob;
import org.eclipse.equinox.p2.operations.ProvisioningJob;
import org.eclipse.equinox.p2.operations.ProvisioningSession;
import org.eclipse.equinox.p2.planner.IPlanner;
import org.eclipse.equinox.p2.planner.IProfileChangeRequest;

public class PlannerResolutionJob
extends ProvisioningJob
implements IProfileChangeJob {
    ProfileChangeRequest request;
    String profileId;
    IProvisioningPlan plan;
    MultiStatus additionalStatus;
    ResolutionResult report;
    ProvisioningContext provisioningContext;

    public static MultiStatus getProfileChangeRequestAlteredStatus() {
        return PlanAnalyzer.getProfileChangeAlteredStatus();
    }

    public PlannerResolutionJob(String label, ProvisioningSession session, String profileId, ProfileChangeRequest request, ProvisioningContext provisioningContext, MultiStatus additionalStatus) {
        super(label, session);
        this.request = request;
        this.profileId = profileId;
        this.provisioningContext = provisioningContext == null ? new ProvisioningContext(session.getProvisioningAgent()) : provisioningContext;
        Assert.isNotNull((Object)additionalStatus);
        this.additionalStatus = additionalStatus;
    }

    public IProvisioningPlan getProvisioningPlan() {
        return this.plan;
    }

    public ProfileChangeRequest getProfileChangeRequest() {
        return this.request;
    }

    public ProvisioningContext getProvisioningContext() {
        return this.provisioningContext;
    }

    public void setProvisioningContext(ProvisioningContext context) {
        this.provisioningContext = context;
    }

    public IStatus runModal(IProgressMonitor monitor) {
        this.plan = ((IPlanner)this.getSession().getProvisioningAgent().getService(IPlanner.SERVICE_NAME)).getProvisioningPlan((IProfileChangeRequest)this.request, this.provisioningContext, monitor);
        if (this.plan == null) {
            return new Status(4, "org.eclipse.equinox.p2.operations", Messages.PlannerResolutionJob_NullProvisioningPlan);
        }
        return this.plan.getStatus();
    }

    public ResolutionResult getResolutionResult() {
        if (this.report == null) {
            this.report = PlanAnalyzer.computeResolutionResult(this.request, this.plan, this.additionalStatus);
        }
        return this.report;
    }

    public String getProfileId() {
        return this.profileId;
    }
}

