/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.launching.launcher;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.IStatusHandler;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.core.plugin.IPluginAttribute;
import org.eclipse.pde.core.plugin.IPluginElement;
import org.eclipse.pde.core.plugin.IPluginExtension;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.core.plugin.TargetPlatform;
import org.eclipse.pde.internal.core.util.IdUtil;
import org.eclipse.pde.internal.launching.PDELaunchingPlugin;
import org.eclipse.pde.internal.launching.PDEMessages;
import org.eclipse.pde.internal.launching.launcher.BundleLauncherHelper;
import org.eclipse.pde.internal.launching.launcher.LaunchValidationOperation;

public class EclipsePluginValidationOperation
extends LaunchValidationOperation {
    public static final int CREATE_EXTENSION_ERROR_CODE = 1000;
    private Map fExtensionErrors = new HashMap(2);
    private static Object[] EMPTY = new Object[0];

    public EclipsePluginValidationOperation(ILaunchConfiguration configuration) {
        super(configuration);
    }

    protected IPluginModelBase[] getModels() throws CoreException {
        return BundleLauncherHelper.getMergedBundles(this.fLaunchConfiguration, false);
    }

    public void run(IProgressMonitor monitor) throws CoreException {
        super.run(monitor);
        if (this.fExtensionErrors.size() > 0) {
            this.fExtensionErrors.clear();
        }
        this.validateExtensions();
    }

    private void validateExtensions() {
        try {
            if (this.fLaunchConfiguration.getAttribute("useProduct", false)) {
                String product = this.fLaunchConfiguration.getAttribute("product", null);
                if (product != null) {
                    this.validateExtension(product);
                    String application = this.getApplication(product);
                    if (application != null) {
                        this.validateExtension(application);
                    }
                }
            } else {
                String configType = this.fLaunchConfiguration.getType().getIdentifier();
                String attribute = configType.equals("org.eclipse.pde.ui.RuntimeWorkbench") ? "application" : "testApplication";
                String application = this.fLaunchConfiguration.getAttribute(attribute, TargetPlatform.getDefaultApplication());
                if (!"org.eclipse.pde.junit.runtime.coretestapplication".equals(application)) {
                    this.validateExtension(application);
                }
            }
        }
        catch (CoreException e) {
            PDELaunchingPlugin.log(e);
        }
    }

    private String getApplication(String product) {
        IPluginModelBase model;
        BundleDescription bundle;
        String bundleID = product;
        int index = product.lastIndexOf(46);
        if (index >= 0) {
            bundleID = product.substring(0, product.lastIndexOf(46));
        }
        if ((bundle = this.getState().getBundle(bundleID, null)) != null && (model = PluginRegistry.findModel((BundleDescription)bundle)) != null) {
            IPluginExtension[] extensions = model.getPluginBase().getExtensions();
            int i = 0;
            while (i < extensions.length) {
                IPluginElement prod;
                IPluginExtension ext = extensions[i];
                String point = ext.getPoint();
                if ("org.eclipse.core.runtime.products".equals(point) && product.equals(IdUtil.getFullId((IPluginExtension)ext)) && ext.getChildCount() == 1 && (prod = (IPluginElement)ext.getChildren()[0]).getName().equals("product")) {
                    IPluginAttribute attr = prod.getAttribute("application");
                    return attr != null ? attr.getValue() : null;
                }
                ++i;
            }
        }
        return null;
    }

    private void validateExtension(String id) throws CoreException {
        int index = id.lastIndexOf(46);
        if (index == -1) {
            return;
        }
        String bundleID = id.substring(0, index);
        BundleDescription bundle = this.getState().getBundle(bundleID, null);
        if (bundle == null) {
            String message = NLS.bind((String)PDEMessages.EclipsePluginValidationOperation_pluginMissing, (Object)bundleID);
            Status status = new Status(4, "org.eclipse.pde.launching", 1000, message, null);
            IStatusHandler statusHandler = DebugPlugin.getDefault().getStatusHandler((IStatus)status);
            Object extensionError = null;
            extensionError = statusHandler == null ? status.getMessage() : statusHandler.handleStatus((IStatus)status, (Object)id);
            this.fExtensionErrors.put(extensionError, EMPTY);
        }
    }

    public boolean hasErrors() {
        return super.hasErrors() || this.fExtensionErrors.size() >= 1;
    }

    public Map getInput() {
        Map map = super.getInput();
        map.putAll(this.fExtensionErrors);
        return map;
    }
}

