/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.core.di.internal.extensions;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.e4.core.di.AbstractObjectSupplier;
import org.eclipse.e4.core.di.IInjector;
import org.eclipse.e4.core.di.IObjectDescriptor;
import org.eclipse.e4.core.di.IRequestor;
import org.eclipse.e4.core.di.extensions.Preferences;
import org.eclipse.e4.core.di.internal.extensions.DIEActivator;
import org.osgi.framework.FrameworkUtil;

public class PreferencesObjectSupplier
extends AbstractObjectSupplier {
    private Map<String, List<IRequestor>> listenerCache = new HashMap<String, List<IRequestor>>();

    public Object get(IObjectDescriptor descriptor, IRequestor requestor) {
        if (descriptor == null) {
            return null;
        }
        String key = this.getKey(descriptor);
        String nodePath = this.getNodePath(descriptor, requestor.getRequestingObject());
        if (key == null || nodePath == null || key.length() == 0 || nodePath.length() == 0) {
            return IInjector.NOT_A_VALUE;
        }
        this.addListener(nodePath, requestor);
        String result = this.getPreferencesService().getString(nodePath, key, null, null);
        return result;
    }

    public Object[] get(IObjectDescriptor[] descriptors, IRequestor requestor) {
        Object[] result = new Object[descriptors.length];
        int i = 0;
        while (i < descriptors.length) {
            result[i] = this.get(descriptors[i], requestor);
            ++i;
        }
        return result;
    }

    private String getKey(IObjectDescriptor descriptor) {
        if (descriptor == null) {
            return null;
        }
        Object qualifier = descriptor.getQualifier(Preferences.class);
        return ((Preferences)qualifier).value();
    }

    private String getNodePath(IObjectDescriptor descriptor, Object requestingObject) {
        if (descriptor == null) {
            return null;
        }
        Object qualifier = descriptor.getQualifier(Preferences.class);
        String nodePath = ((Preferences)qualifier).nodePath();
        if (nodePath == null || nodePath.length() == 0) {
            if (requestingObject == null) {
                return null;
            }
            nodePath = FrameworkUtil.getBundle(requestingObject.getClass()).getSymbolicName();
        }
        return nodePath;
    }

    private IPreferencesService getPreferencesService() {
        return DIEActivator.getDefault().getPreferencesService();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addListener(String nodePath, final IRequestor requestor) {
        if (requestor == null || !requestor.shouldTrack()) {
            return;
        }
        Map<String, List<IRequestor>> map = this.listenerCache;
        synchronized (map) {
            if (this.listenerCache.containsKey(nodePath)) {
                for (IRequestor previousRequestor : this.listenerCache.get(nodePath)) {
                    if (!previousRequestor.equals(requestor)) continue;
                    return;
                }
            }
        }
        IEclipsePreferences node = new InstanceScope().getNode(nodePath);
        node.addPreferenceChangeListener(new IEclipsePreferences.IPreferenceChangeListener(){

            public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
                IInjector requestorInjector = requestor.getInjector();
                if (requestorInjector != null) {
                    requestorInjector.update(new IRequestor[]{requestor}, requestor.getPrimarySupplier());
                }
            }
        });
        Map<String, List<IRequestor>> map2 = this.listenerCache;
        synchronized (map2) {
            if (this.listenerCache.containsKey(nodePath)) {
                this.listenerCache.get(nodePath).add(requestor);
            } else {
                ArrayList<IRequestor> listeningRequestors = new ArrayList<IRequestor>();
                listeningRequestors.add(requestor);
                this.listenerCache.put(nodePath, listeningRequestors);
            }
        }
    }
}

