/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.junit.runtime;

import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Locale;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.internal.junit.runner.RemoteTestRunner;
import org.osgi.framework.Bundle;

public class RemotePluginTestRunner
extends RemoteTestRunner {
    private String fTestPluginName;
    private ClassLoader fLoaderClassLoader;

    public static void main(String[] args) {
        RemotePluginTestRunner testRunner = new RemotePluginTestRunner();
        testRunner.init(args);
        testRunner.run();
    }

    protected ClassLoader getTestClassLoader() {
        String pluginId = this.fTestPluginName;
        return this.getClassLoader(pluginId);
    }

    public ClassLoader getClassLoader(String pluginId) {
        Bundle bundle = Platform.getBundle((String)pluginId);
        if (bundle == null) {
            throw new IllegalArgumentException("No Classloader found for plug-in " + pluginId + " (plug-in was not resolved)");
        }
        return new BundleClassLoader(bundle);
    }

    public void init(String[] args) {
        this.readPluginArgs(args);
        this.defaultInit(args);
    }

    public void readPluginArgs(String[] args) {
        int i = 0;
        while (i < args.length) {
            if (this.isFlag(args, i, "-testpluginname")) {
                this.fTestPluginName = args[i + 1];
            }
            if (this.isFlag(args, i, "-loaderpluginname")) {
                this.fLoaderClassLoader = this.getClassLoader(args[i + 1]);
            }
            ++i;
        }
        if (this.fTestPluginName == null) {
            throw new IllegalArgumentException("Parameter -testpluginnname not specified.");
        }
        if (this.fLoaderClassLoader == null) {
            this.fLoaderClassLoader = ((Object)((Object)this)).getClass().getClassLoader();
        }
    }

    protected Class loadTestLoaderClass(String className) throws ClassNotFoundException {
        return this.fLoaderClassLoader.loadClass(className);
    }

    private boolean isFlag(String[] args, int i, String wantedFlag) {
        String lowerCase = args[i].toLowerCase(Locale.ENGLISH);
        return lowerCase.equals(wantedFlag) && i < args.length - 1;
    }

    class BundleClassLoader
    extends ClassLoader {
        private Bundle bundle;

        public BundleClassLoader(Bundle target) {
            this.bundle = target;
        }

        protected Class findClass(String name) throws ClassNotFoundException {
            return this.bundle.loadClass(name);
        }

        protected URL findResource(String name) {
            return this.bundle.getResource(name);
        }

        protected Enumeration findResources(String name) throws IOException {
            return this.bundle.getResources(name);
        }
    }
}

