/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.navigator;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Set;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ITreePathContentProvider;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.internal.navigator.CommonNavigatorMessages;
import org.eclipse.ui.internal.navigator.ContributorTrackingSet;
import org.eclipse.ui.internal.navigator.NavigatorContentService;
import org.eclipse.ui.internal.navigator.NavigatorPlugin;
import org.eclipse.ui.internal.navigator.extensions.NavigatorContentDescriptor;
import org.eclipse.ui.internal.navigator.extensions.NavigatorContentExtension;
import org.eclipse.ui.internal.navigator.extensions.SafeDelegateTreeContentProvider;
import org.eclipse.ui.navigator.INavigatorContentDescriptor;
import org.eclipse.ui.navigator.INavigatorViewerDescriptor;
import org.eclipse.ui.navigator.OverridePolicy;

public class NavigatorContentServiceContentProvider
implements ITreeContentProvider,
ITreePathContentProvider {
    private static final Object[] NO_CHILDREN = new Object[0];
    private final NavigatorContentService contentService;
    private boolean disposeContentService;
    private final boolean enforceHasChildren;
    private Viewer viewer;
    private static final boolean ELEMENTS = true;

    public NavigatorContentServiceContentProvider(String aViewerId) {
        this(new NavigatorContentService(aViewerId));
        this.disposeContentService = true;
    }

    public NavigatorContentServiceContentProvider(NavigatorContentService aContentService) {
        this.contentService = aContentService;
        INavigatorViewerDescriptor vDesc = this.contentService.getViewerDescriptor();
        this.enforceHasChildren = vDesc.getBooleanConfigProperty("org.eclipse.ui.navigator.enforceHasChildren");
    }

    public synchronized void inputChanged(Viewer aViewer, Object anOldInput, Object aNewInput) {
        this.viewer = aViewer;
        this.contentService.updateService(aViewer, anOldInput, aNewInput);
    }

    public synchronized Object[] getElements(Object anInputElement) {
        Set rootContentExtensions = this.contentService.findRootContentExtensions(anInputElement);
        return this.internalGetChildren(anInputElement, anInputElement, rootContentExtensions, true);
    }

    public synchronized Object[] getChildren(Object aParentElement) {
        Set enabledExtensions = this.contentService.findContentExtensionsByTriggerPoint(aParentElement);
        return this.internalGetChildren(aParentElement, aParentElement, enabledExtensions, false);
    }

    public synchronized Object[] getChildren(TreePath parentPath) {
        Object aParentElement = this.internalAsElement(parentPath);
        Set enabledExtensions = this.contentService.findContentExtensionsByTriggerPoint(aParentElement);
        return this.internalGetChildren(aParentElement, parentPath, enabledExtensions, false);
    }

    private Object[] internalGetChildren(Object aParentElement, Object aParentElementOrPath, Set enabledExtensions, boolean elements) {
        if (enabledExtensions.size() == 0) {
            return NO_CHILDREN;
        }
        ContributorTrackingSet localSet = new ContributorTrackingSet(this.contentService);
        LinkedHashSet finalSet = new LinkedHashSet();
        Object[] contributedChildren = null;
        Iterator itr = enabledExtensions.iterator();
        while (itr.hasNext()) {
            NavigatorContentExtension foundExtension = (NavigatorContentExtension)itr.next();
            try {
                if (this.isOverridingExtensionInSet(foundExtension.getDescriptor(), enabledExtensions)) continue;
                contributedChildren = elements ? foundExtension.internalGetContentProvider().getElements(aParentElementOrPath) : foundExtension.internalGetContentProvider().getChildren(aParentElementOrPath);
                NavigatorContentExtension[] overridingExtensions = foundExtension.getOverridingExtensionsForTriggerPoint(aParentElement);
                INavigatorContentDescriptor foundDescriptor = foundExtension.getDescriptor();
                localSet.setContributor(foundDescriptor, foundDescriptor);
                localSet.setContents(contributedChildren);
                if (overridingExtensions.length > 0) {
                    this.pipelineChildren(aParentElement, overridingExtensions, foundDescriptor, localSet, elements);
                }
                finalSet.addAll(localSet);
            }
            catch (Throwable e) {
                NavigatorPlugin.logError(0, NLS.bind((String)CommonNavigatorMessages.Exception_Invoking_Extension, (Object[])new Object[]{foundExtension.getDescriptor().getId(), aParentElement}), e);
            }
        }
        return finalSet.toArray();
    }

    private void pipelineChildren(Object aParent, NavigatorContentExtension[] theOverridingExtensions, INavigatorContentDescriptor firstClassDescriptor, ContributorTrackingSet pipelinedChildren, boolean elements) {
        int i = 0;
        while (i < theOverridingExtensions.length) {
            if (theOverridingExtensions[i].internalGetContentProvider().isPipelined()) {
                SafeDelegateTreeContentProvider pipelinedContentProvider = theOverridingExtensions[i].internalGetContentProvider();
                pipelinedChildren.setContributor(theOverridingExtensions[i].getDescriptor(), firstClassDescriptor);
                if (elements) {
                    pipelinedContentProvider.getPipelinedElements(aParent, pipelinedChildren);
                } else {
                    pipelinedContentProvider.getPipelinedChildren(aParent, pipelinedChildren);
                }
                NavigatorContentExtension[] overridingExtensions = theOverridingExtensions[i].getOverridingExtensionsForTriggerPoint(aParent);
                if (overridingExtensions.length > 0) {
                    this.pipelineChildren(aParent, overridingExtensions, firstClassDescriptor, pipelinedChildren, elements);
                }
            }
            ++i;
        }
    }

    private boolean isOverridingExtensionInSet(INavigatorContentDescriptor aDescriptor, Set theEnabledExtensions) {
        return aDescriptor.getSuppressedExtensionId() != null && aDescriptor.getOverridePolicy() == OverridePolicy.InvokeAlwaysRegardlessOfSuppressedExt && theEnabledExtensions.contains(this.contentService.getExtension(aDescriptor.getOverriddenDescriptor()));
    }

    private boolean isOverridingDescriptorInSet(INavigatorContentDescriptor aDescriptor, Set theEnabledDescriptors) {
        return aDescriptor.getSuppressedExtensionId() != null && aDescriptor.getOverridePolicy() == OverridePolicy.InvokeAlwaysRegardlessOfSuppressedExt && theEnabledDescriptors.contains(aDescriptor.getOverriddenDescriptor());
    }

    public synchronized Object getParent(Object anElement) {
        Set extensions = this.contentService.findContentExtensionsWithPossibleChild(anElement);
        Iterator itr = extensions.iterator();
        while (itr.hasNext()) {
            NavigatorContentExtension foundExtension = (NavigatorContentExtension)itr.next();
            try {
                if (this.isOverridingExtensionInSet(foundExtension.getDescriptor(), extensions)) continue;
                Object parent = foundExtension.internalGetContentProvider().getParent(anElement);
                NavigatorContentExtension[] overridingExtensions = foundExtension.getOverridingExtensionsForPossibleChild(anElement);
                if (overridingExtensions.length > 0) {
                    parent = this.pipelineParent(anElement, overridingExtensions, parent);
                }
                if (parent == null) continue;
                return parent;
            }
            catch (Throwable e) {
                NavigatorPlugin.logError(0, NLS.bind((String)CommonNavigatorMessages.Exception_Invoking_Extension, (Object[])new Object[]{foundExtension.getDescriptor().getId(), anElement}), e);
            }
        }
        return null;
    }

    public synchronized TreePath[] getParents(Object anElement) {
        ArrayList<TreePath> paths = new ArrayList<TreePath>();
        TreePathCompiler compiler = new TreePathCompiler(anElement);
        Set compilers = this.findPaths(compiler);
        Iterator iter = compilers.iterator();
        while (iter.hasNext()) {
            TreePathCompiler c = (TreePathCompiler)iter.next();
            paths.add(c.createParentPath());
        }
        return paths.toArray(new TreePath[paths.size()]);
    }

    private Object pipelineParent(Object anInputElement, NavigatorContentExtension[] theOverridingExtensions, Object theCurrentParent) {
        Object aSuggestedParent = null;
        int i = 0;
        while (i < theOverridingExtensions.length) {
            if (theOverridingExtensions[i].internalGetContentProvider().isPipelined()) {
                SafeDelegateTreeContentProvider pipelinedContentProvider = theOverridingExtensions[i].internalGetContentProvider();
                aSuggestedParent = pipelinedContentProvider.getPipelinedParent(anInputElement, aSuggestedParent);
                NavigatorContentExtension[] overridingExtensions = theOverridingExtensions[i].getOverridingExtensionsForTriggerPoint(anInputElement);
                if (overridingExtensions.length > 0) {
                    aSuggestedParent = this.pipelineParent(anInputElement, overridingExtensions, aSuggestedParent);
                }
            }
            ++i;
        }
        return aSuggestedParent != null ? aSuggestedParent : theCurrentParent;
    }

    public synchronized boolean hasChildren(Object anElementOrPath) {
        Object anElement = this.internalAsElement(anElementOrPath);
        Set enabledExtensions = this.contentService.findContentExtensionsByTriggerPoint(anElement);
        boolean suggestedHasChildren = false;
        Iterator itr = enabledExtensions.iterator();
        while (itr.hasNext()) {
            NavigatorContentExtension ext = (NavigatorContentExtension)itr.next();
            if (!ext.isLoaded() && !this.enforceHasChildren) {
                return true;
            }
            if (this.isOverridingExtensionInSet(ext.getDescriptor(), enabledExtensions)) continue;
            try {
                SafeDelegateTreeContentProvider cp = ext.internalGetContentProvider();
                suggestedHasChildren |= this.callNormalHasChildren(anElementOrPath, anElement, cp);
                NavigatorContentExtension[] overridingExtensions = ext.getOverridingExtensionsForTriggerPoint(anElement);
                if (overridingExtensions.length > 0) {
                    suggestedHasChildren = this.pipelineHasChildren(anElementOrPath, anElement, overridingExtensions, suggestedHasChildren);
                }
                if (!suggestedHasChildren) continue;
                return true;
            }
            catch (Throwable e) {
                NavigatorPlugin.logError(0, NLS.bind((String)CommonNavigatorMessages.Exception_Invoking_Extension, (Object[])new Object[]{ext.getDescriptor().getId(), anElementOrPath}), e);
            }
        }
        return suggestedHasChildren;
    }

    public synchronized boolean hasChildren(TreePath path) {
        return this.hasChildren((Object)path);
    }

    private boolean callNormalHasChildren(Object anElementOrPath, Object anElement, SafeDelegateTreeContentProvider cp) {
        if (cp.isTreePath() && anElementOrPath instanceof TreePath) {
            SafeDelegateTreeContentProvider tpcp = cp;
            return tpcp.hasChildren((TreePath)anElementOrPath);
        }
        return cp.hasChildren(anElement);
    }

    private boolean pipelineHasChildren(Object anElementOrPath, Object anElement, NavigatorContentExtension[] theOverridingExtensions, boolean suggestedHasChildren) {
        int i = 0;
        while (i < theOverridingExtensions.length) {
            SafeDelegateTreeContentProvider cp = theOverridingExtensions[i].internalGetContentProvider();
            if (cp.isPipelinedHasChildren()) {
                suggestedHasChildren = cp.hasPipelinedChildren(anElement, suggestedHasChildren);
                NavigatorContentExtension[] overridingExtensions = theOverridingExtensions[i].getOverridingExtensionsForTriggerPoint(anElement);
                if (overridingExtensions.length > 0) {
                    suggestedHasChildren = this.pipelineHasChildren(anElementOrPath, anElement, overridingExtensions, suggestedHasChildren);
                }
            } else {
                suggestedHasChildren |= this.callNormalHasChildren(anElementOrPath, anElement, cp);
            }
            ++i;
        }
        return suggestedHasChildren;
    }

    public synchronized void dispose() {
        if (this.disposeContentService) {
            this.contentService.dispose();
        }
    }

    private Object internalAsElement(Object parentElementOrPath) {
        if (parentElementOrPath instanceof TreePath) {
            TreePath tp = (TreePath)parentElementOrPath;
            if (tp.getSegmentCount() > 0) {
                return tp.getLastSegment();
            }
            return this.viewer.getInput();
        }
        return parentElementOrPath;
    }

    private Set findPaths(TreePathCompiler aPathCompiler) {
        Set parents = this.findParents(aPathCompiler.getFirstSegment());
        LinkedHashSet<TreePathCompiler> parentPaths = new LinkedHashSet<TreePathCompiler>();
        Set foundPaths = Collections.EMPTY_SET;
        if (parents.size() > 0) {
            Iterator parentIter = parents.iterator();
            while (parentIter.hasNext()) {
                Object parent = parentIter.next();
                TreePathCompiler c = new TreePathCompiler(aPathCompiler);
                try {
                    c.addParent(parent);
                    foundPaths = this.findPaths(c);
                }
                catch (CyclicPathException cpe) {
                    String msg = cpe.getMessage() != null ? cpe.getMessage() : cpe.toString();
                    NavigatorPlugin.logError(0, msg, cpe);
                }
                if (foundPaths.isEmpty()) {
                    parentPaths.add(c);
                    continue;
                }
                parentPaths.addAll(foundPaths);
            }
        }
        return parentPaths;
    }

    private Set findParents(Object anElement) {
        Set descriptors = this.contentService.findDescriptorsWithPossibleChild(anElement, false);
        LinkedHashSet<Object> parents = new LinkedHashSet<Object>();
        Object parent = null;
        Iterator itr = descriptors.iterator();
        while (itr.hasNext()) {
            NavigatorContentDescriptor foundDescriptor = (NavigatorContentDescriptor)itr.next();
            NavigatorContentExtension foundExtension = this.contentService.getExtension(foundDescriptor);
            try {
                if (this.isOverridingDescriptorInSet(foundExtension.getDescriptor(), descriptors)) continue;
                if (foundExtension.internalGetContentProvider().isTreePath()) {
                    TreePath[] parentTreePaths = foundExtension.internalGetContentProvider().getParents(anElement);
                    int i = 0;
                    while (i < parentTreePaths.length) {
                        parent = parentTreePaths[i].getLastSegment();
                        if ((parent = this.findParent(foundExtension, anElement, parent)) != null) {
                            parents.add(parent);
                        }
                        ++i;
                    }
                    continue;
                }
                parent = foundExtension.internalGetContentProvider().getParent(anElement);
                if ((parent = this.findParent(foundExtension, anElement, parent)) == null) continue;
                parents.add(parent);
            }
            catch (Throwable e) {
                NavigatorPlugin.logError(0, NLS.bind((String)CommonNavigatorMessages.Exception_Invoking_Extension, (Object[])new Object[]{foundExtension.getDescriptor().getId(), anElement}), e);
            }
        }
        return parents;
    }

    private Object findParent(NavigatorContentExtension anExtension, Object anElement, Object aSuggestedParent) {
        Object lastValidParent = aSuggestedParent;
        Object suggestedOverriddenParent = null;
        NavigatorContentExtension[] overridingExtensions = anExtension.getOverridingExtensionsForPossibleChild(anElement);
        int i = 0;
        while (i < overridingExtensions.length) {
            if (overridingExtensions[i].internalGetContentProvider().isPipelined()) {
                SafeDelegateTreeContentProvider piplineContentProvider = overridingExtensions[i].internalGetContentProvider();
                suggestedOverriddenParent = piplineContentProvider.getPipelinedParent(anElement, lastValidParent);
                if (suggestedOverriddenParent != null) {
                    lastValidParent = suggestedOverriddenParent;
                }
                lastValidParent = this.findParent(overridingExtensions[i], anElement, lastValidParent);
            }
            ++i;
        }
        return lastValidParent;
    }

    class CyclicPathException
    extends Exception {
        private static final long serialVersionUID = 2111962579612444989L;

        protected CyclicPathException(TreePathCompiler compiler, Object invalidSegment, boolean asChild) {
            super("Cannot add " + invalidSegment + " to the list of segments in " + compiler + (asChild ? " as a child." : " as a parent."));
        }
    }

    class TreePathCompiler {
        private final LinkedList segments = new LinkedList();

        protected TreePathCompiler(Object segment) {
            this.segments.add(segment);
        }

        protected TreePathCompiler(TreePathCompiler aCompiler) {
            this.segments.addAll(aCompiler.segments);
        }

        protected TreePathCompiler(TreePath aPath) {
            int i = 0;
            while (i < aPath.getSegmentCount()) {
                this.segments.addLast(aPath.getSegment(i));
                ++i;
            }
        }

        protected void addParent(Object segment) throws CyclicPathException {
            if (this.segments.contains(segment)) {
                throw new CyclicPathException(this, segment, false);
            }
            this.segments.addFirst(segment);
        }

        protected void addChild(Object segment) throws CyclicPathException {
            if (this.segments.contains(segment)) {
                throw new CyclicPathException(this, segment, false);
            }
            this.segments.addLast(segment);
        }

        public TreePath createPath() {
            return new TreePath(this.segments.toArray());
        }

        public TreePath createParentPath() {
            LinkedList parentSegments = new LinkedList(this.segments);
            parentSegments.removeLast();
            return new TreePath(parentSegments.toArray());
        }

        public Object getLastSegment() {
            return this.segments.getLast();
        }

        public Object getFirstSegment() {
            return this.segments.getFirst();
        }

        public String toString() {
            StringBuffer buffer = new StringBuffer();
            Iterator iter = this.segments.iterator();
            while (iter.hasNext()) {
                Object segment = iter.next();
                buffer.append(segment).append("::");
            }
            return buffer.toString();
        }
    }
}

