/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.e4.compatibility;

import javax.inject.Inject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.di.annotations.PostConstruct;
import org.eclipse.e4.core.di.annotations.PreDestroy;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.core.services.log.Logger;
import org.eclipse.e4.ui.model.application.MPart;
import org.eclipse.e4.workbench.ui.UIEvents;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.ISaveablePart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPart2;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.internal.PartSite;
import org.eclipse.ui.internal.WorkbenchPage;
import org.eclipse.ui.internal.WorkbenchPartReference;
import org.eclipse.ui.internal.util.Util;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public abstract class CompatibilityPart {
    public static final String COMPATIBILITY_EDITOR_URI = "platform:/plugin/org.eclipse.ui.workbench/org.eclipse.ui.internal.e4.compatibility.CompatibilityEditor";
    public static final String COMPATIBILITY_VIEW_URI = "platform:/plugin/org.eclipse.ui.workbench/org.eclipse.ui.internal.e4.compatibility.CompatibilityView";
    @Inject
    Composite composite;
    @Inject
    Logger logger;
    IWorkbenchPart wrapped;
    MPart part;
    @Inject
    private IEventBroker eventBroker;
    private boolean beingDisposed = false;
    private EventHandler objectUnsetHandler = new EventHandler(){

        public void handleEvent(Event event) {
            if (event.getProperty("ChangedElement") == CompatibilityPart.this.part && event.getProperty("NewValue") == null) {
                PartSite site;
                WorkbenchPartReference reference = CompatibilityPart.this.getReference();
                ((WorkbenchPage)reference.getPage()).firePartClosed(CompatibilityPart.this);
                reference.invalidate();
                if (CompatibilityPart.this.wrapped != null) {
                    CompatibilityPart.this.wrapped.dispose();
                }
                if ((site = reference.getSite()) != null) {
                    site.dispose();
                }
            }
        }
    };

    CompatibilityPart(MPart part) {
        this.part = part;
    }

    public abstract WorkbenchPartReference getReference();

    protected void createPartControl(IWorkbenchPart legacyPart, Composite parent) {
        try {
            legacyPart.createPartControl(parent);
        }
        catch (RuntimeException e) {
            this.logger.error((Throwable)e);
        }
    }

    public void delegateSetFocus() {
        this.wrapped.setFocus();
    }

    private String computeLabel() {
        if (this.wrapped instanceof IWorkbenchPart2) {
            String label = ((IWorkbenchPart2)this.wrapped).getPartName();
            return Util.safeString(label);
        }
        IWorkbenchPartSite site = this.wrapped.getSite();
        if (site != null) {
            return Util.safeString(site.getRegisteredName());
        }
        return Util.safeString(this.wrapped.getTitle());
    }

    public boolean isBeingDisposed() {
        return this.beingDisposed;
    }

    @PostConstruct
    public void create() throws PartInitException {
        this.composite.addListener(12, new Listener(){

            public void handleEvent(org.eclipse.swt.widgets.Event event) {
                CompatibilityPart.this.beingDisposed = true;
            }
        });
        this.eventBroker.subscribe(UIEvents.buildTopic((String)"org/eclipse/e4/ui/model/application/Contribution", (String)"object"), this.objectUnsetHandler);
        WorkbenchPartReference reference = this.getReference();
        this.wrapped = reference.createPart();
        reference.initialize(this.wrapped);
        this.createPartControl(this.wrapped, this.composite);
        this.part.setLabel(this.computeLabel());
        this.part.setTooltip(this.wrapped.getTitleToolTip());
        this.wrapped.addPropertyListener(new IPropertyListener(){

            public void propertyChanged(Object source, int propId) {
                switch (propId) {
                    case 1: {
                        CompatibilityPart.this.part.setLabel(CompatibilityPart.this.computeLabel());
                        break;
                    }
                    case 257: {
                        if (!(CompatibilityPart.this.wrapped instanceof ISaveablePart)) break;
                        CompatibilityPart.this.part.setDirty(((ISaveablePart)((Object)CompatibilityPart.this.wrapped)).isDirty());
                    }
                }
            }
        });
        ((WorkbenchPage)reference.getPage()).firePartOpened(this);
    }

    @PreDestroy
    void destroy() {
        this.eventBroker.unsubscribe(this.objectUnsetHandler);
    }

    void doSave(@Optional IProgressMonitor monitor) {
        monitor = SubMonitor.convert((IProgressMonitor)monitor);
        if (this.wrapped instanceof ISaveablePart) {
            ((ISaveablePart)((Object)this.wrapped)).doSave(monitor);
        }
    }

    public IWorkbenchPart getPart() {
        return this.wrapped;
    }

    public MPart getModel() {
        return this.part;
    }
}

