/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.services;

import java.util.LinkedList;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.ui.ISourceProvider;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.services.EvaluationReference;
import org.eclipse.ui.internal.services.LegacyEvalContext;
import org.eclipse.ui.services.IEvaluationReference;
import org.eclipse.ui.services.IEvaluationService;

public final class EvaluationService
implements IEvaluationService {
    private LegacyEvalContext legacyContext;
    private int notifying = 0;
    private ListenerList serviceListeners = new ListenerList(1);
    private IEclipseContext context;
    LinkedList<EvaluationReference> refs = new LinkedList();

    public EvaluationService(IEclipseContext c) {
        this.context = c;
        this.legacyContext = new LegacyEvalContext(c);
    }

    public void addSourceProvider(ISourceProvider provider) {
    }

    public void removeSourceProvider(ISourceProvider provider) {
    }

    public void dispose() {
        WorkbenchPlugin.log("LegacyEvalContext.dispose: should it do something?");
    }

    public void addServiceListener(IPropertyChangeListener listener) {
        this.serviceListeners.add((Object)listener);
    }

    public void removeServiceListener(IPropertyChangeListener listener) {
        this.serviceListeners.remove((Object)listener);
    }

    public IEvaluationReference addEvaluationListener(Expression expression, IPropertyChangeListener listener, String property) {
        EvaluationReference ref = new EvaluationReference(this.context, expression, listener, property);
        this.refs.add(ref);
        return ref;
    }

    public void addEvaluationReference(IEvaluationReference ref) {
        EvaluationReference eref = (EvaluationReference)ref;
        this.refs.add(eref);
        eref.participating = true;
        eref.evaluate();
    }

    public void removeEvaluationListener(IEvaluationReference ref) {
        this.refs.remove(ref);
        EvaluationReference eref = (EvaluationReference)ref;
        eref.participating = false;
        eref.evaluate();
    }

    public IEvaluationContext getCurrentState() {
        return this.legacyContext;
    }

    public void requestEvaluation(String propertyName) {
        String[] sourceNames = new String[]{propertyName};
        this.startSourceChange(sourceNames);
        this.endSourceChange(sourceNames);
    }

    private void startSourceChange(String[] sourceNames) {
        ++this.notifying;
        if (this.notifying == 1) {
            this.fireServiceChange("org.eclipse.ui.services.notifying", Boolean.FALSE, Boolean.TRUE);
        }
    }

    private void endSourceChange(String[] sourceNames) {
        if (this.notifying == 1) {
            this.fireServiceChange("org.eclipse.ui.services.notifying", Boolean.TRUE, Boolean.FALSE);
        }
        --this.notifying;
    }

    private void fireServiceChange(final String property, final Object oldValue, final Object newValue) {
        Object[] listeners = this.serviceListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            final IPropertyChangeListener listener = (IPropertyChangeListener)listeners[i];
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                public void handleException(Throwable exception) {
                    WorkbenchPlugin.log(exception);
                }

                public void run() throws Exception {
                    listener.propertyChange(new PropertyChangeEvent((Object)EvaluationService.this, property, oldValue, newValue));
                }
            });
            ++i;
        }
    }
}

