/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.model.application;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum ItemType implements Enumerator
{
    PUSH(0, "Push", "Push"),
    CHECK(1, "Check", "Check"),
    RADIO(2, "Radio", "Radio"),
    SEPARATOR(3, "Separator", "Separator");

    public static final int PUSH_VALUE = 0;
    public static final int CHECK_VALUE = 1;
    public static final int RADIO_VALUE = 2;
    public static final int SEPARATOR_VALUE = 3;
    private static final ItemType[] VALUES_ARRAY;
    public static final List<ItemType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new ItemType[]{PUSH, CHECK, RADIO, SEPARATOR};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static ItemType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ItemType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ItemType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ItemType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ItemType get(int value) {
        switch (value) {
            case 0: {
                return PUSH;
            }
            case 1: {
                return CHECK;
            }
            case 2: {
                return RADIO;
            }
            case 3: {
                return SEPARATOR;
            }
        }
        return null;
    }

    private ItemType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

