/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.core.internal.di;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;
import org.eclipse.e4.core.di.AbstractObjectSupplier;
import org.eclipse.e4.core.di.IInjector;
import org.eclipse.e4.core.di.IObjectDescriptor;
import org.eclipse.e4.core.di.ObjectDescriptorFactory;
import org.eclipse.e4.core.internal.di.InjectionProperties;
import org.eclipse.e4.core.internal.di.Requestor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConstructorRequestor
extends Requestor {
    private final Constructor<?> constructor;

    public ConstructorRequestor(Constructor<?> constructor, IInjector injector, AbstractObjectSupplier primarySupplier) {
        super(injector, primarySupplier, null, false, false, false);
        this.constructor = constructor;
    }

    @Override
    public Object execute() throws InvocationTargetException, InstantiationException {
        return this.callConstructor(this.constructor, this.actualArgs);
    }

    @Override
    public IObjectDescriptor[] getDependentObjects() {
        Type[] parameterTypes = this.constructor.getGenericParameterTypes();
        InjectionProperties[] properties = this.annotationSupport.getInjectParamsProperties(this.constructor);
        IObjectDescriptor[] descriptors = new IObjectDescriptor[properties.length];
        int i = 0;
        while (i < properties.length) {
            descriptors[i] = ObjectDescriptorFactory.make(parameterTypes[i], properties[i].getQualifiers());
            ++i;
        }
        return descriptors;
    }

    private Object callConstructor(Constructor<?> constructor, Object[] args) throws InvocationTargetException, InstantiationException {
        Object result = null;
        boolean wasAccessible = true;
        if (!constructor.isAccessible()) {
            constructor.setAccessible(true);
            wasAccessible = false;
        }
        try {
            try {
                result = constructor.newInstance(args);
            }
            catch (IllegalArgumentException e) {
                this.logError(constructor, (Exception)e);
                if (!wasAccessible) {
                    constructor.setAccessible(false);
                }
                return null;
            }
            catch (IllegalAccessException e) {
                this.logError(constructor, (Exception)e);
                if (!wasAccessible) {
                    constructor.setAccessible(false);
                }
                return null;
            }
        }
        finally {
            if (!wasAccessible) {
                constructor.setAccessible(false);
            }
        }
        return result;
    }
}

