/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.core.contexts;

import java.util.WeakHashMap;
import org.eclipse.e4.core.contexts.ContextChangeEvent;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.internal.contexts.EclipseContext;
import org.eclipse.e4.core.internal.contexts.IEclipseContextStrategy;
import org.eclipse.e4.core.internal.contexts.osgi.OSGiContextStrategy;
import org.osgi.framework.BundleContext;

public final class EclipseContextFactory {
    private static WeakHashMap<BundleContext, IEclipseContext> serviceContexts = new WeakHashMap();

    public static IEclipseContext create() {
        return EclipseContextFactory.create(null, null);
    }

    public static IEclipseContext create(IEclipseContext parent, IEclipseContextStrategy strategy) {
        EclipseContext eclipseContext = new EclipseContext(parent, strategy);
        eclipseContext.set(IEclipseContext.class.getName(), eclipseContext);
        return eclipseContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IEclipseContext getServiceContext(BundleContext bundleContext) {
        WeakHashMap<BundleContext, IEclipseContext> weakHashMap = serviceContexts;
        synchronized (weakHashMap) {
            IEclipseContext result = serviceContexts.get(bundleContext);
            if (result == null) {
                result = EclipseContextFactory.create(null, new OSGiContextStrategy(bundleContext));
                result.set("debugString", "OSGi context for bundle: " + bundleContext.getBundle().getSymbolicName());
                serviceContexts.put(bundleContext, result);
            }
            return result;
        }
    }

    public static ContextChangeEvent createContextEvent(IEclipseContext context, int eventType, Object[] args, String name, Object oldValue) {
        return new ContextChangeEvent(context, eventType, args, name, oldValue);
    }
}

