/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ui.text.java;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jdt.core.CompletionContext;
import org.eclipse.jdt.core.CompletionProposal;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.internal.corext.template.java.SignatureUtil;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.corext.util.Strings;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.viewsupport.BasicElementLabels;
import org.eclipse.jdt.internal.ui.viewsupport.JavaElementImageProvider;
import org.eclipse.jdt.ui.JavaElementImageDescriptor;
import org.eclipse.jdt.ui.JavaElementLabels;
import org.eclipse.jdt.ui.text.java.JavaTextMessages;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.StyledString;

public class CompletionProposalLabelProvider {
    private static final String QUALIFIER_SEPARATOR = JavaElementLabels.CONCAT_STRING;
    private static final String RETURN_TYPE_SEPARATOR = JavaElementLabels.DECL_STRING;
    private static final String VAR_TYPE_SEPARATOR = JavaElementLabels.DECL_STRING;
    private CompletionContext fContext;

    public String createParameterList(CompletionProposal proposal) {
        int kind = proposal.getKind();
        switch (kind) {
            case 6: 
            case 26: {
                return this.appendUnboundedParameterList(new StyledString(), proposal).getString();
            }
            case 9: {
                return this.appendTypeParameterList(new StyledString(), proposal).getString();
            }
            case 1: 
            case 27: {
                return this.appendUnboundedParameterList(new StyledString(), proposal).getString();
            }
        }
        Assert.isLegal((boolean)false);
        return null;
    }

    private StyledString appendUnboundedParameterList(StyledString buffer, CompletionProposal methodProposal) {
        char[] signature = SignatureUtil.fix83600(methodProposal.getSignature());
        char[][] parameterNames = methodProposal.findParameterNames(null);
        char[][] parameterTypes = Signature.getParameterTypes((char[])signature);
        int i = 0;
        while (i < parameterTypes.length) {
            parameterTypes[i] = this.createTypeDisplayName(SignatureUtil.getLowerBound(parameterTypes[i]));
            ++i;
        }
        if (Flags.isVarargs((int)methodProposal.getFlags())) {
            int index = parameterTypes.length - 1;
            parameterTypes[index] = this.convertToVararg(parameterTypes[index]);
        }
        return this.appendParameterSignature(buffer, parameterTypes, parameterNames);
    }

    private StyledString appendTypeParameterList(StyledString buffer, CompletionProposal typeProposal) {
        char[] signature = SignatureUtil.fix83600(typeProposal.getSignature());
        char[][] typeParameters = Signature.getTypeArguments((char[])signature);
        int i = 0;
        while (i < typeParameters.length) {
            char[] param = typeParameters[i];
            typeParameters[i] = Signature.toCharArray((char[])param);
            ++i;
        }
        return this.appendParameterSignature(buffer, typeParameters, null);
    }

    private char[] convertToVararg(char[] typeName) {
        if (typeName == null) {
            return typeName;
        }
        int len = typeName.length;
        if (len < 2) {
            return typeName;
        }
        if (typeName[len - 1] != ']') {
            return typeName;
        }
        if (typeName[len - 2] != '[') {
            return typeName;
        }
        char[] vararg = new char[len + 1];
        System.arraycopy(typeName, 0, vararg, 0, len - 2);
        vararg[len - 2] = 46;
        vararg[len - 1] = 46;
        vararg[len] = 46;
        return vararg;
    }

    private char[] createTypeDisplayName(char[] typeSignature) throws IllegalArgumentException {
        char[] displayName = Signature.getSimpleName((char[])Signature.toCharArray((char[])typeSignature));
        boolean useShortGenerics = false;
        if (useShortGenerics) {
            int pos;
            StringBuffer buf = new StringBuffer();
            buf.append(displayName);
            do {
                if ((pos = buf.indexOf("? extends ")) >= 0) {
                    buf.replace(pos, pos + 10, "+");
                    continue;
                }
                pos = buf.indexOf("? super ");
                if (pos < 0) continue;
                buf.replace(pos, pos + 8, "-");
            } while (pos >= 0);
            return buf.toString().toCharArray();
        }
        return displayName;
    }

    private final StyledString appendParameterSignature(StyledString buffer, char[][] parameterTypes, char[][] parameterNames) {
        if (parameterTypes != null) {
            int i = 0;
            while (i < parameterTypes.length) {
                if (i > 0) {
                    buffer.append(',');
                    buffer.append(' ');
                }
                buffer.append(parameterTypes[i]);
                if (parameterNames != null && parameterNames[i] != null) {
                    buffer.append(' ');
                    buffer.append(parameterNames[i]);
                }
                ++i;
            }
        }
        return buffer;
    }

    StyledString createMethodProposalLabel(CompletionProposal methodProposal) {
        String qualifier;
        StyledString nameBuffer = new StyledString();
        nameBuffer.append(methodProposal.getName());
        nameBuffer.append('(');
        this.appendUnboundedParameterList(nameBuffer, methodProposal);
        nameBuffer.append(')');
        if (!methodProposal.isConstructor()) {
            char[] returnType = this.createTypeDisplayName(SignatureUtil.getUpperBound(Signature.getReturnType((char[])SignatureUtil.fix83600(methodProposal.getSignature()))));
            nameBuffer.append(RETURN_TYPE_SEPARATOR);
            nameBuffer.append(returnType);
        }
        nameBuffer.append(QUALIFIER_SEPARATOR, StyledString.QUALIFIER_STYLER);
        String declaringType = this.extractDeclaringTypeFQN(methodProposal);
        if (methodProposal.getRequiredProposals() != null && (qualifier = Signature.getQualifier((String)declaringType)).length() > 0) {
            nameBuffer.append(qualifier, StyledString.QUALIFIER_STYLER);
            nameBuffer.append('.', StyledString.QUALIFIER_STYLER);
        }
        declaringType = Signature.getSimpleName((String)declaringType);
        nameBuffer.append(declaringType, StyledString.QUALIFIER_STYLER);
        return Strings.markLTR(nameBuffer, "<>(),?{} ");
    }

    StyledString createJavadocMethodProposalLabel(CompletionProposal methodProposal) {
        StyledString nameBuffer = new StyledString();
        nameBuffer.append(methodProposal.getCompletion());
        nameBuffer.append(QUALIFIER_SEPARATOR, StyledString.QUALIFIER_STYLER);
        String declaringType = this.extractDeclaringTypeFQN(methodProposal);
        declaringType = Signature.getSimpleName((String)declaringType);
        nameBuffer.append(declaringType, StyledString.QUALIFIER_STYLER);
        return Strings.markLTR(nameBuffer, "<>(),?{} ");
    }

    StyledString createOverrideMethodProposalLabel(CompletionProposal methodProposal) {
        StyledString nameBuffer = new StyledString();
        nameBuffer.append(methodProposal.getName());
        nameBuffer.append('(');
        this.appendUnboundedParameterList(nameBuffer, methodProposal);
        nameBuffer.append(')');
        nameBuffer.append(RETURN_TYPE_SEPARATOR);
        char[] returnType = this.createTypeDisplayName(SignatureUtil.getUpperBound(Signature.getReturnType((char[])SignatureUtil.fix83600(methodProposal.getSignature()))));
        nameBuffer.append(returnType);
        nameBuffer.append(QUALIFIER_SEPARATOR, StyledString.QUALIFIER_STYLER);
        String declaringType = this.extractDeclaringTypeFQN(methodProposal);
        declaringType = Signature.getSimpleName((String)declaringType);
        nameBuffer.append(Messages.format(JavaTextMessages.ResultCollector_overridingmethod, BasicElementLabels.getJavaElementName(declaringType)), StyledString.QUALIFIER_STYLER);
        return nameBuffer;
    }

    private String extractDeclaringTypeFQN(CompletionProposal methodProposal) {
        char[] declaringTypeSignature = methodProposal.getDeclarationSignature();
        if (declaringTypeSignature == null) {
            return "java.lang.Object";
        }
        return SignatureUtil.stripSignatureToFQN(String.valueOf(declaringTypeSignature));
    }

    StyledString createTypeProposalLabel(CompletionProposal typeProposal) {
        char[] signature = this.fContext != null && this.fContext.isInJavadoc() ? Signature.getTypeErasure((char[])typeProposal.getSignature()) : typeProposal.getSignature();
        char[] fullName = Signature.toCharArray((char[])signature);
        return this.createTypeProposalLabel(fullName);
    }

    StyledString createJavadocTypeProposalLabel(CompletionProposal typeProposal) {
        char[] fullName = Signature.toCharArray((char[])typeProposal.getSignature());
        return this.createJavadocTypeProposalLabel(fullName);
    }

    StyledString createJavadocSimpleProposalLabel(CompletionProposal proposal) {
        return this.createSimpleLabel(proposal);
    }

    StyledString createTypeProposalLabel(char[] fullName) {
        int qIndex = this.findSimpleNameStart(fullName);
        StyledString buf = new StyledString();
        buf.append(new String(fullName, qIndex, fullName.length - qIndex));
        if (qIndex > 0) {
            buf.append(JavaElementLabels.CONCAT_STRING, StyledString.QUALIFIER_STYLER);
            buf.append(new String(fullName, 0, qIndex - 1), StyledString.QUALIFIER_STYLER);
        }
        return Strings.markLTR(buf, "<>(),?{} ");
    }

    StyledString createJavadocTypeProposalLabel(char[] fullName) {
        int qIndex = this.findSimpleNameStart(fullName);
        StyledString buf = new StyledString("{@link ");
        buf.append(new String(fullName, qIndex, fullName.length - qIndex));
        buf.append('}');
        if (qIndex > 0) {
            buf.append(JavaElementLabels.CONCAT_STRING, StyledString.QUALIFIER_STYLER);
            buf.append(new String(fullName, 0, qIndex - 1), StyledString.QUALIFIER_STYLER);
        }
        return Strings.markLTR(buf, "<>(),?{} ");
    }

    private int findSimpleNameStart(char[] array) {
        int lastDot = 0;
        int i = 0;
        int len = array.length;
        while (i < len) {
            char ch = array[i];
            if (ch == '<') {
                return lastDot;
            }
            if (ch == '.') {
                lastDot = i + 1;
            }
            ++i;
        }
        return lastDot;
    }

    StyledString createSimpleLabelWithType(CompletionProposal proposal) {
        StyledString buf = new StyledString();
        buf.append(proposal.getCompletion());
        char[] typeName = Signature.getSignatureSimpleName((char[])proposal.getSignature());
        if (typeName.length > 0) {
            buf.append(VAR_TYPE_SEPARATOR);
            buf.append(typeName);
        }
        return Strings.markLTR(buf, "<>(),?{} ");
    }

    private boolean isThisPrefix(char[] string) {
        if (string == null || string.length < 5) {
            return false;
        }
        return string[0] == 't' && string[1] == 'h' && string[2] == 'i' && string[3] == 's' && string[4] == '.';
    }

    StyledString createLabelWithTypeAndDeclaration(CompletionProposal proposal) {
        char[] declaration;
        char[] name = proposal.getCompletion();
        if (!this.isThisPrefix(name)) {
            name = proposal.getName();
        }
        StyledString buf = new StyledString();
        buf.append(name);
        char[] typeName = Signature.getSignatureSimpleName((char[])proposal.getSignature());
        if (typeName.length > 0) {
            buf.append(VAR_TYPE_SEPARATOR);
            buf.append(typeName);
        }
        if ((declaration = proposal.getDeclarationSignature()) != null && (declaration = Signature.getSignatureSimpleName((char[])declaration)).length > 0) {
            buf.append(QUALIFIER_SEPARATOR, StyledString.QUALIFIER_STYLER);
            buf.append(declaration, StyledString.QUALIFIER_STYLER);
        }
        return Strings.markLTR(buf, "<>(),?{} ");
    }

    StyledString createPackageProposalLabel(CompletionProposal proposal) {
        Assert.isTrue((proposal.getKind() == 8 ? 1 : 0) != 0);
        return Strings.markLTR(new StyledString(String.valueOf(proposal.getDeclarationSignature())), "<>(),?{} ");
    }

    StyledString createSimpleLabel(CompletionProposal proposal) {
        return Strings.markLTR(new StyledString(String.valueOf(proposal.getCompletion())), "<>(),?{} ");
    }

    StyledString createAnonymousTypeLabel(CompletionProposal proposal) {
        char[] signatureQualifier;
        char[] declaringTypeSignature = proposal.getDeclarationSignature();
        declaringTypeSignature = Signature.getTypeErasure((char[])declaringTypeSignature);
        StyledString buffer = new StyledString();
        buffer.append(Signature.getSignatureSimpleName((char[])declaringTypeSignature));
        buffer.append('(');
        this.appendUnboundedParameterList(buffer, proposal);
        buffer.append(')');
        buffer.append("  ");
        buffer.append(JavaTextMessages.ResultCollector_anonymous_type);
        if (proposal.getRequiredProposals() != null && (signatureQualifier = Signature.getSignatureQualifier((char[])declaringTypeSignature)).length > 0) {
            buffer.append(JavaElementLabels.CONCAT_STRING, StyledString.QUALIFIER_STYLER);
            buffer.append(signatureQualifier, StyledString.QUALIFIER_STYLER);
        }
        return Strings.markLTR(buffer, "<>(),?{} ");
    }

    public String createLabel(CompletionProposal proposal) {
        return this.createStyledLabel(proposal).getString();
    }

    public StyledString createStyledLabel(CompletionProposal proposal) {
        switch (proposal.getKind()) {
            case 6: 
            case 11: 
            case 12: 
            case 24: 
            case 26: {
                if (this.fContext != null && this.fContext.isInJavadoc()) {
                    return this.createJavadocMethodProposalLabel(proposal);
                }
                return this.createMethodProposalLabel(proposal);
            }
            case 7: {
                return this.createOverrideMethodProposalLabel(proposal);
            }
            case 1: 
            case 27: {
                return this.createAnonymousTypeLabel(proposal);
            }
            case 9: {
                return this.createTypeProposalLabel(proposal);
            }
            case 16: {
                return this.createJavadocTypeProposalLabel(proposal);
            }
            case 14: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                return this.createJavadocSimpleProposalLabel(proposal);
            }
            case 15: {
                return this.createJavadocMethodProposalLabel(proposal);
            }
            case 8: {
                return this.createPackageProposalLabel(proposal);
            }
            case 2: 
            case 13: 
            case 25: {
                return this.createLabelWithTypeAndDeclaration(proposal);
            }
            case 5: 
            case 10: {
                return this.createSimpleLabelWithType(proposal);
            }
            case 3: 
            case 4: {
                return this.createSimpleLabel(proposal);
            }
        }
        Assert.isTrue((boolean)false);
        return null;
    }

    public ImageDescriptor createImageDescriptor(CompletionProposal proposal) {
        ImageDescriptor descriptor;
        int flags = proposal.getFlags();
        block0 : switch (proposal.getKind()) {
            case 1: 
            case 6: 
            case 7: 
            case 11: 
            case 12: 
            case 13: 
            case 24: 
            case 26: 
            case 27: {
                descriptor = JavaElementImageProvider.getMethodImageDescriptor(false, flags);
                break;
            }
            case 9: {
                switch (Signature.getTypeSignatureKind((char[])proposal.getSignature())) {
                    case 1: {
                        descriptor = JavaElementImageProvider.getTypeImageDescriptor(false, false, flags, false);
                        break block0;
                    }
                    case 3: {
                        descriptor = JavaPluginImages.DESC_OBJS_TYPEVARIABLE;
                        break block0;
                    }
                }
                descriptor = null;
                break;
            }
            case 2: 
            case 25: {
                descriptor = JavaElementImageProvider.getFieldImageDescriptor(false, flags);
                break;
            }
            case 5: 
            case 10: {
                descriptor = JavaPluginImages.DESC_OBJS_LOCAL_VARIABLE;
                break;
            }
            case 8: {
                descriptor = JavaPluginImages.DESC_OBJS_PACKAGE;
                break;
            }
            case 3: 
            case 4: {
                descriptor = null;
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                descriptor = JavaPluginImages.DESC_OBJS_JAVADOCTAG;
                break;
            }
            default: {
                descriptor = null;
                Assert.isTrue((boolean)false);
            }
        }
        if (descriptor == null) {
            return null;
        }
        return this.decorateImageDescriptor(descriptor, proposal);
    }

    ImageDescriptor createMethodImageDescriptor(CompletionProposal proposal) {
        int flags = proposal.getFlags();
        return this.decorateImageDescriptor(JavaElementImageProvider.getMethodImageDescriptor(false, flags), proposal);
    }

    ImageDescriptor createTypeImageDescriptor(CompletionProposal proposal) {
        int flags = proposal.getFlags();
        boolean isInterfaceOrAnnotation = Flags.isInterface((int)flags) || Flags.isAnnotation((int)flags);
        return this.decorateImageDescriptor(JavaElementImageProvider.getTypeImageDescriptor(true, isInterfaceOrAnnotation, flags, false), proposal);
    }

    ImageDescriptor createFieldImageDescriptor(CompletionProposal proposal) {
        int flags = proposal.getFlags();
        return this.decorateImageDescriptor(JavaElementImageProvider.getFieldImageDescriptor(false, flags), proposal);
    }

    ImageDescriptor createLocalImageDescriptor(CompletionProposal proposal) {
        return this.decorateImageDescriptor(JavaPluginImages.DESC_OBJS_LOCAL_VARIABLE, proposal);
    }

    ImageDescriptor createPackageImageDescriptor(CompletionProposal proposal) {
        return this.decorateImageDescriptor(JavaPluginImages.DESC_OBJS_PACKAGE, proposal);
    }

    private ImageDescriptor decorateImageDescriptor(ImageDescriptor descriptor, CompletionProposal proposal) {
        CompletionProposal[] requiredProposals;
        int adornments = 0;
        int flags = proposal.getFlags();
        int kind = proposal.getKind();
        boolean deprecated = Flags.isDeprecated((int)flags);
        if (!deprecated && (requiredProposals = proposal.getRequiredProposals()) != null) {
            int i = 0;
            while (i < requiredProposals.length) {
                CompletionProposal requiredProposal = requiredProposals[i];
                if (requiredProposal.getKind() == 9) {
                    deprecated |= Flags.isDeprecated((int)requiredProposal.getFlags());
                }
                ++i;
            }
        }
        if (deprecated) {
            adornments |= 0x400;
        }
        if ((kind == 2 || kind == 7 || kind == 7 || kind == 12 || kind == 6 || kind == 26) && Flags.isStatic((int)flags)) {
            adornments |= 8;
        }
        if ((kind == 7 || kind == 7 || kind == 12 || kind == 6 || kind == 26) && Flags.isSynchronized((int)flags)) {
            adornments |= 4;
        }
        if (kind == 9 && Flags.isAbstract((int)flags) && !Flags.isInterface((int)flags)) {
            adornments |= 1;
        }
        if (kind == 2) {
            if (Flags.isTransient((int)flags)) {
                adornments |= 0x1000;
            }
            if (Flags.isVolatile((int)flags)) {
                adornments |= 0x800;
            }
        }
        return new JavaElementImageDescriptor(descriptor, adornments, JavaElementImageProvider.SMALL_SIZE);
    }

    void setContext(CompletionContext context) {
        this.fContext = context;
    }
}

