/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.project;

import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.osgi.service.resolver.VersionRange;
import org.eclipse.osgi.util.ManifestElement;
import org.eclipse.pde.core.build.IBuild;
import org.eclipse.pde.core.build.IBuildEntry;
import org.eclipse.pde.core.plugin.IFragment;
import org.eclipse.pde.core.plugin.IFragmentModel;
import org.eclipse.pde.core.plugin.IPlugin;
import org.eclipse.pde.core.plugin.IPluginBase;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.core.project.IBundleClasspathEntry;
import org.eclipse.pde.core.project.IBundleProjectDescription;
import org.eclipse.pde.core.project.IBundleProjectService;
import org.eclipse.pde.core.project.IHostDescription;
import org.eclipse.pde.core.project.IPackageExportDescription;
import org.eclipse.pde.core.project.IPackageImportDescription;
import org.eclipse.pde.core.project.IRequiredBundleDescription;
import org.eclipse.pde.internal.core.ClasspathUtilCore;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.TargetPlatformHelper;
import org.eclipse.pde.internal.core.bundle.BundleFragment;
import org.eclipse.pde.internal.core.bundle.BundlePluginBase;
import org.eclipse.pde.internal.core.ibundle.IBundle;
import org.eclipse.pde.internal.core.ibundle.IManifestHeader;
import org.eclipse.pde.internal.core.plugin.WorkspacePluginModelBase;
import org.eclipse.pde.internal.core.project.PDEProject;
import org.eclipse.pde.internal.core.project.ProjectModifyOperation;
import org.eclipse.pde.internal.core.text.bundle.BundleClasspathHeader;
import org.eclipse.pde.internal.core.text.bundle.BundleModelFactory;
import org.eclipse.pde.internal.core.text.bundle.BundleSymbolicNameHeader;
import org.eclipse.pde.internal.core.text.bundle.ExecutionEnvironment;
import org.eclipse.pde.internal.core.text.bundle.ExportPackageHeader;
import org.eclipse.pde.internal.core.text.bundle.ExportPackageObject;
import org.eclipse.pde.internal.core.text.bundle.ImportPackageHeader;
import org.eclipse.pde.internal.core.text.bundle.ImportPackageObject;
import org.eclipse.pde.internal.core.text.bundle.LazyStartHeader;
import org.eclipse.pde.internal.core.text.bundle.PackageFriend;
import org.eclipse.pde.internal.core.text.bundle.PackageObject;
import org.eclipse.pde.internal.core.text.bundle.RequireBundleHeader;
import org.eclipse.pde.internal.core.text.bundle.RequireBundleObject;
import org.eclipse.pde.internal.core.text.bundle.RequiredExecutionEnvironmentHeader;
import org.osgi.framework.BundleException;
import org.osgi.framework.Version;

public class BundleProjectDescription
implements IBundleProjectDescription {
    private IProject fProject;
    private IPath fRoot;
    private String fSymbolicName;
    private String fBundleName;
    private String fBundleVendor;
    private IHostDescription fHost;
    private URI fUri;
    private Version fVersion;
    private boolean fSingleton = false;
    private IPath fLocalization = null;
    private IPath fDefaultOuputFolder = null;
    private String[] fEEs;
    private String[] fNatures;
    private IBundleClasspathEntry[] fBundleClasspath = null;
    private String fActivator = null;
    private String fTargetVersion;
    private boolean fIsEquinox = false;
    private boolean fIsExtensionRegistry = false;
    private String fActivationPolicy;
    private IRequiredBundleDescription[] fRequiredBundles;
    private IPackageImportDescription[] fImports;
    private IPackageExportDescription[] fExports;
    private IPath[] fBinIncludes;
    private WorkspacePluginModelBase fModel;
    private IBundleProjectService fService;
    private String[] fLaunchShortcuts;
    private String fExportWizard;
    private IBundle fBundle;
    private Map fHeaders = new HashMap();
    static /* synthetic */ Class class$0;

    public BundleProjectDescription(IProject project) throws CoreException {
        this.fProject = project;
        if (project.exists() && project.isOpen()) {
            this.initiaize(project);
        }
    }

    IBundleProjectService getBundleProjectService() {
        if (this.fService == null) {
            PDECore pDECore = PDECore.getDefault();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.pde.core.project.IBundleProjectService");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.fService = (IBundleProjectService)pDECore.acquireService(clazz.getName());
        }
        return this.fService;
    }

    private void initiaize(IProject project) throws CoreException {
        IEclipsePreferences node;
        IContainer root = PDEProject.getBundleRoot(project);
        if (root != project) {
            this.setBundleRoot(root.getProjectRelativePath());
        }
        if ((node = new ProjectScope(project).getNode("org.eclipse.pde.core")) != null) {
            this.setExtensionRegistry(node.getBoolean("pluginProject.extensions", true));
            this.setEquinox(node.getBoolean("pluginProject.equinox", true));
        }
        this.setExportWizardId(PDEProject.getExportWizard(project));
        this.setLaunchShortcuts(PDEProject.getLaunchShortcuts(project));
        this.setLocationURI(project.getDescription().getLocationURI());
        this.setNatureIds(project.getDescription().getNatureIds());
        IPluginModelBase model = PluginRegistry.findModel(project);
        if (model != null) {
            String[] tokens;
            IBuildEntry entry;
            IJavaProject jp;
            IPluginBase base = model.getPluginBase();
            if (base instanceof IPlugin) {
                IPlugin plugin = (IPlugin)base;
                this.setActivator(plugin.getClassName());
            }
            IBuild build = ClasspathUtilCore.getBuild(model);
            this.setBundleName(base.getName());
            this.setBundleVendor(base.getProviderName());
            String version = base.getVersion();
            if (version != null) {
                this.setBundleVersion(new Version(version));
            }
            if ((jp = JavaCore.create((IProject)project)).exists()) {
                this.setDefaultOutputFolder(jp.getOutputLocation().removeFirstSegments(1));
            }
            if (model.isFragmentModel()) {
                IFragmentModel fragModel = (IFragmentModel)model;
                IFragment frag = fragModel.getFragment();
                if (frag instanceof BundleFragment) {
                    ManifestElement[] elements;
                    BundleFragment bf = (BundleFragment)frag;
                    String header = bf.getBundle().getHeader("Fragment-Host");
                    try {
                        elements = ManifestElement.parseHeader((String)"Fragment-Host", (String)header);
                    }
                    catch (BundleException e) {
                        throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.core", e.getMessage(), (Throwable)e));
                    }
                    this.setHost(this.getBundleProjectService().newHost(frag.getPluginId(), this.getRange(elements[0].getAttribute("bundle-version"))));
                } else {
                    this.setHost(this.getBundleProjectService().newHost(frag.getPluginId(), this.getRange(frag.getPluginVersion())));
                }
            }
            if (base instanceof BundlePluginBase) {
                RequireBundleObject[] bundles;
                PackageObject[] packages;
                ExecutionEnvironment[] environments;
                IManifestHeader header;
                IBundle bundle;
                this.fBundle = bundle = ((BundlePluginBase)base).getBundle();
                String value = bundle.getHeader("Bundle-Localization");
                if (value != null) {
                    this.setLocalization((IPath)new Path(value));
                }
                if ((header = this.createHeader(bundle, "Bundle-RequiredExecutionEnvironment")) instanceof RequiredExecutionEnvironmentHeader && (environments = ((RequiredExecutionEnvironmentHeader)header).getEnvironments()) != null && environments.length > 0) {
                    String[] keys = new String[environments.length];
                    int i = 0;
                    while (i < keys.length) {
                        keys[i] = environments[i].getName();
                        ++i;
                    }
                    this.setExecutionEnvironments(keys);
                }
                header = this.createHeader(bundle, "Bundle-ClassPath");
                IBundleClasspathEntry[] classpath = null;
                if (header instanceof BundleClasspathHeader) {
                    Vector libNames = ((BundleClasspathHeader)header).getElementNames();
                    if (!libNames.isEmpty()) {
                        ArrayList<IBundleClasspathEntry> collect = new ArrayList<IBundleClasspathEntry>();
                        Iterator iterator = libNames.iterator();
                        while (iterator.hasNext()) {
                            String libName = (String)iterator.next();
                            IBundleClasspathEntry[] entries = this.getClasspathEntries(project, build, libName);
                            if (entries == null) continue;
                            int i = 0;
                            while (i < entries.length) {
                                collect.add(entries[i]);
                                ++i;
                            }
                        }
                        classpath = collect.toArray(new IBundleClasspathEntry[collect.size()]);
                    }
                } else if (header == null) {
                    classpath = this.getClasspathEntries(project, build, ".");
                }
                this.setBundleClassath(classpath);
                header = this.createHeader(bundle, "Bundle-SymbolicName");
                if (header instanceof BundleSymbolicNameHeader) {
                    this.setSingleton(((BundleSymbolicNameHeader)header).isSingleton());
                }
                if ((header = this.createHeader(bundle, "Import-Package")) instanceof ImportPackageHeader && (packages = ((ImportPackageHeader)header).getPackages()) != null && packages.length > 0) {
                    IPackageImportDescription[] imports = new IPackageImportDescription[packages.length];
                    int i = 0;
                    while (i < packages.length) {
                        PackageObject pkg = packages[i];
                        imports[i] = this.getBundleProjectService().newPackageImport(pkg.getName(), this.getRange(pkg.getVersion()), ((ImportPackageObject)pkg).isOptional());
                        ++i;
                    }
                    this.setPackageImports(imports);
                }
                if ((header = this.createHeader(bundle, "Export-Package")) instanceof ExportPackageHeader && (packages = ((ExportPackageHeader)header).getPackages()) != null && packages.length > 0) {
                    IPackageExportDescription[] exports = new IPackageExportDescription[packages.length];
                    int i = 0;
                    while (i < packages.length) {
                        PackageObject exp = packages[i];
                        String[] friends = null;
                        PackageFriend[] pfs = ((ExportPackageObject)exp).getFriends();
                        if (pfs != null && pfs.length > 0) {
                            friends = new String[pfs.length];
                            int j = 0;
                            while (j < pfs.length) {
                                friends[j] = pfs[j].getName();
                                ++j;
                            }
                        }
                        exports[i] = this.getBundleProjectService().newPackageExport(exp.getName(), this.getVersion(exp.getVersion()), !((ExportPackageObject)exp).isInternal(), friends);
                        ++i;
                    }
                    this.setPackageExports(exports);
                }
                if ((header = this.createHeader(bundle, "Require-Bundle")) instanceof RequireBundleHeader && (bundles = ((RequireBundleHeader)header).getRequiredBundles()) != null && bundles.length > 0) {
                    IRequiredBundleDescription[] req = new IRequiredBundleDescription[bundles.length];
                    int i = 0;
                    while (i < bundles.length) {
                        RequireBundleObject rb = bundles[i];
                        req[i] = this.getBundleProjectService().newRequiredBundle(rb.getId(), this.getRange(rb.getVersion()), rb.isOptional(), rb.isReexported());
                        ++i;
                    }
                    this.setRequiredBundles(req);
                }
                String policy = null;
                header = this.createHeader(bundle, "Eclipse-AutoStart");
                if (header == null && (header = this.createHeader(bundle, "Eclipse-LazyStart")) == null) {
                    header = this.createHeader(bundle, "Bundle-ActivationPolicy");
                }
                if (header instanceof LazyStartHeader && ((LazyStartHeader)header).isLazyStart()) {
                    policy = "lazy";
                }
                this.setActivationPolicy(policy);
            } else {
                this.setActivationPolicy(null);
            }
            this.setSymbolicName(base.getId());
            String latest = TargetPlatformHelper.getTargetVersionString();
            String tv = TargetPlatformHelper.getTargetVersionForSchemaVersion(base.getSchemaVersion());
            if (!tv.equals(latest)) {
                this.setTargetVersion(tv);
            }
            if (build != null && (entry = build.getEntry("bin.includes")) != null && (tokens = entry.getTokens()) != null && tokens.length > 0) {
                ArrayList<String> strings = new ArrayList<String>();
                int i = 0;
                while (i < tokens.length) {
                    strings.add(tokens[i]);
                    ++i;
                }
                strings.remove("META-INF/");
                String[] names = ProjectModifyOperation.getLibraryNames(this);
                if (names != null) {
                    int i2 = 0;
                    while (i2 < names.length) {
                        strings.remove(names[i2]);
                        Path path = new Path(names[i2]);
                        if (path.getFileExtension() == null) {
                            strings.remove(String.valueOf(names[i2]) + "/");
                        }
                        ++i2;
                    }
                }
                if (!strings.isEmpty()) {
                    IPath[] paths = new IPath[strings.size()];
                    int i3 = 0;
                    while (i3 < strings.size()) {
                        paths[i3] = new Path((String)strings.get(i3));
                        ++i3;
                    }
                    this.setBinIncludes(paths);
                }
            }
        }
    }

    private IBundleClasspathEntry[] getClasspathEntries(IProject project, IBuild build, String libraryName) throws CoreException {
        if (build != null) {
            IBuildEntry entry = build.getEntry("source." + libraryName);
            if (entry == null) {
                entry = build.getEntry("output." + libraryName);
                if (entry == null) {
                    return new IBundleClasspathEntry[]{this.getBundleProjectService().newBundleClasspathEntry(null, null, (IPath)new Path(libraryName))};
                }
                return this.getClasspathEntries(project, entry, true);
            }
            return this.getClasspathEntries(project, entry, false);
        }
        return null;
    }

    private IBundleClasspathEntry[] getClasspathEntries(IProject project, IBuildEntry entry, boolean binary) throws CoreException {
        String[] tokens = entry.getTokens();
        Path lib = null;
        lib = binary ? new Path(entry.getName().substring("output.".length())) : new Path(entry.getName().substring("source.".length()));
        if (tokens != null && tokens.length > 0) {
            IBundleClasspathEntry[] bces = new IBundleClasspathEntry[tokens.length];
            int i = 0;
            while (i < tokens.length) {
                Path path = new Path(tokens[i]);
                IBundleClasspathEntry spec = null;
                if (binary) {
                    spec = this.getBundleProjectService().newBundleClasspathEntry(null, (IPath)path, (IPath)lib);
                } else {
                    IJavaProject jp = JavaCore.create((IProject)project);
                    IPath output = null;
                    if (jp.exists()) {
                        IClasspathEntry[] rawClasspath = jp.getRawClasspath();
                        int j = 0;
                        while (j < rawClasspath.length) {
                            IClasspathEntry cpe = rawClasspath[j];
                            if (cpe.getEntryKind() == 3 && cpe.getPath().removeFirstSegments(1).equals((Object)path)) {
                                output = cpe.getOutputLocation();
                                if (output == null) break;
                                output = output.removeFirstSegments(1);
                                break;
                            }
                            ++j;
                        }
                    }
                    spec = this.getBundleProjectService().newBundleClasspathEntry((IPath)path, output, (IPath)lib);
                }
                bces[i] = spec;
                ++i;
            }
            return bces;
        }
        return null;
    }

    private IManifestHeader createHeader(IBundle bundle, String header) {
        BundleModelFactory factory = new BundleModelFactory(bundle.getModel());
        String headerValue = bundle.getHeader(header);
        if (headerValue == null) {
            return null;
        }
        return factory.createHeader(header, headerValue);
    }

    private VersionRange getRange(String version) {
        if (version != null) {
            return new VersionRange(version);
        }
        return null;
    }

    private Version getVersion(String version) {
        if (version != null) {
            return new Version(version);
        }
        return null;
    }

    public void apply(IProgressMonitor monitor) throws CoreException {
        ProjectModifyOperation operation = new ProjectModifyOperation();
        operation.execute(monitor, this);
        this.fModel = operation.getModel();
        this.fService = null;
    }

    public WorkspacePluginModelBase getModel() {
        return this.fModel;
    }

    public void setSymbolicName(String name) {
        this.fSymbolicName = name;
    }

    public String getSymbolicName() {
        return this.fSymbolicName;
    }

    public void setLocationURI(URI location) {
        this.fUri = location;
    }

    public URI getLocationURI() {
        return this.fUri;
    }

    public void setBundleName(String name) {
        this.fBundleName = name;
    }

    public String getBundleName() {
        return this.fBundleName;
    }

    public void setBundleVendor(String name) {
        this.fBundleVendor = name;
    }

    public String getBundleVendor() {
        return this.fBundleVendor;
    }

    public void setBundleVersion(Version version) {
        this.fVersion = version;
    }

    public Version getBundleVersion() {
        return this.fVersion;
    }

    public void setSingleton(boolean singleton) {
        this.fSingleton = singleton;
    }

    public boolean isSingleton() {
        return this.fSingleton;
    }

    public void setLocalization(IPath path) {
        this.fLocalization = path;
    }

    public IPath getLocalization() {
        return this.fLocalization;
    }

    public String[] getNatureIds() {
        if (this.fNatures == null) {
            return new String[0];
        }
        String[] copy = new String[this.fNatures.length];
        System.arraycopy(this.fNatures, 0, copy, 0, this.fNatures.length);
        return copy;
    }

    public void setNatureIds(String[] natures) {
        String[] copy = null;
        if (natures != null) {
            copy = new String[natures.length];
            System.arraycopy(natures, 0, copy, 0, natures.length);
        }
        this.fNatures = copy;
    }

    public boolean hasNature(String natureId) {
        if (this.fNatures != null) {
            int i = 0;
            while (i < this.fNatures.length) {
                if (this.fNatures[i].equals(natureId)) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public void setHost(IHostDescription host) {
        this.fHost = host;
    }

    public IHostDescription getHost() {
        return this.fHost;
    }

    public void setDefaultOutputFolder(IPath output) {
        this.fDefaultOuputFolder = output;
    }

    public IPath getDefaultOutputFolder() {
        return this.fDefaultOuputFolder;
    }

    public void setExecutionEnvironments(String[] environments) {
        this.fEEs = environments;
    }

    public String[] getExecutionEnvironments() {
        return this.fEEs;
    }

    public IBundleClasspathEntry[] getBundleClasspath() {
        return this.fBundleClasspath;
    }

    public void setActivator(String className) {
        this.fActivator = className;
    }

    public String getActivator() {
        return this.fActivator;
    }

    public void setTargetVersion(String version) {
        this.fTargetVersion = version;
    }

    public String getTargetVersion() {
        return this.fTargetVersion;
    }

    public void setEquinox(boolean equinox) {
        this.fIsEquinox = equinox;
    }

    public boolean isEquinox() {
        return this.fIsEquinox;
    }

    public void setRequiredBundles(IRequiredBundleDescription[] bundles) {
        this.fRequiredBundles = bundles;
    }

    public IRequiredBundleDescription[] getRequiredBundles() {
        return this.fRequiredBundles;
    }

    public void setPackageImports(IPackageImportDescription[] imports) {
        this.fImports = imports;
    }

    public IPackageImportDescription[] getPackageImports() {
        return this.fImports;
    }

    public void setPackageExports(IPackageExportDescription[] exports) {
        this.fExports = exports;
    }

    public IPackageExportDescription[] getPackageExports() {
        return this.fExports;
    }

    public IProject getProject() {
        return this.fProject;
    }

    public void setBundleClassath(IBundleClasspathEntry[] entries) {
        this.fBundleClasspath = entries;
    }

    public void setBinIncludes(IPath[] paths) {
        this.fBinIncludes = paths;
    }

    public IPath[] getBinIncludes() {
        return this.fBinIncludes;
    }

    public void setBundleRoot(IPath path) {
        this.fRoot = path;
    }

    public IPath getBundleRoot() {
        return this.fRoot;
    }

    public boolean isExtensionRegistry() {
        return this.fIsExtensionRegistry;
    }

    public void setExtensionRegistry(boolean supportExtensions) {
        this.fIsExtensionRegistry = supportExtensions;
    }

    public String[] getLaunchShortcuts() {
        return this.fLaunchShortcuts;
    }

    public void setLaunchShortcuts(String[] ids) {
        this.fLaunchShortcuts = ids;
    }

    public String getExportWizardId() {
        return this.fExportWizard;
    }

    public void setExportWizardId(String id) {
        this.fExportWizard = id;
    }

    public void setActivationPolicy(String policy) {
        this.fActivationPolicy = "lazy".equals(policy) ? policy : null;
    }

    public String getActivationPolicy() {
        return this.fActivationPolicy;
    }

    public void setHeader(String header, String value) {
        this.fHeaders.put(header, value);
    }

    public String getHeader(String header) {
        if (this.fHeaders.containsKey(header)) {
            return (String)this.fHeaders.get(header);
        }
        if (this.fBundle != null) {
            return this.fBundle.getHeader(header);
        }
        return null;
    }

    Map getExtraHeaders() {
        return this.fHeaders;
    }
}

