/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.ui.internal;

import com.ibm.icu.text.MessageFormat;
import java.io.File;
import java.io.IOException;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.BaseLabelProvider;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.api.tools.internal.provisional.ApiPlugin;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiBaseline;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiComponent;
import org.eclipse.pde.api.tools.internal.provisional.problems.IApiProblem;
import org.eclipse.pde.api.tools.internal.provisional.problems.IApiProblemFilter;
import org.eclipse.pde.api.tools.ui.internal.ApiUIPlugin;
import org.eclipse.pde.api.tools.ui.internal.CompositeApiImageDescriptor;
import org.eclipse.pde.api.tools.ui.internal.Messages;
import org.eclipse.pde.api.tools.ui.internal.wizards.ApiBaselineWizardPage;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;

public class ApiToolsLabelProvider
extends BaseLabelProvider
implements ILabelProvider,
IFontProvider {
    private Font font = null;

    public void dispose() {
        if (this.font != null) {
            this.font.dispose();
        }
        super.dispose();
    }

    public Image getImage(Object element) {
        if (element instanceof IApiComponent) {
            IApiComponent comp = (IApiComponent)element;
            return this.getApiComponentImage(comp);
        }
        if (element instanceof IResource) {
            IResource resource = (IResource)element;
            switch (resource.getType()) {
                case 1: {
                    return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FILE");
                }
                case 2: {
                    return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FOLDER");
                }
                case 4: {
                    return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_PROJECT");
                }
            }
        }
        if (element instanceof File) {
            return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FOLDER");
        }
        if (element instanceof IApiBaseline) {
            return this.getBaselineImage();
        }
        if (element instanceof ApiBaselineWizardPage.EEEntry) {
            return ApiUIPlugin.getSharedImage("IMG_OBJ_API_SYSTEM_LIBRARY");
        }
        if (element instanceof IApiProblemFilter) {
            IApiProblemFilter filter = (IApiProblemFilter)element;
            IApiProblem problem = filter.getUnderlyingProblem();
            Image image = this.getApiProblemElementImage(problem);
            int flags = problem.getSeverity() == 2 ? 1 : 2;
            CompositeApiImageDescriptor desc = new CompositeApiImageDescriptor(image, flags);
            return ApiUIPlugin.getImage((ImageDescriptor)desc);
        }
        return null;
    }

    private Image getApiProblemElementImage(IApiProblem problem) {
        if (problem.getCategory() != 0x20000000) {
            switch (problem.getElementKind()) {
                case 1: {
                    return JavaUI.getSharedImages().getImage("org.eclipse.jdt.ui.annotation_obj.gif");
                }
                case 6: {
                    return JavaUI.getSharedImages().getImage("org.eclipse.jdt.ui.enum_obj.gif");
                }
                case 4: {
                    return JavaUI.getSharedImages().getImage("org.eclipse.jdt.ui.class_obj.gif");
                }
                case 8: {
                    return JavaUI.getSharedImages().getImage("org.eclipse.jdt.ui.int_obj.gif");
                }
                case 7: {
                    return JavaUI.getSharedImages().getImage("org.eclipse.jdt.ui.field_public_obj.gif");
                }
                case 9: {
                    return JavaUI.getSharedImages().getImage("org.eclipse.jdt.ui.methpub_obj.gif");
                }
                case 10: {
                    return JavaUI.getSharedImages().getImage("org.eclipse.jdt.ui.jcu_obj.gif");
                }
                case 3: {
                    return this.getBaselineImage();
                }
                case 2: {
                    IApiComponent comp;
                    Path path = new Path(problem.getResourcePath());
                    IResource res = ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)path);
                    if (res != null && (comp = ApiPlugin.getDefault().getApiBaselineManager().getWorkspaceBaseline().getApiComponent(res.getProject().getName())) != null) {
                        return this.getApiComponentImage(comp);
                    }
                    return ApiUIPlugin.getSharedImage("IMG_OBJ_BUNDLE");
                }
            }
        } else {
            switch (problem.getElementKind()) {
                case 2: {
                    return JavaUI.getSharedImages().getImage("org.eclipse.jdt.ui.class_obj.gif");
                }
                case 6: {
                    return JavaUI.getSharedImages().getImage("org.eclipse.jdt.ui.methpub_obj.gif");
                }
                case 5: {
                    return JavaUI.getSharedImages().getImage("org.eclipse.jdt.ui.field_public_obj.gif");
                }
            }
            System.out.println();
        }
        return null;
    }

    private Image getBaselineImage() {
        return ApiUIPlugin.getSharedImage("IMG_OBJ_ECLIPSE_PROFILE");
    }

    private Image getApiComponentImage(IApiComponent component) {
        if (component.isSystemComponent()) {
            return ApiUIPlugin.getSharedImage("IMG_OBJ_API_SYSTEM_LIBRARY");
        }
        try {
            if (component.isFragment()) {
                return ApiUIPlugin.getSharedImage("IMG_OBJ_FRAGMENT");
            }
        }
        catch (CoreException e) {
            ApiPlugin.log((Throwable)e);
        }
        return ApiUIPlugin.getSharedImage("IMG_OBJ_BUNDLE");
    }

    public String getText(Object element) {
        if (element instanceof IApiComponent) {
            IApiComponent comp = (IApiComponent)element;
            return MessageFormat.format((String)Messages.ApiToolsLabelProvider_0, (Object[])new String[]{comp.getSymbolicName(), comp.getVersion()});
        }
        if (element instanceof File) {
            try {
                return ((File)element).getCanonicalPath();
            }
            catch (IOException iOException) {
                return ((File)element).getName();
            }
        }
        if (element instanceof IApiBaseline) {
            IApiBaseline baseline = (IApiBaseline)element;
            StringBuffer buffer = new StringBuffer();
            buffer.append(baseline.getName());
            if (this.isDefaultBaseline(baseline)) {
                buffer.append(NLS.bind((String)Messages.ApiToolsLabelProvider_default_baseline_place_holder, (Object)Messages.ApiToolsLabelProvider_default_baseline));
            }
            return buffer.toString();
        }
        if (element instanceof ApiBaselineWizardPage.EEEntry) {
            return ((ApiBaselineWizardPage.EEEntry)element).toString();
        }
        if (element instanceof IApiProblemFilter) {
            IApiProblemFilter filter = (IApiProblemFilter)element;
            return filter.getUnderlyingProblem().getMessage();
        }
        if (element instanceof IResource) {
            IResource resource = (IResource)element;
            IPath path = resource.getProjectRelativePath();
            StringBuffer buffer = new StringBuffer();
            buffer.append(path.removeFileExtension().lastSegment());
            buffer.append(" (");
            buffer.append(path.removeLastSegments(1));
            buffer.append(")");
            return buffer.toString();
        }
        return "<unknown>";
    }

    protected boolean isDefaultBaseline(Object element) {
        if (element instanceof IApiBaseline) {
            IApiBaseline profile = (IApiBaseline)element;
            IApiBaseline def = ApiPlugin.getDefault().getApiBaselineManager().getDefaultApiBaseline();
            if (def != null) {
                return profile.getName().equals(def.getName());
            }
        }
        return false;
    }

    public Font getFont(Object element) {
        if (this.isDefaultBaseline(element)) {
            if (this.font == null) {
                Font dialogFont = JFaceResources.getDialogFont();
                FontData[] fontData = dialogFont.getFontData();
                int i = 0;
                while (i < fontData.length) {
                    FontData data = fontData[i];
                    data.setStyle(1);
                    ++i;
                }
                Display display = ApiUIPlugin.getShell().getDisplay();
                this.font = new Font((Device)display, fontData);
            }
            return this.font;
        }
        return null;
    }
}

