/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.ui.internal.markers;

import java.util.ArrayList;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.pde.api.tools.internal.ApiBaselineManager;
import org.eclipse.pde.api.tools.internal.provisional.IApiFilterStore;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiComponent;
import org.eclipse.pde.api.tools.internal.provisional.problems.IApiProblemFilter;
import org.eclipse.pde.api.tools.internal.util.Util;
import org.eclipse.pde.api.tools.ui.internal.markers.DefaultApiProfileResolution;
import org.eclipse.pde.api.tools.ui.internal.markers.DuplicateTagResolution;
import org.eclipse.pde.api.tools.ui.internal.markers.FilterProblemResolution;
import org.eclipse.pde.api.tools.ui.internal.markers.MarkerMessages;
import org.eclipse.pde.api.tools.ui.internal.markers.OpenPropertyPageResolution;
import org.eclipse.pde.api.tools.ui.internal.markers.RemoveFilterProblemResolution;
import org.eclipse.pde.api.tools.ui.internal.markers.SinceTagResolution;
import org.eclipse.pde.api.tools.ui.internal.markers.UnsupportedTagResolution;
import org.eclipse.pde.api.tools.ui.internal.markers.UpdateProjectSettingResolution;
import org.eclipse.pde.api.tools.ui.internal.markers.VersionNumberingResolution;
import org.eclipse.ui.IMarkerResolution;
import org.eclipse.ui.IMarkerResolutionGenerator2;

public class ApiMarkerResolutionGenerator
implements IMarkerResolutionGenerator2 {
    private final IMarkerResolution[] NO_RESOLUTIONS = new IMarkerResolution[0];

    public IMarkerResolution[] getResolutions(IMarker marker) {
        if (!this.hasResolutions(marker)) {
            return this.NO_RESOLUTIONS;
        }
        switch (marker.getAttribute("apiMarkerID", -1)) {
            case 2: 
            case 3: {
                return new IMarkerResolution[]{new FilterProblemResolution(marker)};
            }
            case 1: {
                return new IMarkerResolution[]{new DefaultApiProfileResolution()};
            }
            case 5: {
                return new IMarkerResolution[]{new SinceTagResolution(marker), new FilterProblemResolution(marker)};
            }
            case 4: {
                return new IMarkerResolution[]{new VersionNumberingResolution(marker), new FilterProblemResolution(marker)};
            }
            case 6: {
                return new IMarkerResolution[]{new UnsupportedTagResolution(marker)};
            }
            case 7: {
                return new IMarkerResolution[]{new DuplicateTagResolution(marker)};
            }
            case 8: {
                return new IMarkerResolution[]{new UpdateProjectSettingResolution(marker)};
            }
            case 9: {
                IApiProblemFilter filter = ApiMarkerResolutionGenerator.resolveFilter(marker);
                if (filter != null) {
                    return new IMarkerResolution[]{new RemoveFilterProblemResolution(filter, marker), new OpenPropertyPageResolution(MarkerMessages.ApiMarkerResolutionGenerator_api_problem_filters, "org.eclipse.pde.api.tools.ui.apitools.filterspage", (IAdaptable)marker.getResource().getProject())};
                }
                return new IMarkerResolution[]{new OpenPropertyPageResolution(MarkerMessages.ApiMarkerResolutionGenerator_api_problem_filters, "org.eclipse.pde.api.tools.ui.apitools.filterspage", (IAdaptable)marker.getResource().getProject())};
            }
        }
        return this.NO_RESOLUTIONS;
    }

    static IApiProblemFilter resolveFilter(IMarker marker) {
        try {
            String filterhandle = marker.getAttribute("filterhandle", null);
            String[] values = filterhandle.split("%]");
            IProject project = marker.getResource().getProject();
            IApiComponent component = ApiBaselineManager.getManager().getWorkspaceBaseline().getApiComponent(project);
            if (component != null) {
                IApiFilterStore store = component.getFilterStore();
                Path path = new Path(values[1]);
                IResource resource = project.findMember((IPath)path);
                if (resource == null) {
                    resource = project.getFile((IPath)path);
                }
                int hashcode = ApiMarkerResolutionGenerator.computeProblemHashcode(filterhandle);
                IApiProblemFilter[] filters = store.getFilters(resource);
                int i = 0;
                while (i < filters.length) {
                    if (filters[i].getUnderlyingProblem().hashCode() == hashcode) {
                        return filters[i];
                    }
                    ++i;
                }
            }
        }
        catch (CoreException coreException) {}
        return null;
    }

    private static int computeProblemHashcode(String filterhandle) {
        if (filterhandle == null) {
            return -1;
        }
        String[] args = filterhandle.split("%]");
        int hashcode = 0;
        try {
            hashcode += Integer.parseInt(args[0]);
            hashcode += args[1].hashCode();
            hashcode += args[2].hashCode();
            String[] margs = ApiMarkerResolutionGenerator.splitHandle(args[3], ",");
            hashcode += ApiMarkerResolutionGenerator.argumentsHashcode(margs);
        }
        catch (Exception exception) {}
        return hashcode;
    }

    private static String[] splitHandle(String messageArguments, String delimiter) {
        ArrayList<String> matches = null;
        char[] argumentsChars = messageArguments.toCharArray();
        char[] delimiterChars = delimiter.toCharArray();
        int delimiterLength = delimiterChars.length;
        int start = 0;
        int argumentsCharsLength = argumentsChars.length;
        int balance = 0;
        int i = 0;
        while (i < argumentsCharsLength) {
            char c = argumentsChars[i];
            switch (c) {
                case '(': {
                    ++balance;
                    break;
                }
                case ')': {
                    --balance;
                }
            }
            if (c == delimiterChars[0] && balance == 0) {
                if (i + delimiterLength < argumentsCharsLength) {
                    boolean match = true;
                    int j = 1;
                    while (j < delimiterLength) {
                        if (argumentsChars[i + j] != delimiterChars[j]) {
                            match = false;
                            break;
                        }
                        ++j;
                    }
                    if (match) {
                        if (matches == null) {
                            matches = new ArrayList<String>();
                        }
                        matches.add(messageArguments.substring(start, i));
                        start = i + delimiterLength;
                        i += delimiterLength;
                        continue;
                    }
                    ++i;
                    continue;
                }
                ++i;
                continue;
            }
            ++i;
        }
        if (matches == null) {
            return new String[]{messageArguments};
        }
        matches.add(messageArguments.substring(start, argumentsCharsLength));
        return matches.toArray(new String[matches.size()]);
    }

    private static int argumentsHashcode(String[] arguments) {
        if (arguments == null) {
            return 0;
        }
        int hashcode = 0;
        int i = 0;
        while (i < arguments.length) {
            hashcode += arguments[i].hashCode();
            ++i;
        }
        return hashcode;
    }

    public boolean hasResolutions(IMarker marker) {
        return Util.isApiProblemMarker((IMarker)marker);
    }
}

