/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.ui.dialogs;

import java.lang.reflect.InvocationTargetException;
import java.util.HashSet;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.equinox.internal.p2.ui.ProvUI;
import org.eclipse.equinox.internal.p2.ui.ProvUIMessages;
import org.eclipse.equinox.internal.p2.ui.dialogs.IResolutionErrorReportingPage;
import org.eclipse.equinox.internal.p2.ui.dialogs.ISelectableIUsPage;
import org.eclipse.equinox.internal.p2.ui.dialogs.ProvisioningWizardPage;
import org.eclipse.equinox.internal.p2.ui.dialogs.ResolutionResultsWizardPage;
import org.eclipse.equinox.internal.p2.ui.model.ElementUtils;
import org.eclipse.equinox.internal.p2.ui.model.IUElementListRoot;
import org.eclipse.equinox.p2.engine.ProvisioningContext;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.operations.ProfileChangeOperation;
import org.eclipse.equinox.p2.ui.LoadMetadataRepositoryJob;
import org.eclipse.equinox.p2.ui.Policy;
import org.eclipse.equinox.p2.ui.ProvisioningUI;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.statushandlers.StatusManager;

public abstract class ProvisioningOperationWizard
extends Wizard {
    private static final String WIZARD_SETTINGS_SECTION = "WizardSettings";
    protected ProvisioningUI ui;
    protected IUElementListRoot root;
    protected ProfileChangeOperation operation;
    protected Object[] planSelections;
    protected ISelectableIUsPage mainPage;
    protected IResolutionErrorReportingPage errorPage;
    protected ResolutionResultsWizardPage resolutionPage;
    private ProvisioningContext provisioningContext;
    protected LoadMetadataRepositoryJob repoPreloadJob;
    IStatus couldNotResolveStatus = Status.OK_STATUS;
    boolean waitingForOtherJobs = false;

    public ProvisioningOperationWizard(ProvisioningUI ui, ProfileChangeOperation operation, Object[] initialSelections, LoadMetadataRepositoryJob job) {
        this.ui = ui;
        this.initializeResolutionModelElements(initialSelections);
        this.operation = operation;
        this.repoPreloadJob = job;
        this.setForcePreviousAndNextButtons(true);
        this.setNeedsProgressMonitor(true);
    }

    public void addPages() {
        this.mainPage = this.createMainPage(this.root, this.planSelections);
        this.addPage(this.mainPage);
        this.errorPage = this.createErrorReportingPage();
        if (this.errorPage != this.mainPage) {
            this.addPage(this.errorPage);
        }
        this.resolutionPage = this.createResolutionPage();
        this.addPage((IWizardPage)this.resolutionPage);
    }

    protected abstract IResolutionErrorReportingPage createErrorReportingPage();

    protected abstract ISelectableIUsPage createMainPage(IUElementListRoot var1, Object[] var2);

    protected abstract ResolutionResultsWizardPage createResolutionPage();

    public boolean performFinish() {
        return this.resolutionPage.performFinish();
    }

    protected LoadMetadataRepositoryJob getRepositoryPreloadJob() {
        return this.repoPreloadJob;
    }

    public IWizardPage getNextPage(IWizardPage page) {
        if (page == this.mainPage || page == this.errorPage) {
            ISelectableIUsPage currentPage = (ISelectableIUsPage)page;
            if (this.operation == null || this.operation != null && this.shouldRecomputePlan(currentPage)) {
                this.recomputePlan((IRunnableContext)this.getContainer());
            } else {
                this.initializeResolutionModelElements(this.planSelections);
            }
            IStatus status = this.operation.getResolutionResult();
            if (status == null || status.getSeverity() == 4) {
                return this.errorPage;
            }
            if (status.getSeverity() == 8) {
                return page;
            }
            return this.resolutionPage;
        }
        return super.getNextPage(page);
    }

    public void mainPageSelectionsChanged() {
        if (this.resolutionPage != null) {
            IWizardContainer container;
            boolean old = this.resolutionPage.isPageComplete();
            this.resolutionPage.setPageComplete(!this.pageSelectionsHaveChanged(this.mainPage));
            if (old != this.resolutionPage.isPageComplete() && (container = this.getContainer()) != null && container.getCurrentPage() != null) {
                this.getContainer().updateButtons();
            }
        }
    }

    private boolean shouldRecomputePlan(ISelectableIUsPage page) {
        boolean previouslyWaiting = this.waitingForOtherJobs;
        boolean previouslyCanceled = this.getCurrentStatus().getSeverity() == 8;
        this.waitingForOtherJobs = this.ui.hasScheduledOperations();
        return this.waitingForOtherJobs || previouslyWaiting || previouslyCanceled || this.pageSelectionsHaveChanged(page) || this.provisioningContextChanged();
    }

    private boolean pageSelectionsHaveChanged(ISelectableIUsPage page) {
        HashSet<IInstallableUnit> selectedIUs = new HashSet<IInstallableUnit>();
        Object[] currentSelections = page.getCheckedIUElements();
        selectedIUs.addAll(ElementUtils.elementsToIUs(currentSelections));
        HashSet<IInstallableUnit> lastIUSelections = new HashSet<IInstallableUnit>();
        if (this.planSelections != null) {
            lastIUSelections.addAll(ElementUtils.elementsToIUs(this.planSelections));
        }
        return !selectedIUs.equals(lastIUSelections);
    }

    private boolean provisioningContextChanged() {
        ProvisioningContext currentProvisioningContext = this.getProvisioningContext();
        if (currentProvisioningContext == null && this.provisioningContext == null) {
            return false;
        }
        if (currentProvisioningContext != null && this.provisioningContext != null) {
            return currentProvisioningContext.equals(this.provisioningContext);
        }
        return true;
    }

    protected void planChanged() {
        this.resolutionPage.updateStatus(this.root, this.operation);
        if (this.errorPage != this.resolutionPage) {
            IUElementListRoot newRoot = this.shouldUpdateErrorPageModelOnPlanChange() ? this.root : null;
            this.errorPage.updateStatus(newRoot, this.operation);
        }
    }

    protected boolean shouldUpdateErrorPageModelOnPlanChange() {
        return this.errorPage != this.mainPage;
    }

    protected abstract void initializeResolutionModelElements(Object[] var1);

    protected ProvisioningContext getProvisioningContext() {
        return null;
    }

    public void recomputePlan(IRunnableContext runnableContext) {
        this.couldNotResolveStatus = Status.OK_STATUS;
        this.provisioningContext = this.getProvisioningContext();
        this.initializeResolutionModelElements(this.mainPage.getCheckedIUElements());
        if (this.planSelections.length == 0) {
            this.operation = null;
            this.couldNotResolve(ProvUIMessages.ResolutionWizardPage_NoSelections);
        } else {
            this.operation = this.getProfileChangeOperation(this.planSelections);
            this.operation.setProvisioningContext(this.provisioningContext);
            try {
                runnableContext.run(true, true, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) {
                        ProvisioningOperationWizard.this.operation.resolveModal(monitor);
                    }
                });
            }
            catch (InterruptedException interruptedException) {
            }
            catch (InvocationTargetException e) {
                ProvUI.handleException(e.getCause(), null, 3);
                this.couldNotResolve(null);
            }
        }
        this.planChanged();
    }

    protected abstract ProfileChangeOperation getProfileChangeOperation(Object[] var1);

    void couldNotResolve(String message) {
        this.couldNotResolveStatus = message != null ? new Status(4, "org.eclipse.equinox.p2.ui", message, null) : new Status(4, "org.eclipse.equinox.p2.ui", ProvUIMessages.ProvisioningOperationWizard_UnexpectedFailureToResolve, null);
        StatusManager.getManager().handle(this.couldNotResolveStatus, 1);
    }

    public IStatus getCurrentStatus() {
        if (this.operation != null && this.operation.getResolutionResult() != null) {
            return this.operation.getResolutionResult();
        }
        return this.couldNotResolveStatus;
    }

    public String getDialogSettingsSectionName() {
        return String.valueOf(((Object)((Object)this)).getClass().getName()) + "." + WIZARD_SETTINGS_SECTION;
    }

    public void saveBoundsRelatedSettings() {
        IWizardPage[] pages = this.getPages();
        int i = 0;
        while (i < pages.length) {
            if (pages[i] instanceof ProvisioningWizardPage) {
                ((ProvisioningWizardPage)pages[i]).saveBoundsRelatedSettings();
            }
            ++i;
        }
    }

    protected Policy getPolicy() {
        return this.ui.getPolicy();
    }

    protected String getProfileId() {
        return this.ui.getProfileId();
    }

    protected boolean shouldShowProvisioningPlanChildren() {
        return ProvUI.getQueryContext(this.getPolicy()).getShowProvisioningPlanChildren();
    }

    public void createPageControls(Composite pageContainer) {
        super.createPageControls(pageContainer);
        if (this.repoPreloadJob != null) {
            if (this.repoPreloadJob.getProperty(LoadMetadataRepositoryJob.WIZARD_CLIENT_SHOULD_SCHEDULE) != null) {
                this.repoPreloadJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                    public void done(IJobChangeEvent e) {
                        ProvisioningOperationWizard.this.asyncReportLoadFailures();
                    }
                });
                this.repoPreloadJob.schedule();
            } else if (this.repoPreloadJob.getState() == 0) {
                this.asyncReportLoadFailures();
            } else {
                this.repoPreloadJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                    public void done(IJobChangeEvent e) {
                        ProvisioningOperationWizard.this.asyncReportLoadFailures();
                    }
                });
            }
        }
    }

    void asyncReportLoadFailures() {
        if (this.repoPreloadJob != null && this.getShell() != null && !this.getShell().isDisposed()) {
            this.getShell().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    if (PlatformUI.isWorkbenchRunning() && ProvisioningOperationWizard.this.getShell() != null && !ProvisioningOperationWizard.this.getShell().isDisposed()) {
                        ProvisioningOperationWizard.this.repoPreloadJob.reportAccumulatedStatus();
                    }
                }
            });
        }
    }
}

