/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.base.scope;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.help.base.AbstractHelpScope;
import org.eclipse.help.internal.base.HelpBasePlugin;
import org.eclipse.help.internal.base.scope.ScopeHandle;
import org.eclipse.help.internal.base.scope.UniversalScope;

public class ScopeRegistry {
    public static final String SCOPE_XP_NAME = "org.eclipse.help.base.scope";
    public static final String ENABLEMENT_SCOPE_ID = "org.eclipse.help.enablement";
    public static final String SEARCH_SCOPE_SCOPE_ID = "org.eclipse.help.searchscope";
    private static List scopes = null;
    private static ScopeRegistry instance;
    private boolean initialized = false;

    private ScopeRegistry() {
    }

    public static ScopeRegistry getInstance() {
        if (instance == null) {
            instance = new ScopeRegistry();
        }
        return instance;
    }

    public AbstractHelpScope getScope(String id) {
        if (id == null) {
            return new UniversalScope();
        }
        this.readScopes();
        Iterator iter = scopes.iterator();
        while (iter.hasNext()) {
            ScopeHandle handle = (ScopeHandle)iter.next();
            if (!id.equals(handle.getId())) continue;
            return handle.getScope();
        }
        return null;
    }

    private synchronized void readScopes() {
        if (this.initialized) {
            return;
        }
        scopes = new ArrayList();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] elements = registry.getConfigurationElementsFor(SCOPE_XP_NAME);
        int i = 0;
        while (i < elements.length) {
            Object obj = null;
            try {
                obj = elements[i].createExecutableExtension("class");
            }
            catch (CoreException e) {
                HelpBasePlugin.logError("Create extension failed:[org.eclipse.help.base.scope].", e);
            }
            if (obj instanceof AbstractHelpScope) {
                String id = elements[i].getAttribute("id");
                ScopeHandle filter = new ScopeHandle(id, (AbstractHelpScope)obj);
                scopes.add(filter);
            }
            ++i;
        }
        this.initialized = true;
    }

    public ScopeHandle[] getScopes() {
        this.readScopes();
        return scopes.toArray(new ScopeHandle[scopes.size()]);
    }
}

