/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.verifier;

import java.security.Principal;
import java.security.cert.Certificate;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.text.DateFormat;
import java.util.Date;
import org.eclipse.osgi.signedcontent.SignedContent;
import org.eclipse.osgi.signedcontent.SignerInfo;
import org.eclipse.osgi.util.NLS;
import org.eclipse.update.core.ContentReference;
import org.eclipse.update.core.IFeature;
import org.eclipse.update.core.IVerificationResult;
import org.eclipse.update.internal.core.Messages;

public class CertVerificationResult
implements IVerificationResult {
    private int resultCode;
    private int verificationCode;
    private Exception resultException;
    private SignedContent signedContent;
    private String signerInfo;
    private String verifierInfo;
    private ContentReference contentReference;
    private IFeature feature;
    private boolean featureVerification;
    private boolean alreadySeen;

    public int getResultCode() {
        return this.resultCode;
    }

    public Exception getVerificationException() {
        return this.resultException;
    }

    public void setResultCode(int newResultCode) {
        this.resultCode = newResultCode;
    }

    public void setResultException(Exception newResultException) {
        this.resultException = newResultException;
    }

    public int getVerificationCode() {
        return this.verificationCode;
    }

    public void setVerificationCode(int verificationCode) {
        this.verificationCode = verificationCode;
    }

    void setSignedContent(SignedContent signedContent) {
        this.signedContent = signedContent;
    }

    public SignerInfo[] getSigners() {
        return this.signedContent.getSignerInfos();
    }

    private void initializeCertificates() {
        X509Certificate certRoot = null;
        X509Certificate certIssuer = null;
        SignerInfo[] signers = this.getSigners();
        if (signers.length == 0) {
            return;
        }
        SignerInfo trustedSigner = signers[0];
        int i = 0;
        while (i < signers.length) {
            if (signers[i].isTrusted()) {
                trustedSigner = signers[i];
                break;
            }
            ++i;
        }
        Certificate[] certs = trustedSigner.getCertificateChain();
        if (certs == null || certs.length == 0) {
            return;
        }
        certRoot = (X509Certificate)certs[certs.length - 1];
        certIssuer = (X509Certificate)certs[0];
        StringBuffer strb = new StringBuffer();
        strb.append(this.issuerString(certIssuer.getSubjectDN()));
        strb.append("\r\n");
        strb.append(NLS.bind((String)Messages.JarVerificationResult_ValidBetween, (Object[])new String[]{this.dateString(certIssuer.getNotBefore()), this.dateString(certIssuer.getNotAfter())}));
        strb.append(this.checkValidity(trustedSigner));
        this.signerInfo = strb.toString();
        if (!certIssuer.equals(certRoot)) {
            strb = new StringBuffer();
            strb.append(this.issuerString(certIssuer.getIssuerDN()));
            strb.append("\r\n");
            strb.append(NLS.bind((String)Messages.JarVerificationResult_ValidBetween, (Object[])new String[]{this.dateString(certRoot.getNotBefore()), this.dateString(certRoot.getNotAfter())}));
            this.verifierInfo = strb.toString();
        }
    }

    private String checkValidity(SignerInfo signer) {
        try {
            this.signedContent.checkValidity(signer);
        }
        catch (CertificateExpiredException certificateExpiredException) {
            return "\r\n" + Messages.JarVerificationResult_ExpiredCertificate;
        }
        catch (CertificateNotYetValidException certificateNotYetValidException) {
            return "\r\n" + Messages.JarVerificationResult_CertificateNotYetValid;
        }
        return "\r\n" + Messages.JarVerificationResult_CertificateValid;
    }

    private String issuerString(Principal principal) {
        return principal.toString();
    }

    private String dateString(Date date) {
        return DateFormat.getDateInstance().format(date);
    }

    public String getSignerInfo() {
        if (this.signerInfo == null) {
            this.initializeCertificates();
        }
        return this.signerInfo;
    }

    public String getVerifierInfo() {
        if (this.signerInfo == null) {
            this.initializeCertificates();
        }
        return this.verifierInfo;
    }

    public ContentReference getContentReference() {
        return this.contentReference;
    }

    public void setContentReference(ContentReference ref) {
        this.contentReference = ref;
    }

    public IFeature getFeature() {
        return this.feature;
    }

    public void setFeature(IFeature feature) {
        this.feature = feature;
    }

    public String getText() {
        return null;
    }

    public boolean isFeatureVerification() {
        return this.featureVerification;
    }

    public void isFeatureVerification(boolean featureVerification) {
        this.featureVerification = featureVerification;
    }

    public boolean alreadySeen() {
        return this.alreadySeen;
    }

    public boolean alreadySeen(boolean seen) {
        this.alreadySeen = seen;
        return this.alreadySeen;
    }
}

