/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.xwt.tools.ui.designer.core.editor.outline;

import org.eclipse.e4.xwt.tools.ui.designer.core.editor.Designer;
import org.eclipse.e4.xwt.tools.ui.designer.core.editor.outline.dnd.OutlineDragListener;
import org.eclipse.e4.xwt.tools.ui.designer.core.editor.outline.dnd.OutlineDropListener;
import org.eclipse.e4.xwt.tools.ui.designer.core.editor.outline.dnd.OutlineDropManager;
import org.eclipse.e4.xwt.tools.ui.designer.core.editor.outline.dnd.OutlineNodeTransfer;
import org.eclipse.gef.ContextMenuProvider;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartListener;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.RootEditPart;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.part.IPageSite;

public class ContentOutlinePage
extends org.eclipse.ui.views.contentoutline.ContentOutlinePage {
    private Designer designer;
    private ITreeContentProvider contentProvider;
    private ILabelProvider labelProvider;
    private ViewerFilter[] viewerFilters;
    private ContextMenuProvider contextMenuProvider;
    private OutlineDragListener dragListener;
    private OutlineDropListener dropListener;
    private OutlineDropManager dropManager;

    public ContentOutlinePage(Designer designer) {
        this.designer = designer;
    }

    public Designer getDesigner() {
        return this.designer;
    }

    public ContentOutlinePage(Designer designer, ITreeContentProvider contentProvider, ILabelProvider labelProvider) {
        this(designer, contentProvider, labelProvider, null);
    }

    public ContentOutlinePage(Designer designer, ITreeContentProvider contentProvider, ILabelProvider labelProvider, ViewerFilter[] viewerFilters) {
        this(designer);
        this.setContentProvider(contentProvider);
        this.setLabelProvider(labelProvider);
        this.setViewerFilters(viewerFilters);
    }

    public ViewerFilter[] getViewerFilters() {
        return this.viewerFilters;
    }

    public void setViewerFilters(ViewerFilter[] viewerFilters) {
        this.viewerFilters = viewerFilters;
        if (this.getTreeViewer() != null && viewerFilters != null) {
            this.getTreeViewer().setFilters(viewerFilters);
        }
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        this.configureViewer();
    }

    public void init(IPageSite pageSite) {
        super.init(pageSite);
        this.getContextMenuProvider().addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                ContentOutlinePage.this.fireSelectionChanged(ContentOutlinePage.this.getSelection());
            }
        });
    }

    private void configureViewer() {
        RootEditPart rootEditPart;
        TreeViewer treeViewer = this.getTreeViewer();
        ContextMenuProvider menuManager = this.getContextMenuProvider();
        if (menuManager != null) {
            Tree tree = treeViewer.getTree();
            tree.setMenu(menuManager.createContextMenu((Control)tree));
        }
        if (this.getContentProvider() != null) {
            treeViewer.setContentProvider((IContentProvider)this.getContentProvider());
        }
        if (this.getLabelProvider() != null) {
            treeViewer.setLabelProvider((IBaseLabelProvider)this.getLabelProvider());
        }
        if (this.getViewerFilters() != null) {
            treeViewer.setFilters(this.getViewerFilters());
        }
        this.setupDnD(treeViewer);
        if (this.designer == null) {
            return;
        }
        GraphicalViewer graphicalViewer = this.designer.getGraphicalViewer();
        if (graphicalViewer != null && (rootEditPart = graphicalViewer.getRootEditPart()) != null) {
            treeViewer.setInput((Object)rootEditPart);
            rootEditPart.addEditPartListener((EditPartListener)new RefreshListener());
        }
        treeViewer.addSelectionChangedListener((ISelectionChangedListener)this.designer);
    }

    protected void setupDnD(TreeViewer treeViewer) {
        if (this.dragListener == null) {
            this.dragListener = new OutlineDragListener(treeViewer);
        }
        if (this.dropListener == null) {
            this.dropListener = new OutlineDropListener(treeViewer, this.getDropManager());
        }
        treeViewer.addDragSupport(7, new Transfer[]{OutlineNodeTransfer.getTransfer()}, (DragSourceListener)this.dragListener);
        treeViewer.addDropSupport(7, new Transfer[]{OutlineNodeTransfer.getTransfer()}, (DropTargetListener)this.dropListener);
    }

    public TreeViewer getTreeViewer() {
        return super.getTreeViewer();
    }

    public void setContentProvider(ITreeContentProvider contentProvider) {
        this.contentProvider = contentProvider;
        if (this.getTreeViewer() != null && contentProvider != null) {
            this.getTreeViewer().setContentProvider((IContentProvider)contentProvider);
        }
    }

    public ITreeContentProvider getContentProvider() {
        return this.contentProvider;
    }

    public void setLabelProvider(ILabelProvider labelProvider) {
        this.labelProvider = labelProvider;
        if (this.getTreeViewer() != null && labelProvider != null) {
            this.getTreeViewer().setLabelProvider((IBaseLabelProvider)labelProvider);
        }
    }

    public ILabelProvider getLabelProvider() {
        return this.labelProvider;
    }

    public void refresh(EditPart editPart) {
        TreeViewer treeViewer = this.getTreeViewer();
        if (treeViewer != null) {
            Widget item = treeViewer.testFindItem((Object)editPart);
            if (item != null) {
                treeViewer.refresh((Object)editPart, true);
            } else {
                treeViewer.refresh();
            }
        }
    }

    public void setContextMenuProvider(ContextMenuProvider contextMenuProvider) {
        this.contextMenuProvider = contextMenuProvider;
        TreeViewer treeViewer = this.getTreeViewer();
        if (contextMenuProvider != null && treeViewer != null) {
            Tree tree = treeViewer.getTree();
            tree.setMenu(contextMenuProvider.createContextMenu((Control)tree));
        }
    }

    public ContextMenuProvider getContextMenuProvider() {
        return this.contextMenuProvider;
    }

    public void setDropManager(OutlineDropManager dropManager) {
        this.dropManager = dropManager;
    }

    public OutlineDropManager getDropManager() {
        return this.dropManager;
    }

    private class RefreshListener
    extends EditPartListener.Stub {
        private RefreshListener() {
        }

        public void childAdded(EditPart child, int index) {
            this.updateEditPartListener(child);
            ContentOutlinePage.this.refresh(child.getParent());
        }

        public void removingChild(EditPart child, int index) {
            this.removeEditPartListener(child);
            TreeViewer treeViewer = ContentOutlinePage.this.getTreeViewer();
            if (treeViewer != null) {
                treeViewer.remove((Object)child);
            }
        }

        protected void removeEditPartListener(EditPart child) {
            child.removeEditPartListener((EditPartListener)this);
            for (EditPart part : child.getChildren()) {
                this.removeEditPartListener(part);
            }
        }

        protected void updateEditPartListener(EditPart child) {
            child.removeEditPartListener((EditPartListener)this);
            child.addEditPartListener((EditPartListener)this);
            for (EditPart part : child.getChildren()) {
                this.updateEditPartListener(part);
            }
        }
    }
}

