/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.componentcore.internal.flat;

import java.io.File;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.wst.common.componentcore.internal.flat.FlatResource;
import org.eclipse.wst.common.componentcore.internal.flat.IFlatFolder;
import org.eclipse.wst.common.componentcore.internal.flat.IFlatResource;

public class FlatFolder
extends FlatResource
implements IFlatFolder {
    private static final FlatResource[] EMPTY_RESOURCE_ARRAY = new FlatResource[0];
    private IContainer container;
    private String name;
    private IPath path;
    private IFlatResource[] members;

    public FlatFolder(IContainer container, String name, IPath path) {
        if (name == null) {
            throw new IllegalArgumentException();
        }
        this.container = container;
        this.name = name;
        this.path = path;
    }

    public void setMembers(IFlatResource[] members) {
        this.members = members;
    }

    public IPath getModuleRelativePath() {
        return this.path;
    }

    public String getName() {
        return this.name;
    }

    public IFlatResource[] members() {
        if (this.members == null) {
            return EMPTY_RESOURCE_ARRAY;
        }
        return this.members;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof FlatFolder)) {
            return false;
        }
        FlatFolder mf = (FlatFolder)obj;
        if (!this.name.equals(mf.name)) {
            return false;
        }
        return this.path.equals((Object)mf.path);
    }

    public int hashCode() {
        return this.name.hashCode() * 37 + this.path.hashCode();
    }

    public Object getAdapter(Class cl) {
        if (IContainer.class.equals((Object)cl) || IFolder.class.equals((Object)cl) || IResource.class.equals((Object)cl)) {
            return this.container;
        }
        if (File.class.equals((Object)cl)) {
            return this.container.getLocation().toFile();
        }
        return null;
    }

    public String toString() {
        return "DeployableFolder [" + this.name + ", " + this.path + "]";
    }
}

