/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.core.internal.contentmodel.internal.util;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import java.util.Vector;
import org.eclipse.wst.xml.core.internal.contentmodel.CMAnyElement;
import org.eclipse.wst.xml.core.internal.contentmodel.CMContent;
import org.eclipse.wst.xml.core.internal.contentmodel.CMDataType;
import org.eclipse.wst.xml.core.internal.contentmodel.CMDocument;
import org.eclipse.wst.xml.core.internal.contentmodel.CMElementDeclaration;
import org.eclipse.wst.xml.core.internal.contentmodel.CMGroup;
import org.eclipse.wst.xml.core.internal.contentmodel.CMNode;
import org.eclipse.wst.xml.core.internal.contentmodel.CMNodeList;
import org.eclipse.wst.xml.core.internal.contentmodel.util.CMVisitor;

public class CMValidator {
    protected static final StringElementContentComparator stringContentComparitor = new StringElementContentComparator();
    protected Hashtable graphNodeTable = new Hashtable();

    public GraphNode lookupOrCreateGraph(CMElementDeclaration element) {
        CMElementDeclaration key = element;
        GraphNode node = (GraphNode)this.graphNodeTable.get(key);
        if (node == null) {
            node = this.createGraph(element);
            this.graphNodeTable.put(key, node);
        }
        return node;
    }

    public GraphNode createGraph(CMElementDeclaration element) {
        GraphGenerator generator = new GraphGenerator();
        generator.generateGraph(element);
        return generator.getStartGraphNode();
    }

    public void printGraph(GraphNode node, Vector namedArcList, Vector unamedArcList, int indent) {
        indent += 2;
        Enumeration e = node.arcList.elements();
        while (e.hasMoreElements()) {
            Arc arc = (Arc)e.nextElement();
            if (arc.kind == 1) {
                if (namedArcList.contains(arc)) continue;
                namedArcList.add(arc);
                unamedArcList = new Vector<Arc>();
                this.printGraph(arc.node, namedArcList, unamedArcList, indent + 2);
                continue;
            }
            if (unamedArcList.contains(arc)) continue;
            unamedArcList.add(arc);
            this.printGraph(arc.node, namedArcList, unamedArcList, indent + 2);
        }
    }

    public void printGraph(GraphNode node) {
        this.printGraph(node, new Vector(), new Vector(), 0);
    }

    public void validateElementList(ElementList initialList, GraphNode initialGraphNode, ElementContentComparator comparator, Result result, boolean initialLoopFlag) {
        Stack<ArcStackItem> arcStack = new Stack<ArcStackItem>();
        arcStack.push(new ArcStackItem(null, false));
        boolean loopFlag = initialLoopFlag;
        ElementList elementList = initialList;
        GraphNode graphNode = initialGraphNode;
        while (!arcStack.isEmpty() && !result.isValid) {
            ArcStackItem stackElement = (ArcStackItem)arcStack.peek();
            if (stackElement.isVisited) {
                arcStack.pop();
                if (stackElement.arc != null) {
                    result.pop(stackElement.arc);
                    continue;
                }
            } else {
                stackElement.isVisited = true;
                result.push(stackElement.arc);
                graphNode = stackElement.arc.node;
                loopFlag = stackElement.loopFlag;
            }
            if (elementList == null && graphNode.isTerminal) {
                result.isValid = true;
                continue;
            }
            Iterator arcIterator = graphNode.arcList.iterator();
            while (arcIterator.hasNext()) {
                Arc arc = (Arc)arcIterator.next();
                boolean traverseArc = false;
                if (arc.kind == 1) {
                    if (elementList != null && comparator.matches(elementList.head, arc.cmNode)) {
                        loopFlag = false;
                        traverseArc = true;
                        elementList = elementList.tail;
                    }
                } else if (arc.kind == 2) {
                    if (!loopFlag) {
                        traverseArc = true;
                    }
                    loopFlag = true;
                } else {
                    traverseArc = true;
                }
                if (!traverseArc || !result.canPush(arc)) continue;
                arcStack.push(new ArcStackItem(arc, loopFlag));
            }
        }
    }

    protected static ElementList createElementList(int contentType, List v, ElementContentComparator comparator, Result result) {
        ElementList first = null;
        ElementList prev = null;
        int size = v.size();
        int i = 0;
        while (i < size) {
            Object o = v.get(i);
            if (o != null && !comparator.isIgnorable(o)) {
                if (comparator.isElement(o)) {
                    ElementList list = new ElementList();
                    list.head = o;
                    if (prev != null) {
                        prev.tail = list;
                    } else {
                        first = list;
                    }
                    prev = list;
                } else if (contentType == 2) {
                    result.isValid = false;
                    result.errorIndex = i;
                    result.errorMessage = "Element can not include PCDATA content";
                }
            }
            ++i;
        }
        return first;
    }

    public void validate(CMElementDeclaration ed, List elementContent, ElementContentComparator comparator, Result result) {
        block8: {
            int contentType;
            block9: {
                CMGroup group;
                contentType = ed.getContentType();
                if (contentType != 3 && contentType != 2) break block9;
                ElementList elementList = CMValidator.createElementList(contentType, elementContent, comparator, result);
                if (!result.isValid) break block8;
                boolean isGraphValidationNeeded = elementList != null || contentType != 3;
                CMContent content = ed.getContent();
                if (content.getNodeType() == 7 && (group = (CMGroup)content).getOperator() == 3) {
                    isGraphValidationNeeded = false;
                    this.validatAllGroupContent(elementContent, comparator, group, result);
                }
                if (!isGraphValidationNeeded) break block8;
                result.isValid = false;
                GraphNode node = this.lookupOrCreateGraph(ed);
                this.validateElementList(elementList, node, comparator, result, false);
                break block8;
            }
            if (contentType == 4) {
                int size = elementContent.size();
                int i = 0;
                while (i < size) {
                    Object o = elementContent.get(i);
                    if (comparator.isElement(o)) {
                        result.isValid = false;
                        result.errorIndex = i;
                        result.errorMessage = "Element may only include PCDATA content";
                        break;
                    }
                    ++i;
                }
            } else if (contentType == 1) {
                int size = elementContent.size();
                int i = 0;
                while (i < size) {
                    Object o = elementContent.get(i);
                    if (!comparator.isIgnorable(o)) {
                        result.isValid = false;
                        result.errorIndex = i;
                        result.errorMessage = "Element may not contain PCDATA or Element content";
                        break;
                    }
                    ++i;
                }
            }
        }
    }

    private void validatAllGroupContent(List elementContent, ElementContentComparator comparator, CMGroup allGroup, Result result) {
        boolean isValid = true;
        boolean isPartiallyValid = true;
        HashMap<CMNode, ItemCount> map = new HashMap<CMNode, ItemCount>();
        CMNodeList list = allGroup.getChildNodes();
        int j = list.getLength() - 1;
        while (j >= 0) {
            CMNode node = list.item(j);
            if (map.get(node) == null) {
                map.put(node, new ItemCount());
            }
            --j;
        }
        int validitionCount = 0;
        Iterator i = elementContent.iterator();
        while (i.hasNext()) {
            Object o = i.next();
            if (comparator.isElement(o)) {
                CMNode matchingCMNode = null;
                int j2 = list.getLength() - 1;
                while (j2 >= 0) {
                    CMNode node = list.item(j2);
                    if (comparator.matches(o, node)) {
                        matchingCMNode = node;
                        break;
                    }
                    --j2;
                }
                if (matchingCMNode == null) {
                    isPartiallyValid = false;
                    isValid = false;
                    break;
                }
                ItemCount itemCount = (ItemCount)map.get(matchingCMNode);
                if (itemCount != null) {
                    if (itemCount.count > 0) {
                        isPartiallyValid = false;
                        break;
                    }
                    ++itemCount.count;
                }
            }
            ++validitionCount;
        }
        if (isValid) {
            int j3 = list.getLength() - 1;
            while (j3 >= 0) {
                CMNode node = list.item(j3);
                if (node.getNodeType() == 5) {
                    CMContent content = (CMContent)node;
                    ItemCount itemCount = (ItemCount)map.get(node);
                    if (itemCount.count < content.getMinOccur()) {
                        isValid = false;
                        break;
                    }
                }
                --j3;
            }
        }
        if (result instanceof ElementPathRecordingResult && isPartiallyValid) {
            ((ElementPathRecordingResult)result).setPartialValidationCount(validitionCount);
        }
        result.isValid = isValid;
    }

    public void getOriginArray(CMElementDeclaration ed, List elementContent, ElementContentComparator comparator, ElementPathRecordingResult result) {
        CMNode[] cmNodeArray = null;
        this.validate(ed, elementContent, comparator, result);
        if (result.isValid) {
            CMDataType dataType = ed.getDataType();
            int size = elementContent.size();
            cmNodeArray = new CMNode[size];
            Vector originList = result.getElementOriginList();
            int originListSize = originList.size();
            int originListIndex = 0;
            int i = 0;
            while (i < size) {
                Object o = elementContent.get(i);
                if (comparator.isElement(o)) {
                    if (originListIndex < originListSize) {
                        cmNodeArray[i] = (CMNode)originList.get(originListIndex);
                        ++originListIndex;
                    }
                } else if (comparator.isPCData(o)) {
                    cmNodeArray[i] = dataType;
                }
                ++i;
            }
            result.setOriginArray(cmNodeArray);
        }
    }

    private void collectNamedArcs(GraphNode node, List namedArcList, int indent) {
        indent += 2;
        Iterator i = node.arcList.iterator();
        while (i.hasNext()) {
            Arc arc = (Arc)i.next();
            if (arc.kind == 1) {
                if (namedArcList.contains(arc)) continue;
                namedArcList.add(arc);
                this.collectNamedArcs(arc.node, namedArcList, indent + 2);
                continue;
            }
            if (arc.kind == 2 || arc.kind == 3) continue;
            this.collectNamedArcs(arc.node, namedArcList, indent + 2);
        }
    }

    private List getMatchingArcs(CMElementDeclaration ed, String elementName) {
        ArrayList<Arc> arcList = new ArrayList<Arc>();
        GraphNode graphNode = this.lookupOrCreateGraph(ed);
        if (elementName == null) {
            Iterator i = graphNode.arcList.iterator();
            while (i.hasNext()) {
                Arc arc = (Arc)i.next();
                if (arc.kind != 4) continue;
                arcList.add(arc);
                break;
            }
        } else {
            ArrayList namedArcs = new ArrayList();
            this.collectNamedArcs(graphNode, namedArcs, 0);
            Iterator i = namedArcs.iterator();
            while (i.hasNext()) {
                Arc arc = (Arc)i.next();
                if (arc.cmNode == null || !elementName.equals(arc.cmNode.getNodeName())) continue;
                arcList.add(arc);
            }
        }
        return arcList;
    }

    private void collectNextSiblings(GraphNode node, List nextSiblingList, List namedArcList, List unamedArcList, int indent) {
        indent += 2;
        Iterator i = node.arcList.iterator();
        while (i.hasNext()) {
            Arc arc = (Arc)i.next();
            if (arc.kind == 1) {
                if (namedArcList.contains(arc) || arc.cmNode == null) continue;
                nextSiblingList.add(arc.cmNode);
                if (arc.cmNode.getNodeType() != 5 && arc.cmNode.getNodeType() != 1) continue;
                namedArcList.add(arc);
                CMContent cmNode = (CMContent)arc.cmNode;
                if (cmNode.getMinOccur() != 0) continue;
                unamedArcList = new ArrayList<Arc>();
                this.collectNextSiblings(arc.node, nextSiblingList, namedArcList, unamedArcList, indent + 2);
                continue;
            }
            if (unamedArcList.contains(arc)) continue;
            unamedArcList.add(arc);
            this.collectNextSiblings(arc.node, nextSiblingList, namedArcList, unamedArcList, indent + 2);
        }
    }

    public CMNode[] getNextSiblings(CMElementDeclaration ed, String elementName) {
        List arcList = this.getMatchingArcs(ed, elementName);
        ArrayList nextSiblingList = new ArrayList();
        Iterator i = arcList.iterator();
        while (i.hasNext()) {
            Arc arc = (Arc)i.next();
            this.collectNextSiblings(arc.node, nextSiblingList, new ArrayList(), new ArrayList(), 0);
        }
        CMNode[] result = new CMNode[nextSiblingList.size()];
        nextSiblingList.toArray(result);
        return result;
    }

    public static List createStringList(String[] arg, int startIndex) {
        Vector<String> v = new Vector<String>();
        int i = startIndex;
        while (i < arg.length) {
            v.add(arg[i]);
            ++i;
        }
        return v;
    }

    protected static class Arc {
        public static final int ELEMENT = 1;
        public static final int REPEAT = 2;
        public static final int OPTIONAL = 3;
        public static final int PREV_IN = 4;
        public static final int OUT_NEXT = 5;
        public static final int LINK = 6;
        public int kind;
        public String name;
        public GraphNode node;
        public CMNode cmNode;

        public Arc(int kind, GraphNode node, CMNode cmNode) {
            this(kind, "", node, cmNode);
        }

        protected Arc(int kind, String name, GraphNode node, CMNode cmNode) {
            this.name = name;
            this.kind = kind;
            this.node = node;
            this.cmNode = cmNode;
        }
    }

    private class ArcStackItem {
        Arc arc;
        boolean loopFlag;
        boolean isVisited;

        public ArcStackItem(Arc arc, boolean loopflag) {
            this.arc = arc;
            this.loopFlag = loopflag;
            this.isVisited = arc == null;
        }
    }

    public static interface ElementContentComparator {
        public boolean isIgnorable(Object var1);

        public boolean isPCData(Object var1);

        public boolean isElement(Object var1);

        public boolean matches(Object var1, CMNode var2);
    }

    public static class ElementList {
        protected Object head;
        protected ElementList tail;

        public static ElementList create(List v) {
            ElementList first = null;
            ElementList prev = null;
            Iterator iterator = v.iterator();
            while (iterator.hasNext()) {
                Object o = iterator.next();
                if (o == null) continue;
                ElementList list = new ElementList();
                list.head = o;
                if (prev != null) {
                    prev.tail = list;
                } else {
                    first = list;
                }
                prev = list;
            }
            return first;
        }

        public String toString() {
            String string = "[" + this.head + "],";
            if (this.tail != null) {
                string = String.valueOf(string) + this.tail.toString();
            }
            return string;
        }
    }

    public static class ElementPathRecordingResult
    extends Result {
        protected List activeItemCountList = new ArrayList();
        protected List inactiveItemCountList = new ArrayList();
        protected Vector elementOriginStack = new Vector();
        protected CMNode[] originArray = null;
        protected int partialValidationCount = 0;

        public boolean canPush(Arc arc) {
            boolean result = true;
            try {
                CMContent content;
                if (arc.kind == 2 && arc.cmNode instanceof CMContent && (content = (CMContent)arc.cmNode).getMaxOccur() > 1) {
                    ItemCount itemCount = (ItemCount)this.activeItemCountList.get(this.activeItemCountList.size() - 1);
                    if (itemCount.count + 1 >= content.getMaxOccur()) {
                        result = false;
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return result;
        }

        public void push(Arc arc) {
            if (arc.kind == 1) {
                this.elementOriginStack.add(arc.cmNode);
                this.partialValidationCount = Math.max(this.elementOriginStack.size(), this.partialValidationCount);
            } else if (arc.kind == 4) {
                this.activeItemCountList.add(new ItemCount());
            } else if (arc.kind == 5) {
                int size = this.activeItemCountList.size();
                ItemCount itemCount = (ItemCount)this.activeItemCountList.get(size - 1);
                this.activeItemCountList.remove(size - 1);
                this.inactiveItemCountList.add(itemCount);
            } else if (arc.kind == 2) {
                ItemCount itemCount = (ItemCount)this.activeItemCountList.get(this.activeItemCountList.size() - 1);
                ++itemCount.count;
            }
        }

        public void pop(Arc arc) {
            if (arc.kind == 1) {
                int size = this.elementOriginStack.size();
                this.elementOriginStack.remove(size - 1);
            } else if (arc.kind == 4) {
                this.activeItemCountList.remove(this.activeItemCountList.size() - 1);
            } else if (arc.kind == 5) {
                int size = this.inactiveItemCountList.size();
                ItemCount itemCount = (ItemCount)this.inactiveItemCountList.get(size - 1);
                this.inactiveItemCountList.remove(size - 1);
                this.activeItemCountList.add(itemCount);
            } else if (arc.kind == 2) {
                ItemCount itemCount = (ItemCount)this.activeItemCountList.get(this.activeItemCountList.size() - 1);
                --itemCount.count;
            }
        }

        public Vector getElementOriginList() {
            return this.elementOriginStack;
        }

        public CMNode[] getOriginArray() {
            return this.originArray;
        }

        public void setOriginArray(CMNode[] originArray) {
            this.originArray = originArray;
        }

        public int getPartialValidationCount() {
            return this.partialValidationCount;
        }

        public void setPartialValidationCount(int partialValidationCount) {
            this.partialValidationCount = partialValidationCount;
        }
    }

    protected static class GraphGenerator
    extends CMVisitor {
        public int indent;
        public int count;
        public GraphNode startGraphNode = new GraphNode(this.getGraphNodeName());
        public Context context = new Context(this.startGraphNode, null);

        protected GraphGenerator() {
        }

        protected void generateGraph(CMElementDeclaration ed) {
            int contentType = ed.getContentType();
            if (contentType == 3 || contentType == 2) {
                this.visitCMNode(ed.getContent());
            }
            this.context.getLastGraphNode().isTerminal = true;
        }

        protected String getGraphNodeName() {
            return "n" + this.count++;
        }

        protected GraphNode getStartGraphNode() {
            return this.startGraphNode;
        }

        protected void createArcs(GraphNode in, GraphNode out, CMContent cmContent) {
            this.createArcs(in, out, cmContent, false);
        }

        protected void createArcs(GraphNode in, GraphNode out, CMContent cmContent, boolean isAllGroup) {
            GraphNode prev = this.context.from;
            GraphNode next = new GraphNode(this.getGraphNodeName());
            prev.addArc(new Arc(4, in, cmContent));
            out.addArc(new Arc(5, next, cmContent));
            if (this.context.to != null) {
                next.addArc(new Arc(6, this.context.to, cmContent));
            } else {
                this.context.from = next;
            }
            if (cmContent.getMinOccur() == 0) {
                prev.addArc(new Arc(3, next, cmContent));
            }
            if (cmContent.getMaxOccur() == -1 || cmContent.getMaxOccur() > 1 || isAllGroup) {
                out.addArc(new Arc(2, in, cmContent));
            }
        }

        public void visitCMGroup(CMGroup group) {
            Context prevContext = this.context;
            GraphNode in = new GraphNode("(" + this.getGraphNodeName());
            GraphNode out = new GraphNode(")" + this.getGraphNodeName());
            int groupOperator = group.getOperator();
            if (groupOperator == 1) {
                this.context = new Context(in, null);
                super.visitCMGroup(group);
                this.context.from.addArc(new Arc(6, out, group));
            } else if (groupOperator == 2 || groupOperator == 3) {
                this.context = new Context(in, out);
                super.visitCMGroup(group);
            }
            this.context = prevContext;
            this.createArcs(in, out, group, groupOperator == 3);
        }

        public void visitCMElementDeclaration(CMElementDeclaration ed) {
            GraphNode in = new GraphNode(this.getGraphNodeName());
            GraphNode out = new GraphNode(this.getGraphNodeName());
            this.createArcs(in, out, ed);
            in.addArc(new Arc(1, ed.getElementName(), out, ed));
        }

        public void visitCMAnyElement(CMAnyElement anyElement) {
            GraphNode in = new GraphNode(this.getGraphNodeName());
            GraphNode out = new GraphNode(this.getGraphNodeName());
            this.createArcs(in, out, anyElement);
            in.addArc(new Arc(1, "any", out, anyElement));
        }

        protected static class Context {
            GraphNode from;
            GraphNode to;

            Context(GraphNode from, GraphNode to) {
                this.from = from;
                this.to = to;
            }

            GraphNode getLastGraphNode() {
                return this.to != null ? this.to : this.from;
            }
        }
    }

    protected static class GraphNode {
        public String name;
        public boolean isTerminal;
        public Vector arcList = new Vector();

        public GraphNode(String name) {
            this.name = name;
        }

        public void addArc(Arc arc) {
            this.arcList.addElement(arc);
        }

        public String toString() {
            return "[GraphNode " + this.name + "]";
        }
    }

    static class ItemCount {
        int count = 0;

        ItemCount() {
        }
    }

    public static class MatchModelNode {
        public CMNode cmNode;
        public List children = new Vector();
        public Object data;

        public MatchModelNode(MatchModelNode parent, CMNode cmNode) {
            this.cmNode = cmNode;
        }

        public void printModel(int indent) {
            Iterator iterator = this.children.iterator();
            while (iterator.hasNext()) {
                MatchModelNode child = (MatchModelNode)iterator.next();
                child.printModel(indent + 2);
            }
        }
    }

    public static class MatchModelNodeBuilder {
        protected List arcList;
        protected List stack = new Vector();
        protected MatchModelNode root;
        protected MatchModelNode current;

        public MatchModelNodeBuilder(List arcList) {
            this.arcList = arcList;
            this.root = new MatchModelNode(null, null);
            this.push(this.root);
        }

        protected void push(MatchModelNode node) {
            this.current = node;
            this.stack.add(node);
        }

        protected void pop() {
            int size = this.stack.size();
            this.stack.remove(size - 1);
            this.current = (MatchModelNode)this.stack.get(size - 2);
        }

        public boolean isCMGroup(CMNode cmNode) {
            return cmNode != null && cmNode.getNodeType() == 7;
        }

        public void buildMatchModel() {
            Iterator iterator = this.arcList.iterator();
            while (iterator.hasNext()) {
                MatchModelNode newModelNode;
                Arc arc = (Arc)iterator.next();
                if (arc.kind == 1) {
                    this.current.children.add(new MatchModelNode(this.current, arc.cmNode));
                    continue;
                }
                if (arc.kind == 4) {
                    if (!this.isCMGroup(arc.cmNode)) continue;
                    newModelNode = new MatchModelNode(this.current, arc.cmNode);
                    this.current.children.add(newModelNode);
                    this.push(newModelNode);
                    continue;
                }
                if (arc.kind == 5) {
                    if (!this.isCMGroup(arc.cmNode)) continue;
                    this.pop();
                    continue;
                }
                if (arc.kind != 2 || !this.isCMGroup(arc.cmNode)) continue;
                this.pop();
                newModelNode = new MatchModelNode(this.current, arc.cmNode);
                this.current.children.add(newModelNode);
                this.push(newModelNode);
            }
        }

        public MatchModelNode getRoot() {
            return this.root;
        }
    }

    public static class PathRecordingResult
    extends Result {
        protected Vector arcList = new Vector();

        public void push(Arc arc) {
            this.arcList.add(arc);
        }

        public void pop(Arc arc) {
            int size = this.arcList.size();
            this.arcList.remove(size - 1);
        }

        public List getArcList() {
            Vector<Arc> list = new Vector<Arc>();
            Iterator iterator = this.arcList.iterator();
            while (iterator.hasNext()) {
                Arc arc = (Arc)iterator.next();
                if (arc.kind != 1) continue;
                list.add(arc);
            }
            return list;
        }

        public MatchModelNode getMatchModel() {
            MatchModelNodeBuilder builder = new MatchModelNodeBuilder(this.arcList);
            builder.buildMatchModel();
            return builder.getRoot();
        }
    }

    public static class Result {
        public boolean isValid = true;
        public int errorIndex = -1;
        public String errorMessage;
        public boolean isRepeatTraversed;

        public boolean canPush(Arc arc) {
            return true;
        }

        public void push(Arc arc) {
        }

        public void pop(Arc arc) {
        }

        public CMNode[] getOriginArray() {
            return null;
        }
    }

    public static class StringElementContentComparator
    implements ElementContentComparator {
        public boolean isIgnorable(Object o) {
            String string = o.toString();
            return string.startsWith("!") || string.startsWith("?");
        }

        public boolean isPCData(Object o) {
            String string = o.toString();
            return string.startsWith("'") || string.startsWith("\"");
        }

        public boolean isElement(Object o) {
            return !this.isIgnorable(o) && !this.isPCData(o);
        }

        public boolean matches(Object o, CMNode cmNode) {
            boolean result = false;
            if (cmNode.getNodeType() == 5) {
                int cmNodeListLength;
                CMNodeList cmNodeList;
                CMElementDeclaration element = (CMElementDeclaration)cmNode;
                String name = o.toString();
                int index = name.indexOf("]");
                if (index != -1) {
                    name = name.substring(index + 1);
                }
                if (!(result = name.equalsIgnoreCase(element.getElementName())) && (cmNodeList = (CMNodeList)element.getProperty("SubstitutionGroup")) != null && (cmNodeListLength = cmNodeList.getLength()) > 1) {
                    int i = 0;
                    while (i < cmNodeListLength) {
                        CMElementDeclaration alternativeCMElementDeclaration = (CMElementDeclaration)cmNodeList.item(i);
                        String altName = alternativeCMElementDeclaration.getElementName();
                        result = name.equalsIgnoreCase(altName);
                        if (!result) {
                            ++i;
                            continue;
                        }
                        break;
                    }
                }
            } else if (cmNode.getNodeType() == 1) {
                String string = o.toString();
                if (string.equals("*")) {
                    result = true;
                } else {
                    CMAnyElement anyElement = (CMAnyElement)cmNode;
                    String anyElementURI = anyElement.getNamespaceURI();
                    if (anyElementURI != null) {
                        if (anyElementURI.equals("##any")) {
                            result = true;
                        } else if (anyElementURI.equals("##other")) {
                            String specifiedURI;
                            String excludedURI;
                            result = true;
                            CMDocument cmDocument = (CMDocument)anyElement.getProperty("CMDocument");
                            if (cmDocument != null && (excludedURI = (String)cmDocument.getProperty("http://org.eclipse.wst/cm/properties/targetNamespaceURI")) != null && (specifiedURI = this.getURIForContentSpecification(string)) != null && excludedURI.equals(specifiedURI)) {
                                result = false;
                            }
                        } else if (anyElementURI.equals("##targetNamespace")) {
                            result = true;
                            CMDocument cmDocument = (CMDocument)anyElement.getProperty("CMDocument");
                            if (cmDocument != null) {
                                String targetNamespaceURI = (String)cmDocument.getProperty("http://org.eclipse.wst/cm/properties/targetNamespaceURI");
                                String specifiedURI = this.getURIForContentSpecification(string);
                                if (specifiedURI != null && !targetNamespaceURI.equals(specifiedURI)) {
                                    result = false;
                                }
                            }
                        } else {
                            result = true;
                            String specifiedURI = this.getURIForContentSpecification(string);
                            if (specifiedURI != null && !anyElementURI.equals(specifiedURI)) {
                                result = false;
                            }
                        }
                    } else {
                        result = true;
                    }
                }
            }
            return result;
        }

        protected String getURIForContentSpecification(String specification) {
            String result = null;
            int index = specification.indexOf("]");
            if (index != -1) {
                result = specification.substring(1, index);
            }
            return result;
        }
    }
}

