/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.editor;

import java.net.URI;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.wst.common.uriresolver.internal.util.URIHelper;
import org.eclipse.wst.xml.ui.internal.Logger;
import org.eclipse.wst.xsd.ui.internal.adt.editor.ADTReadOnlyFileEditorInput;
import org.eclipse.wst.xsd.ui.internal.adt.editor.Messages;
import org.eclipse.wst.xsd.ui.internal.editor.InternalXSDMultiPageEditor;
import org.eclipse.xsd.XSDConcreteComponent;
import org.eclipse.xsd.XSDSchema;

public class XSDHyperlink
implements IHyperlink {
    private IRegion fRegion;
    private XSDConcreteComponent fComponent;

    public XSDHyperlink(IRegion region, XSDConcreteComponent component) {
        this.fRegion = region;
        this.fComponent = component;
    }

    public IRegion getHyperlinkRegion() {
        return this.fRegion;
    }

    public String getTypeLabel() {
        return null;
    }

    public String getHyperlinkText() {
        return Messages._UI_ACTION_SET_AS_FOCUS;
    }

    public void open() {
        IWorkbenchWindow workbenchWindow;
        XSDSchema schema = this.fComponent.getSchema();
        if (schema == null) {
            return;
        }
        String schemaLocation = schema.getSchemaLocation();
        IFile schemaFile = null;
        URI schemaUri = null;
        if (URIHelper.isPlatformResourceProtocol((String)schemaLocation)) {
            Path schemaPath = new Path(URIHelper.removePlatformResourceProtocol((String)schemaLocation));
            schemaFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)schemaPath);
            if (!schemaFile.exists()) {
                return;
            }
        } else {
            try {
                schemaUri = new URI(schemaLocation);
            }
            catch (Exception exception) {}
        }
        if ((workbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow()) != null) {
            IWorkbenchPage workbenchPage = workbenchWindow.getActivePage();
            IEditorPart editorPart = workbenchPage.getActiveEditor();
            workbenchPage.getNavigationHistory().markLocation(editorPart);
            try {
                if (schemaFile != null) {
                    editorPart = IDE.openEditor((IWorkbenchPage)workbenchPage, (IFile)schemaFile, (boolean)true);
                } else if (schemaUri != null && "file".equals(schemaUri.getScheme())) {
                    editorPart = IDE.openEditor((IWorkbenchPage)workbenchPage, (URI)schemaUri, (String)"org.eclipse.wst.xsd.ui.internal.editor.InternalXSDMultiPageEditor", (boolean)true);
                } else {
                    ADTReadOnlyFileEditorInput input = new ADTReadOnlyFileEditorInput(schemaLocation);
                    editorPart = IDE.openEditor((IWorkbenchPage)workbenchPage, (IEditorInput)input, (String)"org.eclipse.wst.xsd.ui.internal.editor.InternalXSDMultiPageEditor", (boolean)true);
                }
                if (editorPart instanceof InternalXSDMultiPageEditor) {
                    ((InternalXSDMultiPageEditor)editorPart).openOnGlobalReference(this.fComponent);
                }
            }
            catch (PartInitException pie) {
                Logger.log((int)202, (String)pie.getMessage(), (Throwable)pie);
            }
        }
    }
}

