/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.editor;

import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.wst.common.ui.internal.search.dialogs.ComponentSpecification;
import org.eclipse.wst.xsd.ui.internal.common.commands.AddXSDElementCommand;
import org.eclipse.wst.xsd.ui.internal.common.commands.BaseCommand;
import org.eclipse.wst.xsd.ui.internal.common.commands.UpdateAttributeValueCommand;
import org.eclipse.wst.xsd.ui.internal.common.util.XSDDirectivesManager;
import org.eclipse.wst.xsd.ui.internal.editor.Messages;
import org.eclipse.wst.xsd.ui.internal.editor.XSDElementReferenceEditManager;
import org.eclipse.wst.xsd.ui.internal.search.IXSDSearchConstants;
import org.eclipse.xsd.XSDConcreteComponent;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDSchema;

public class XSDSubstitutionGroupEditManager
extends XSDElementReferenceEditManager {
    public XSDSubstitutionGroupEditManager(IFile currentFile, XSDSchema[] schemas) {
        super(currentFile, schemas);
    }

    public void modifyComponentReference(Object referencingObject, ComponentSpecification component) {
        XSDElementDeclaration concreteComponent = null;
        if (referencingObject instanceof Adapter) {
            Adapter adapter = (Adapter)referencingObject;
            if (adapter.getTarget() instanceof XSDElementDeclaration) {
                concreteComponent = (XSDElementDeclaration)adapter.getTarget();
            }
        } else if (referencingObject instanceof XSDConcreteComponent) {
            concreteComponent = (XSDElementDeclaration)referencingObject;
        }
        if (concreteComponent != null) {
            if (component.isNew()) {
                BaseCommand command;
                XSDElementDeclaration elementDec = null;
                if (component.getMetaName() == IXSDSearchConstants.ELEMENT_META_NAME) {
                    command = new AddXSDElementCommand(Messages._UI_ACTION_ADD_ELEMENT, concreteComponent.getSchema());
                    command.setNameToAdd(component.getName());
                    command.execute();
                    elementDec = (XSDElementDeclaration)command.getAddedComponent();
                }
                if (elementDec != null) {
                    command = new UpdateAttributeValueCommand(concreteComponent.getElement(), "substitutionGroup", elementDec.getQName((XSDConcreteComponent)concreteComponent.getSchema()), org.eclipse.wst.xsd.ui.internal.common.util.Messages._UI_LABEL_SUBSTITUTION_GROUP);
                    command.execute();
                }
            } else {
                UpdateAttributeValueCommand command = new UpdateAttributeValueCommand(concreteComponent.getElement(), "substitutionGroup", ((XSDElementDeclaration)component.getObject()).getQName((XSDConcreteComponent)concreteComponent.getSchema()), org.eclipse.wst.xsd.ui.internal.common.util.Messages._UI_LABEL_SUBSTITUTION_GROUP);
                command.execute();
            }
            XSDDirectivesManager.removeUnusedXSDImports(concreteComponent.getSchema());
        }
    }
}

