/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.plugin;

import java.util.HashSet;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.pde.core.plugin.IPluginLibrary;
import org.eclipse.pde.internal.core.ClasspathUtilCore;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.SelectionStatusDialog;

public class NewRuntimeLibraryDialog
extends SelectionStatusDialog {
    private Text libraryText;
    private IPluginLibrary[] libraries;
    private DuplicateStatusValidator validator;
    private String libraryName;
    private HashSet librarySet;

    public NewRuntimeLibraryDialog(Shell parent, IPluginLibrary[] libraries) {
        super(parent);
        this.libraries = libraries;
        this.validator = new DuplicateStatusValidator();
        this.librarySet = new HashSet();
        int i = 0;
        while (i < libraries.length) {
            this.librarySet.add(new Path(ClasspathUtilCore.expandLibraryName((String)libraries[i].getName())));
            ++i;
        }
        this.setStatusLineAboveButtons(true);
    }

    protected void computeResult() {
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)shell, "org.eclipse.pde.doc.user.new_library");
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 8;
        layout.marginHeight = 8;
        layout.numColumns = 1;
        layout.makeColumnsEqualWidth = false;
        container.setLayout((Layout)layout);
        GridData gd = new GridData(1808);
        container.setLayoutData((Object)gd);
        Label libraryLabel = new Label(container, 0);
        gd = new GridData(768);
        libraryLabel.setLayoutData((Object)gd);
        libraryLabel.setText(PDEUIMessages.ManifestEditor_RuntimeLibraryDialog_label);
        this.libraryText = new Text(container, 2052);
        gd = new GridData(768);
        this.libraryText.setLayoutData((Object)gd);
        this.libraryText.setText(PDEUIMessages.ManifestEditor_RuntimeLibraryDialog_default);
        this.libraryText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewRuntimeLibraryDialog.this.updateStatus(NewRuntimeLibraryDialog.this.validator.validate(NewRuntimeLibraryDialog.this.libraryText.getText()));
            }
        });
        NewRuntimeLibraryDialog.applyDialogFont((Control)container);
        return container;
    }

    public int open() {
        this.libraryText.setText("library.jar");
        this.libraryText.setSelection(0, this.libraryText.getText().length() - 4);
        return super.open();
    }

    public String getLibraryName() {
        return this.libraryName;
    }

    protected void okPressed() {
        this.libraryName = this.libraryText.getText();
        super.okPressed();
    }

    class DuplicateStatusValidator {
        DuplicateStatusValidator() {
        }

        public IStatus validate(String text) {
            String id = PDEPlugin.getPluginId();
            if (text.length() == 0) {
                return new Status(4, id, 4, PDEUIMessages.AddLibraryDialog_emptyLibraries, null);
            }
            if (text.indexOf(32) != -1) {
                return new Status(4, id, 4, PDEUIMessages.AddLibraryDialog_nospaces, null);
            }
            if (NewRuntimeLibraryDialog.this.libraries == null || NewRuntimeLibraryDialog.this.libraries.length == 0) {
                return new Status(0, id, 0, "", null);
            }
            if (NewRuntimeLibraryDialog.this.librarySet.contains(new Path(ClasspathUtilCore.expandLibraryName((String)text)))) {
                return new Status(4, id, 4, PDEUIMessages.ManifestEditor_RuntimeLibraryDialog_validationError, null);
            }
            return new Status(0, id, 0, "", null);
        }
    }
}

