/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.launcher;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.pde.internal.ui.SWTFactory;
import org.eclipse.pde.internal.ui.launcher.FeatureBlock;
import org.eclipse.pde.internal.ui.launcher.PluginBlock;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class BlockAdapter {
    private PluginBlock fPluginBlock;
    private FeatureBlock fFeatureBlock;
    private StackLayout fLayout;
    private Composite fPluginBlockComposite;
    private Composite fFeatureBlockComposite;
    private Composite fParent;
    private ILaunchConfiguration fLaunchConfig;
    private int fActiveIndex;
    private static final int CUSTOM_SELECTION = 1;
    private static final int CUSTOM_FEATURES_SELECTION = 2;

    public BlockAdapter(PluginBlock pluginBlock, FeatureBlock featureBlock) {
        Assert.isNotNull((Object)pluginBlock);
        Assert.isNotNull((Object)featureBlock);
        this.fPluginBlock = pluginBlock;
        this.fFeatureBlock = featureBlock;
    }

    public void createControl(Composite parent, int span, int indent) {
        this.fLayout = new StackLayout();
        parent.setLayout((Layout)this.fLayout);
        this.fLayout.topControl = this.fPluginBlockComposite;
        this.fParent = parent;
    }

    public void initializeFrom(ILaunchConfiguration config, boolean enableTable) throws CoreException {
        this.fLaunchConfig = config;
        if (this.fActiveIndex == 2) {
            this.fFeatureBlock.initializeFrom(config);
        } else {
            this.fPluginBlock.initializeFrom(config, enableTable);
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy config) {
        if (this.fActiveIndex == 2) {
            this.fFeatureBlock.performApply(config);
        } else {
            this.fPluginBlock.performApply(config);
        }
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy config) {
        if (this.fActiveIndex == 2) {
            this.fFeatureBlock.setDefaults(config);
        } else {
            this.fPluginBlock.setDefaults(config);
        }
    }

    public void enableViewer(boolean enable) {
    }

    public void dispose() {
        this.fPluginBlock.dispose();
        this.fFeatureBlock.dispose();
    }

    public void initialize(boolean enable) throws CoreException {
        if (this.fActiveIndex == 2) {
            this.fFeatureBlock.initialize();
        } else {
            this.fPluginBlock.initialize(enable);
        }
    }

    public void setActiveBlock(int index) throws CoreException {
        this.fActiveIndex = index;
        if (index == 2) {
            if (this.fFeatureBlockComposite == null) {
                this.fFeatureBlockComposite = SWTFactory.createComposite(this.fParent, 7, 1, 1808, 0, 0);
                this.fFeatureBlock.createControl(this.fFeatureBlockComposite, 7, 10);
                if (this.fLaunchConfig != null) {
                    this.fFeatureBlock.initializeFrom(this.fLaunchConfig);
                }
            }
            this.fLayout.topControl = this.fFeatureBlockComposite;
            return;
        }
        if (this.fPluginBlockComposite == null) {
            this.fPluginBlockComposite = SWTFactory.createComposite(this.fParent, 7, 1, 1808, 0, 0);
            this.fPluginBlock.createControl(this.fPluginBlockComposite, 7, 10);
            if (this.fLaunchConfig != null) {
                this.fPluginBlock.initializeFrom(this.fLaunchConfig, this.fActiveIndex == 1);
            }
        }
        this.fLayout.topControl = this.fPluginBlockComposite;
    }
}

