/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.releng.tools;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.releng.tools.LoadMap;
import org.eclipse.releng.tools.RelEngPlugin;
import org.eclipse.releng.tools.RepositorySelectionDialog;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSProviderPlugin;
import org.eclipse.team.internal.ccvs.core.CVSTag;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteFolder;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteResource;
import org.eclipse.team.internal.ccvs.core.ICVSRepositoryLocation;
import org.eclipse.team.internal.ccvs.core.connection.CVSRepositoryLocation;
import org.eclipse.team.internal.ccvs.ui.CVSUIPlugin;
import org.eclipse.team.internal.ccvs.ui.actions.TagInRepositoryAction;

public class TagMap
extends TagInRepositoryAction {
    protected ICVSRemoteResource[] getSelectedRemoteResources() {
        IResource[] resources = this.getSelectedResources();
        ArrayList<String> identifiers = new ArrayList<String>();
        int i = 0;
        while (i < resources.length) {
            IResource resource = resources[i];
            try {
                String[] strings = LoadMap.readReferenceStrings((IFile)resource);
                identifiers.addAll(Arrays.asList(strings));
            }
            catch (CoreException e) {
                RelEngPlugin.log(e);
            }
            ++i;
        }
        return this.getCVSResourcesFor(identifiers.toArray(new String[identifiers.size()]));
    }

    private ICVSRemoteResource[] getCVSResourcesFor(String[] referenceStrings) {
        HashMap<ICVSRepositoryLocation, ICVSRepositoryLocation> previouslySelectedRepositories = new HashMap<ICVSRepositoryLocation, ICVSRepositoryLocation>();
        int size = referenceStrings.length;
        ArrayList<ICVSRemoteFolder> result = new ArrayList<ICVSRemoteFolder>(size);
        int i = 0;
        while (i < size) {
            StringTokenizer tokenizer = new StringTokenizer(referenceStrings[i], ",");
            String version = tokenizer.nextToken();
            if (!version.equals("1.0")) {
                return null;
            }
            try {
                String repo = tokenizer.nextToken();
                ICVSRepositoryLocation storedlocation = this.getLocationFromString(repo);
                ICVSRepositoryLocation location = (ICVSRepositoryLocation)previouslySelectedRepositories.get(storedlocation);
                if (location == null) {
                    location = this.getWritableRepositoryLocation(storedlocation);
                    previouslySelectedRepositories.put(storedlocation, location);
                    if (location == null) {
                        return new ICVSRemoteResource[0];
                    }
                }
                String module = tokenizer.nextToken();
                tokenizer.nextToken();
                CVSTag tag = CVSTag.DEFAULT;
                if (tokenizer.hasMoreTokens()) {
                    String tagName = tokenizer.nextToken();
                    tag = new CVSTag(tagName, 2);
                }
                result.add(location.getRemoteFolder(module, tag));
            }
            catch (CVSException e) {
                RelEngPlugin.log((CoreException)((Object)e));
            }
            ++i;
        }
        return result.toArray(new ICVSRemoteResource[result.size()]);
    }

    private ICVSRepositoryLocation getLocationFromString(String repo) throws CVSException {
        CVSRepositoryLocation newLocation = CVSRepositoryLocation.fromString((String)repo);
        if (newLocation.getUsername() == null || newLocation.getUsername().length() == 0) {
            ICVSRepositoryLocation[] locations = CVSProviderPlugin.getPlugin().getKnownRepositories();
            int i = 0;
            while (i < locations.length) {
                ICVSRepositoryLocation location = locations[i];
                if (location.getMethod() == newLocation.getMethod() && location.getHost().equals(newLocation.getHost()) && location.getPort() == newLocation.getPort() && location.getRootDirectory().equals(newLocation.getRootDirectory())) {
                    return location;
                }
                ++i;
            }
        }
        return newLocation;
    }

    private ICVSRepositoryLocation getWritableRepositoryLocation(ICVSRepositoryLocation storedLocation) {
        ICVSRepositoryLocation location;
        ICVSRepositoryLocation[] locations = CVSUIPlugin.getPlugin().getRepositoryManager().getKnownRepositoryLocations();
        ArrayList<ICVSRepositoryLocation> compatibleLocations = new ArrayList<ICVSRepositoryLocation>();
        int i = 0;
        while (i < locations.length) {
            location = locations[i];
            if (location.getHost().equals(storedLocation.getHost()) && location.getRootDirectory().equals(storedLocation.getRootDirectory())) {
                compatibleLocations.add(location);
            }
            ++i;
        }
        RepositorySelectionDialog dialog = new RepositorySelectionDialog(this.getShell());
        dialog.setLocations(compatibleLocations.toArray(new ICVSRepositoryLocation[compatibleLocations.size()]));
        dialog.open();
        location = dialog.getLocation();
        return location;
    }

    public boolean isEnabled() {
        IResource[] resources = this.getSelectedResources();
        if (resources.length == 0) {
            return false;
        }
        int i = 0;
        while (i < resources.length) {
            IResource resource = resources[i];
            if (resource.getType() != 1) {
                return false;
            }
            if (!resource.getFileExtension().equals("map")) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

