/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.workbench.ui.internal;

import java.util.List;
import org.eclipse.core.commands.contexts.ContextManager;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.e4.core.commands.EHandlerService;
import org.eclipse.e4.core.contexts.ContextChangeEvent;
import org.eclipse.e4.core.contexts.ContextFunction;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.EclipseContextFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.contexts.IRunAndTrack;
import org.eclipse.e4.core.services.contributions.IContributionFactory;
import org.eclipse.e4.core.services.log.Logger;
import org.eclipse.e4.ui.internal.services.ActiveContextsFunction;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.MApplicationElement;
import org.eclipse.e4.ui.model.application.MBindingContainer;
import org.eclipse.e4.ui.model.application.MBindings;
import org.eclipse.e4.ui.model.application.MCommand;
import org.eclipse.e4.ui.model.application.MContext;
import org.eclipse.e4.ui.model.application.MElementContainer;
import org.eclipse.e4.ui.model.application.MHandler;
import org.eclipse.e4.ui.model.application.MHandlerContainer;
import org.eclipse.e4.ui.model.application.MPart;
import org.eclipse.e4.ui.model.application.MUIElement;
import org.eclipse.e4.ui.services.EContextService;
import org.eclipse.e4.ui.services.IStylingEngine;
import org.eclipse.e4.workbench.ui.IExceptionHandler;
import org.eclipse.e4.workbench.ui.IPresentationEngine;
import org.eclipse.e4.workbench.ui.IWorkbench;
import org.eclipse.e4.workbench.ui.internal.Activator;
import org.eclipse.e4.workbench.ui.internal.ActiveChildLookupFunction;
import org.eclipse.e4.workbench.ui.internal.ActivePartLookupFunction;
import org.eclipse.e4.workbench.ui.internal.E4CommandProcessor;
import org.eclipse.e4.workbench.ui.internal.UIEventPublisher;
import org.eclipse.e4.workbench.ui.internal.WorkbenchLogger;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.osgi.framework.BundleContext;

public class E4Workbench
implements IWorkbench {
    public static final String LOCAL_ACTIVE_SHELL = "localActiveShell";
    public static final String XMI_URI_ARG = "applicationXMI";
    public static final String CSS_URI_ARG = "applicationCSS";
    public static final String CSS_RESOURCE_URI_ARG = "applicationCSSResources";
    public static final String PRESENTATION_URI_ARG = "presentationURI";
    public static final String LIFE_CYCLE_URI_ARG = "lifeCycleURI";
    IEclipseContext appContext;
    IPresentationEngine renderer;
    MApplication appModel = null;

    public IEclipseContext getContext() {
        return this.appContext;
    }

    public E4Workbench(MApplicationElement uiRoot, IEclipseContext applicationContext) {
        this.appContext = applicationContext;
        this.appContext.set(IWorkbench.class.getName(), (Object)this);
        if (uiRoot instanceof MApplication) {
            this.appModel = (MApplication)uiRoot;
        }
        if (uiRoot instanceof MApplication) {
            this.init((MApplication)uiRoot);
        }
        ((Notifier)uiRoot).eAdapters().add((Object)new UIEventPublisher(this.appContext));
    }

    public void createAndRunUI(MApplicationElement uiRoot) {
        this.renderer = (IPresentationEngine)this.appContext.get(IPresentationEngine.class.getName());
        if (this.renderer == null) {
            String presentationURI = (String)this.appContext.get(PRESENTATION_URI_ARG);
            if (presentationURI != null) {
                IContributionFactory factory = (IContributionFactory)this.appContext.get(IContributionFactory.class.getName());
                this.renderer = (IPresentationEngine)factory.create(presentationURI, this.appContext);
                this.appContext.set(IPresentationEngine.class.getName(), (Object)this.renderer);
            }
            if (this.renderer == null) {
                Logger logger = (Logger)this.appContext.get(Logger.class.getName());
                logger.error("Failed to create the presentation engine for URI: " + presentationURI);
            }
        }
        if (this.renderer != null) {
            this.renderer.run(uiRoot, this.appContext);
        }
    }

    private void init(MApplication appElement) {
        Activator.trace("/trace/workbench", "init() workbench", null);
        E4CommandProcessor.processCommands(appElement.getContext(), (List<MCommand>)appElement.getCommands());
        E4CommandProcessor.processBindings(appElement.getContext(), (MBindingContainer)appElement);
        E4Workbench.processHierarchy(appElement);
    }

    public boolean close() {
        if (this.renderer != null) {
            this.renderer.stop();
        }
        return true;
    }

    public int run() {
        return 0;
    }

    public static IEclipseContext getServiceContext() {
        return EclipseContextFactory.getServiceContext((BundleContext)Activator.getDefault().getContext());
    }

    public MApplication getApplication() {
        return this.appModel;
    }

    public static IEclipseContext createWorkbenchContext(final IEclipseContext applicationContext, IExtensionRegistry registry, IExceptionHandler exceptionHandler, IContributionFactory contributionFactory) {
        Activator.trace("/trace/eclipse.context", "createWorkbenchContext: initialize the workbench context with needed services", null);
        final IEclipseContext mainContext = EclipseContextFactory.create((IEclipseContext)applicationContext, null);
        mainContext.set(Logger.class.getName(), ContextInjectionFactory.inject((Object)((Object)new WorkbenchLogger()), (IEclipseContext)mainContext));
        mainContext.set("debugString", (Object)"WorkbenchContext");
        if (contributionFactory != null) {
            mainContext.set(IContributionFactory.class.getName(), (Object)contributionFactory);
        }
        mainContext.set(ContextManager.class.getName(), (Object)new ContextManager());
        mainContext.set("activeContexts", (Object)new ActiveContextsFunction());
        mainContext.set("e4ActivePart", (Object)new ActivePartLookupFunction());
        mainContext.runAndTrack(new IRunAndTrack(){

            public boolean notify(ContextChangeEvent event) {
                Object o = mainContext.get("e4ActivePart");
                if (o instanceof MPart) {
                    mainContext.set("activePartId", (Object)((MPart)o).getId());
                }
                return true;
            }

            public String toString() {
                return "activePartId";
            }
        }, null);
        mainContext.set(IExceptionHandler.class.getName(), (Object)exceptionHandler);
        mainContext.set(IExtensionRegistry.class.getName(), (Object)registry);
        mainContext.set("input", (Object)new ContextFunction(){

            public Object compute(IEclipseContext context, Object[] arguments) {
                Object adapted;
                IAdapterManager adapters;
                Class adapterType = null;
                if (arguments.length > 0 && arguments[0] instanceof Class) {
                    adapterType = (Class)arguments[0];
                }
                Object newInput = null;
                Object newValue = context.get("selection");
                if (adapterType == null || adapterType.isInstance(newValue)) {
                    newInput = newValue;
                } else if (newValue != null && adapterType != null && (adapters = (IAdapterManager)applicationContext.get(IAdapterManager.class.getName())) != null && (adapted = adapters.loadAdapter(newValue, adapterType.getName())) != null) {
                    newInput = adapted;
                }
                return newInput;
            }
        });
        mainContext.set("activeShell", (Object)new ActiveChildLookupFunction("activeShell", null));
        E4Workbench.initializeNullStyling(mainContext);
        return mainContext;
    }

    public static void processHierarchy(Object me) {
        MHandlerContainer container;
        MContext contextModel;
        if (me instanceof MHandlerContainer) {
            contextModel = (MContext)me;
            container = (MHandlerContainer)contextModel;
            IEclipseContext context = contextModel.getContext();
            if (context != null) {
                IContributionFactory cf = (IContributionFactory)context.get(IContributionFactory.class.getName());
                EHandlerService hs = (EHandlerService)context.get(EHandlerService.class.getName());
                EList handlers = container.getHandlers();
                for (MHandler handler : handlers) {
                    String commandId = handler.getCommand().getId();
                    if (handler.getObject() == null) {
                        handler.setObject(cf.create(handler.getURI(), context));
                    }
                    hs.activateHandler(commandId, handler.getObject());
                }
            }
        }
        if (me instanceof MBindings) {
            contextModel = (MContext)me;
            container = (MBindings)me;
            EList bindingContexts = container.getBindingContexts();
            IEclipseContext context = contextModel.getContext();
            if (context != null && !bindingContexts.isEmpty()) {
                EContextService cs = (EContextService)context.get(EContextService.class.getName());
                for (String id : bindingContexts) {
                    cs.activateContext(id);
                }
            }
        }
        if (me instanceof MElementContainer) {
            EList children = ((MElementContainer)me).getChildren();
            for (MUIElement e : children) {
                E4Workbench.processHierarchy(e);
            }
        }
    }

    public static IEclipseContext initializeContext(IEclipseContext parentContext, MContext contextModel) {
        Class<?>[] interfaces;
        IEclipseContext context;
        if (contextModel.getContext() != null) {
            context = contextModel.getContext();
        } else {
            context = EclipseContextFactory.create((IEclipseContext)parentContext, null);
            context.set("debugString", (Object)("PartContext(" + contextModel + ')'));
        }
        Activator.trace("/trace/eclipse.context", "initializeContext(" + parentContext.toString() + ", " + contextModel + ")", null);
        Class<?>[] classArray = interfaces = contextModel.getClass().getInterfaces();
        int n = interfaces.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> intf = classArray[n2];
            Activator.trace("/trace/eclipse.context", "Adding " + intf.getName() + " for " + contextModel.getClass().getName(), null);
            context.set(intf.getName(), (Object)contextModel);
            ++n2;
        }
        EList containedProperties = contextModel.getVariables();
        for (String name : containedProperties) {
            context.declareModifiable(name);
        }
        contextModel.setContext(context);
        return context;
    }

    private static void initializeNullStyling(IEclipseContext appContext) {
        appContext.set(IStylingEngine.SERVICE_NAME, (Object)new IStylingEngine(){

            public void setClassname(Object widget, String classname) {
            }

            public void setId(Object widget, String id) {
            }

            public void style(Object widget) {
            }
        });
    }
}

