/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.workbench.ui.internal;

import java.util.Collections;
import java.util.Map;
import org.eclipse.core.commands.IParameter;
import org.eclipse.core.commands.IParameterValues;
import org.eclipse.core.commands.ITypedParameter;
import org.eclipse.core.commands.ParameterType;
import org.eclipse.core.commands.ParameterValuesException;
import org.eclipse.core.commands.common.HandleObject;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.e4.ui.bindings.internal.Util;

public final class Parameter
implements IParameter,
ITypedParameter {
    private static final int HASH_CODE_NOT_COMPUTED = -1;
    private static final int HASH_FACTOR = 89;
    private static final int HASH_INITIAL = HandleObject.class.getName().hashCode();
    private transient int hashCode = -1;
    protected final String id;
    private final String name;
    private final boolean optional;
    private final ParameterType parameterType;
    protected transient String string = null;
    private transient IParameterValues values = null;

    public Parameter(String id, String name, IConfigurationElement values, ParameterType parameterType, boolean optional) {
        if (id == null) {
            throw new NullPointerException("Cannot create a parameter with a null id");
        }
        if (name == null) {
            throw new NullPointerException("The name of a parameter cannot be null.");
        }
        this.id = id;
        this.name = name;
        this.parameterType = parameterType;
        this.optional = optional;
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Parameter)) {
            return false;
        }
        Parameter parameter = (Parameter)object;
        if (!Util.equals((Object)this.id, (Object)parameter.id)) {
            return false;
        }
        if (!Util.equals((Object)this.name, (Object)parameter.name)) {
            return false;
        }
        if (!Util.equals((Object)this.values, (Object)parameter.values)) {
            return false;
        }
        return Util.equals((Object)this.optional, (Object)parameter.optional);
    }

    public final String getId() {
        return this.id;
    }

    public final String getName() {
        return this.name;
    }

    public final ParameterType getParameterType() {
        return this.parameterType;
    }

    public final IParameterValues getValues() throws ParameterValuesException {
        return new IParameterValues(){

            public Map getParameterValues() {
                return Collections.EMPTY_MAP;
            }
        };
    }

    public final int hashCode() {
        if (this.hashCode == -1) {
            this.hashCode = HASH_INITIAL * 89 + Util.hashCode((Object)this.id);
            if (this.hashCode == -1) {
                ++this.hashCode;
            }
        }
        return this.hashCode;
    }

    public final boolean isOptional() {
        return this.optional;
    }

    public final String toString() {
        if (this.string == null) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("Parameter(");
            buffer.append(this.id);
            buffer.append(',');
            buffer.append(this.name);
            buffer.append(',');
            buffer.append(this.values);
            buffer.append(',');
            buffer.append(this.optional);
            buffer.append(')');
            this.string = buffer.toString();
        }
        return this.string;
    }
}

