/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.debug.internal.rhino.jsdi;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.jsdt.debug.core.jsdi.ArrayReference;
import org.eclipse.wst.jsdt.debug.core.jsdi.Property;
import org.eclipse.wst.jsdt.debug.core.jsdi.Value;
import org.eclipse.wst.jsdt.debug.internal.rhino.jsdi.Messages;
import org.eclipse.wst.jsdt.debug.internal.rhino.jsdi.ObjectReferenceImpl;
import org.eclipse.wst.jsdt.debug.internal.rhino.jsdi.StackFrameImpl;
import org.eclipse.wst.jsdt.debug.internal.rhino.jsdi.VirtualMachineImpl;

public class ArrayReferenceImpl
extends ObjectReferenceImpl
implements ArrayReference {
    protected static final Value[] NO_VALUES = new Value[0];
    private ArrayList values = null;
    private int size = this.properties().size();

    public ArrayReferenceImpl(VirtualMachineImpl vm, Map body, StackFrameImpl stackFrameImpl) {
        super(vm, body, stackFrameImpl);
    }

    public Value getValue(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index > this.length()) {
            throw new IndexOutOfBoundsException();
        }
        Value value = (Value)this.getValues().get(index);
        if (value == null) {
            return this.vm.mirrorOfNull();
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getValues() {
        ArrayReferenceImpl arrayReferenceImpl = this;
        synchronized (arrayReferenceImpl) {
            if (this.values == null) {
                this.values = new ArrayList(this.size);
                List props = this.properties();
                Iterator iter = props.iterator();
                while (iter.hasNext()) {
                    this.values.add(((Property)iter.next()).value());
                }
            }
        }
        return this.values;
    }

    public int length() {
        return this.size;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(NLS.bind((String)Messages.ArrayReferenceImpl_array_count_, (Object[])new String[]{Integer.toString(this.size)}));
        return buffer.toString();
    }
}

