/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.xwt.converters;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.conversion.StringToNumberConverter;
import org.eclipse.e4.xwt.XWT;
import org.eclipse.e4.xwt.XWTMaps;
import org.eclipse.e4.xwt.metadata.IMetaclass;

public class StringToInteger
implements IConverter {
    private static final String GRIDDATA_PREFIX = "GRIDDATA.";
    private static final String STYLES_SEP = "|";
    public static StringToInteger instance = new StringToInteger();
    protected StringToNumberConverter toNumberConverter = StringToNumberConverter.toInteger((boolean)false);

    public Object convert(Object fromObject) {
        String str = (String)fromObject;
        if (str.indexOf(STYLES_SEP) != -1) {
            ArrayList<String> values = new ArrayList<String>();
            StringTokenizer stk = new StringTokenizer(str, STYLES_SEP);
            while (stk.hasMoreTokens()) {
                values.add(stk.nextToken());
            }
            int result = 0;
            for (String value : values) {
                result |= this.convertInt(value.trim());
            }
            return result;
        }
        return this.convertInt(str);
    }

    protected int convertInt(String str) {
        if (str == null || str.equals("")) {
            return 0;
        }
        try {
            return (Integer)this.toNumberConverter.convert((Object)str);
        }
        catch (Exception exception) {
            String normalizedStr = str.toUpperCase().trim();
            if (normalizedStr.startsWith(GRIDDATA_PREFIX)) {
                return this.convertGridDataInt(normalizedStr);
            }
            try {
                int index = str.lastIndexOf(46);
                if (str.indexOf(46) != -1) {
                    String className = str.substring(0, index);
                    if (className.startsWith("(") && className.endsWith("")) {
                        String memberName;
                        Field field;
                        className = className.substring(1, className.length() - 1);
                        Class<?> type = XWT.getLoadingContext().loadClass(className);
                        if (type != null && Modifier.isStatic((field = type.getField(memberName = str.substring(index + 1))).getModifiers())) {
                            return field.getInt(null);
                        }
                    } else {
                        String memberName;
                        Field field;
                        Class<?> type;
                        IMetaclass metaclass = XWT.getMetaclass(className, "http://www.eclipse.org/xwt/presentation");
                        if (metaclass != null && (type = metaclass.getType()) != null && Modifier.isStatic((field = type.getField(memberName = str.substring(index + 1))).getModifiers())) {
                            return field.getInt(null);
                        }
                    }
                }
            }
            catch (Exception exception2) {}
            return this.defaultConvertInt(str);
        }
    }

    protected int convertGridDataInt(String str) {
        if ("GridData.BEGINNING".equalsIgnoreCase(str)) {
            return 1;
        }
        if ("GridData.CENTER".equalsIgnoreCase(str)) {
            return 2;
        }
        if ("GridData.END".equalsIgnoreCase(str)) {
            return 3;
        }
        if ("GridData.FILL".equalsIgnoreCase(str)) {
            return 4;
        }
        if ("GridData.FILL_BOTH".equalsIgnoreCase(str)) {
            return 1808;
        }
        if ("GridData.FILL_HORIZONTAL".equalsIgnoreCase(str)) {
            return 768;
        }
        if ("GridData.GRAB_HORIZONTAL".equalsIgnoreCase(str)) {
            return 512;
        }
        if ("GridData.GRAB_VERTICAL".equalsIgnoreCase(str)) {
            return 1024;
        }
        if ("GridData.HORIZONTAL_ALIGN_BEGINNING".equalsIgnoreCase(str)) {
            return 32;
        }
        if ("GridData.HORIZONTAL_ALIGN_CENTER".equalsIgnoreCase(str)) {
            return 64;
        }
        if ("GridData.HORIZONTAL_ALIGN_END".equalsIgnoreCase(str)) {
            return 128;
        }
        if ("GridData.HORIZONTAL_ALIGN_FILL".equalsIgnoreCase(str)) {
            return 256;
        }
        if ("GridData.VERTICAL_ALIGN_BEGINNING".equalsIgnoreCase(str)) {
            return 2;
        }
        if ("GridData.VERTICAL_ALIGN_CENTER".equalsIgnoreCase(str)) {
            return 4;
        }
        if ("GridData.VERTICAL_ALIGN_END".equalsIgnoreCase(str)) {
            return 8;
        }
        if ("GridData.VERTICAL_ALIGN_FILL".equalsIgnoreCase(str)) {
            return 16;
        }
        return 0;
    }

    protected int defaultConvertInt(String str) {
        return XWTMaps.getValue(str);
    }

    public Object getFromType() {
        return String.class;
    }

    public Object getToType() {
        return Integer.class;
    }
}

