/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.xwt.javabean.metadata.properties;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.e4.xwt.javabean.metadata.properties.AbstractProperty;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class TableEditorDynamicProperty
extends AbstractProperty {
    public TableEditorDynamicProperty() {
        super("dynamic", Boolean.class);
    }

    public Object getValue(Object target) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException, SecurityException, NoSuchFieldException {
        return null;
    }

    public void setValue(Object target, Object value) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException, SecurityException, NoSuchFieldException {
        Boolean isDynamic = (Boolean)value;
        TableEditor tableEditor = (TableEditor)target;
        final Control control = tableEditor.getEditor();
        Table tableParent = null;
        Composite parent = control.getParent();
        if (parent instanceof Table) {
            tableParent = (Table)parent;
        } else if (tableEditor.getItem() != null) {
            tableParent = tableEditor.getItem().getParent();
        }
        if (tableParent == null) {
            return;
        }
        final Table table = tableParent;
        if (isDynamic.booleanValue()) {
            control.setVisible(false);
            control.addFocusListener((FocusListener)new FocusAdapter(){

                public void focusLost(FocusEvent e) {
                    control.setVisible(false);
                }
            });
            control.addKeyListener((KeyListener)new KeyAdapter(){

                public void keyPressed(KeyEvent e) {
                    if (e.character == '\r' && control.isFocusControl()) {
                        table.notifyListeners(14, new Event());
                    }
                }
            });
            Object mouseHander = table.getData("tableUtil");
            if (mouseHander == null) {
                TableUtil tableUtil = new TableUtil(table);
                table.setData("tableUtil", (Object)tableUtil);
            }
            table.addSelectionListener((SelectionListener)new TableSelectionHandler(table, tableEditor));
        }
    }

    private class TableSelectionHandler
    implements SelectionListener {
        private Table table;
        private TableEditor tableEditor;

        public TableSelectionHandler(Table table, TableEditor tableEditor) {
            this.table = table;
            this.tableEditor = tableEditor;
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            Control editor = this.tableEditor.getEditor();
            if (editor.isDisposed()) {
                return;
            }
            if (editor.isFocusControl()) {
                editor.setVisible(false);
            } else {
                editor.setFocus();
            }
        }

        public void widgetSelected(SelectionEvent e) {
            Control editor = this.tableEditor.getEditor();
            if (editor.isDisposed()) {
                return;
            }
            TableUtil tableUtil = (TableUtil)((Object)this.table.getData("tableUtil"));
            TableItem item = tableUtil.getItem();
            int column = tableUtil.getColumn();
            if (item == this.tableEditor.getItem() && column == this.tableEditor.getColumn()) {
                editor.setVisible(true);
            } else {
                editor.setVisible(false);
            }
        }
    }

    private static class TableUtil
    extends MouseAdapter
    implements KeyListener {
        private Table table;
        private TableItem item;
        private TableColumn column;

        public TableUtil(Table table) {
            this.table = table;
            table.addMouseListener((MouseListener)this);
            table.addKeyListener((KeyListener)this);
        }

        public void mouseDown(MouseEvent e) {
            Rectangle rect;
            if (this.table.isDisposed() || !this.table.isVisible()) {
                return;
            }
            Point pt = new Point(e.x, e.y);
            int lineWidth = this.table.getLinesVisible() ? this.table.getGridLineWidth() : 0;
            TableItem item = this.table.getItem(pt);
            int start = item != null ? this.table.indexOf(item) : this.table.getTopIndex();
            int end = this.table.getItemCount();
            Rectangle clientRect = this.table.getClientArea();
            int i = start;
            while (i < end) {
                TableItem nextItem = this.table.getItem(i);
                rect = nextItem.getBounds(0);
                if (pt.y >= rect.y && pt.y < rect.y + rect.height + lineWidth) {
                    item = nextItem;
                    break;
                }
                if (rect.y > clientRect.y + clientRect.height) {
                    return;
                }
                ++i;
            }
            if (item == null) {
                return;
            }
            this.item = item;
            TableColumn newColumn = null;
            int columnCount = this.table.getColumnCount();
            if (columnCount == 0) {
                if ((this.table.getStyle() & 0x10000) == 0) {
                    rect = item.getBounds(0);
                    rect.width += lineWidth;
                    rect.height += lineWidth;
                    if (!rect.contains(pt)) {
                        return;
                    }
                }
            } else {
                int i2 = 0;
                while (i2 < columnCount) {
                    Rectangle rect2 = item.getBounds(i2);
                    rect2.width += lineWidth;
                    rect2.height += lineWidth;
                    if (rect2.contains(pt)) {
                        newColumn = this.table.getColumn(i2);
                        break;
                    }
                    ++i2;
                }
                if (newColumn == null) {
                    if ((this.table.getStyle() & 0x10000) == 0) {
                        return;
                    }
                    newColumn = this.table.getColumn(0);
                }
            }
            this.column = newColumn;
            this.table.notifyListeners(14, new Event());
        }

        public TableItem getItem() {
            return this.item;
        }

        public int getRow() {
            return this.item == null ? (this.table.getItemCount() > 0 ? 0 : -1) : this.table.indexOf(this.item);
        }

        public void setRow(int rowIndex) {
            this.item = rowIndex >= 0 && rowIndex < this.table.getItemCount() ? this.table.getItem(rowIndex) : null;
        }

        public int getColumn() {
            return this.column == null ? (this.table.getColumnCount() > 0 ? 0 : -1) : this.table.indexOf(this.column);
        }

        public void setColumn(int columnIndex) {
            this.column = columnIndex >= 0 && columnIndex < this.table.getColumnCount() ? this.table.getColumn(columnIndex) : null;
        }

        public void keyPressed(KeyEvent event) {
            int rowIndex = this.getRow();
            int columnIndex = this.column == null ? 0 : this.table.indexOf(this.column);
            switch (event.keyCode) {
                case 0x1000001: {
                    this.setRow(Math.max(0, rowIndex - 1));
                    break;
                }
                case 0x1000002: {
                    this.setRow(Math.min(rowIndex + 1, this.table.getItemCount() - 1));
                    break;
                }
                case 0x1000003: 
                case 0x1000004: {
                    int leadKey;
                    int columnCount = this.table.getColumnCount();
                    if (columnCount == 0) break;
                    int[] order = this.table.getColumnOrder();
                    int index = 0;
                    while (index < order.length) {
                        if (order[index] == columnIndex) break;
                        ++index;
                    }
                    if (index == order.length) {
                        index = 0;
                    }
                    int n = leadKey = (this.table.getStyle() & 0x4000000) != 0 ? 0x1000004 : 0x1000003;
                    if (event.keyCode == leadKey) {
                        this.setColumn(order[Math.max(0, index - 1)]);
                    } else {
                        this.setColumn(order[Math.min(columnCount - 1, index + 1)]);
                    }
                    this.table.notifyListeners(13, new Event());
                    break;
                }
                case 0x1000007: {
                    this.setRow(0);
                    this.setColumn(columnIndex);
                    break;
                }
                case 0x1000008: {
                    this.setRow(this.table.getItemCount() - 1);
                    this.setColumn(columnIndex);
                    break;
                }
                case 0x1000005: {
                    int topIndex = this.table.getTopIndex();
                    if (topIndex == rowIndex) {
                        Rectangle rect = this.table.getClientArea();
                        TableItem item = this.table.getItem(topIndex);
                        Rectangle itemRect = item.getBounds(0);
                        rect.height -= itemRect.y;
                        int height = this.table.getItemHeight();
                        int page = Math.max(1, rect.height / height);
                        topIndex = Math.max(0, topIndex - page + 1);
                    }
                    this.setRow(topIndex);
                    break;
                }
                case 0x1000006: {
                    int downIndex = this.table.getTopIndex();
                    Rectangle rect = this.table.getClientArea();
                    TableItem item = this.table.getItem(downIndex);
                    Rectangle itemRect = item.getBounds(0);
                    rect.height -= itemRect.y;
                    int height = this.table.getItemHeight();
                    int page = Math.max(1, rect.height / height);
                    int end = this.table.getItemCount() - 1;
                    downIndex = Math.min(end, downIndex + page - 1);
                    if (downIndex == rowIndex) {
                        downIndex = Math.min(end, downIndex + page - 1);
                    }
                    this.setRow(downIndex);
                }
            }
        }

        public void keyReleased(KeyEvent e) {
        }
    }
}

