/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.core.internal.util;

import com.ibm.icu.util.StringTokenizer;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.wst.common.uriresolver.internal.util.URIHelper;
import org.eclipse.wst.sse.core.internal.util.URIResolver;

public class ProjectResolver
implements URIResolver {
    private String fFileBaseLocation = null;
    private IProject fProject = null;

    public ProjectResolver(IProject project) {
        this.fProject = project;
    }

    public String getFileBaseLocation() {
        return this.fFileBaseLocation;
    }

    public String getLocationByURI(String uri) {
        return this.getLocationByURI(uri, this.getFileBaseLocation());
    }

    public String getLocationByURI(String uri, boolean resolveCrossProjectLinks) {
        return this.getLocationByURI(uri, this.getFileBaseLocation(), resolveCrossProjectLinks);
    }

    public String getLocationByURI(String uri, String baseReference) {
        IProject p;
        if (uri == null) {
            return null;
        }
        if (this.isFileURL(uri)) {
            try {
                URL url = new URL(uri);
                return this.getPath(url);
            }
            catch (MalformedURLException malformedURLException) {}
        }
        String location = null;
        if (uri.startsWith("/") && (p = this.getProject()) != null && p.isAccessible()) {
            IFile file = p.getFile(uri);
            if (file.getLocation() != null) {
                location = file.getLocation().toString();
            }
            if (location == null && file.getLocationURI() != null) {
                location = file.getLocationURI().toString();
            }
            if (location == null) {
                location = file.getFullPath().toString();
            }
        }
        if (location == null) {
            location = URIHelper.normalize((String)uri, (String)baseReference, (String)this.getRootLocationString());
        }
        return location;
    }

    public String getLocationByURI(String uri, String baseReference, boolean resolveCrossProjectLinks) {
        return this.getLocationByURI(uri, baseReference);
    }

    private String getPath(IPath path, String host) {
        IPath newPath = path;
        String device = path.getDevice();
        if (device != null && device.length() > 0 && device.charAt(0) == '/') {
            String newDevice = device.substring(1);
            newPath = path.setDevice(newDevice);
        }
        if (host != null && host.length() != 0) {
            Path uncPath = new Path(host);
            uncPath = uncPath.append(path);
            newPath = uncPath.makeUNC(true);
        }
        return newPath.toString();
    }

    private String getPath(URL url) {
        Path path;
        String ref = url.getRef() == null ? "" : "#" + url.getRef();
        String strPath = String.valueOf(url.getFile()) + ref;
        if (strPath.length() == 0) {
            path = Path.ROOT;
        } else {
            path = new Path(strPath);
            String query = null;
            StringTokenizer parser = new StringTokenizer(strPath, "?");
            int tokenCount = parser.countTokens();
            if (tokenCount == 2) {
                path = new Path((String)parser.nextElement());
                query = (String)parser.nextElement();
            }
            if (query == null && (tokenCount = (parser = new StringTokenizer(path.toString(), "#")).countTokens()) == 2) {
                path = new Path((String)parser.nextElement());
            }
        }
        return this.getPath((IPath)path, url.getHost());
    }

    public IProject getProject() {
        return this.fProject;
    }

    public IContainer getRootLocation() {
        return this.fProject;
    }

    protected String getRootLocationString() {
        String location = null;
        if (this.fProject == null) {
            return null;
        }
        if (this.fProject.getLocation() != null) {
            location = this.fProject.getLocation().toString();
        }
        if (location == null && this.fProject.getLocationURI() != null) {
            location = this.fProject.getLocationURI().toString();
        }
        if (location == null) {
            location = this.fProject.getFullPath().toString();
        }
        return location;
    }

    public InputStream getURIStream(String uri) {
        return null;
    }

    private boolean isFileURL(String passedSpec) {
        if (passedSpec == null) {
            return false;
        }
        String spec = passedSpec.trim();
        if (spec.length() == 0) {
            return false;
        }
        int limit = spec.length();
        String newProtocol = null;
        int index = 0;
        while (index < limit) {
            char p = spec.charAt(index);
            if (p == '/') break;
            if (p == ':') {
                newProtocol = spec.substring(0, index);
                break;
            }
            ++index;
        }
        return newProtocol != null && newProtocol.compareToIgnoreCase("file") == 0;
    }

    public void setFileBaseLocation(String newFileBaseLocation) {
        this.fFileBaseLocation = newFileBaseLocation;
    }

    public void setProject(IProject newProject) {
        this.fProject = newProject;
    }
}

