/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.navigator.resources;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.actions.CopyFilesAndFoldersOperation;
import org.eclipse.ui.actions.MoveFilesAndFoldersOperation;
import org.eclipse.ui.actions.ReadOnlyStateChecker;
import org.eclipse.ui.ide.dialogs.ImportTypeDialog;
import org.eclipse.ui.internal.navigator.Policy;
import org.eclipse.ui.internal.navigator.resources.plugin.WorkbenchNavigatorMessages;
import org.eclipse.ui.internal.navigator.resources.plugin.WorkbenchNavigatorPlugin;
import org.eclipse.ui.navigator.CommonDropAdapter;
import org.eclipse.ui.navigator.CommonDropAdapterAssistant;
import org.eclipse.ui.part.ResourceTransfer;

public class ResourceDropAdapterAssistant
extends CommonDropAdapterAssistant {
    private static final IResource[] NO_RESOURCES = new IResource[0];
    static /* synthetic */ Class class$0;

    public boolean isSupportedType(TransferData aTransferType) {
        return super.isSupportedType(aTransferType) || FileTransfer.getInstance().isSupportedType(aTransferType);
    }

    public IStatus validateDrop(Object target, int aDropOperation, TransferData transferType) {
        if (!(target instanceof IResource)) {
            return WorkbenchNavigatorPlugin.createStatus(1, 0, WorkbenchNavigatorMessages.DropAdapter_targetMustBeResource, null);
        }
        IResource resource = (IResource)target;
        if (!resource.isAccessible()) {
            return WorkbenchNavigatorPlugin.createErrorStatus(0, WorkbenchNavigatorMessages.DropAdapter_canNotDropIntoClosedProject, null);
        }
        IContainer destination = this.getActualTarget(resource);
        if (destination.getType() == 8) {
            return WorkbenchNavigatorPlugin.createErrorStatus(0, WorkbenchNavigatorMessages.DropAdapter_resourcesCanNotBeSiblings, null);
        }
        String message = null;
        if (LocalSelectionTransfer.getTransfer().isSupportedType(transferType)) {
            IResource[] selectedResources = this.getSelectedResources();
            boolean bProjectDrop = false;
            int iRes = 0;
            while (iRes < selectedResources.length) {
                IResource res = selectedResources[iRes];
                if (res instanceof IProject) {
                    bProjectDrop = true;
                }
                ++iRes;
            }
            if (bProjectDrop) {
                message = WorkbenchNavigatorMessages.DropAdapter_canNotDropProjectIntoProject;
            } else if (selectedResources.length == 0) {
                message = WorkbenchNavigatorMessages.DropAdapter_dropOperationErrorOther;
            } else {
                CopyFilesAndFoldersOperation operation;
                if (aDropOperation == 1) {
                    if (Policy.DEBUG_DND) {
                        System.out.println("ResourceDropAdapterAssistant.validateDrop validating COPY.");
                    }
                    operation = new CopyFilesAndFoldersOperation(this.getShell());
                } else {
                    if (Policy.DEBUG_DND) {
                        System.out.println("ResourceDropAdapterAssistant.validateDrop validating MOVE.");
                    }
                    operation = new MoveFilesAndFoldersOperation(this.getShell());
                }
                if (operation.validateDestination(destination, selectedResources) != null) {
                    operation.setVirtualFolders(true);
                    message = operation.validateDestination(destination, selectedResources);
                }
            }
        } else if (FileTransfer.getInstance().isSupportedType(transferType)) {
            String[] sourceNames = (String[])FileTransfer.getInstance().nativeToJava(transferType);
            if (sourceNames == null) {
                sourceNames = new String[]{};
            }
            CopyFilesAndFoldersOperation copyOperation = new CopyFilesAndFoldersOperation(this.getShell());
            message = copyOperation.validateImportDestination(destination, sourceNames);
        }
        if (message != null) {
            return WorkbenchNavigatorPlugin.createErrorStatus(0, message, null);
        }
        return Status.OK_STATUS;
    }

    public IStatus handleDrop(CommonDropAdapter aDropAdapter, DropTargetEvent aDropTargetEvent, Object aTarget) {
        if (Policy.DEBUG_DND) {
            System.out.println("ResourceDropAdapterAssistant.handleDrop (begin)");
        }
        if (aDropAdapter.getCurrentTarget() == null || aDropTargetEvent.data == null) {
            return Status.CANCEL_STATUS;
        }
        IStatus status = null;
        IResource[] resources = null;
        TransferData currentTransfer = aDropAdapter.getCurrentTransfer();
        if (LocalSelectionTransfer.getTransfer().isSupportedType(currentTransfer)) {
            resources = this.getSelectedResources();
            aDropTargetEvent.detail = 0;
        } else if (ResourceTransfer.getInstance().isSupportedType(currentTransfer)) {
            resources = (IResource[])aDropTargetEvent.data;
        }
        if (FileTransfer.getInstance().isSupportedType(currentTransfer)) {
            status = this.performFileDrop(aDropAdapter, aDropTargetEvent.data);
        } else if (resources != null && resources.length > 0) {
            if (aDropAdapter.getCurrentOperation() == 1 || aDropAdapter.getCurrentOperation() == 4) {
                if (Policy.DEBUG_DND) {
                    System.out.println("ResourceDropAdapterAssistant.handleDrop executing COPY.");
                }
                status = this.performResourceCopy(aDropAdapter, this.getShell(), resources);
            } else {
                if (Policy.DEBUG_DND) {
                    System.out.println("ResourceDropAdapterAssistant.handleDrop executing MOVE.");
                }
                status = this.performResourceMove(aDropAdapter, resources);
            }
        }
        this.openError(status);
        IContainer target = this.getActualTarget((IResource)aDropAdapter.getCurrentTarget());
        if (target != null && target.isAccessible()) {
            try {
                target.refreshLocal(1, null);
            }
            catch (CoreException coreException) {}
        }
        return status;
    }

    public IStatus validatePluginTransferDrop(IStructuredSelection aDragSelection, Object aDropTarget) {
        if (!(aDropTarget instanceof IResource)) {
            return WorkbenchNavigatorPlugin.createStatus(1, 0, WorkbenchNavigatorMessages.DropAdapter_targetMustBeResource, null);
        }
        IResource resource = (IResource)aDropTarget;
        if (!resource.isAccessible()) {
            return WorkbenchNavigatorPlugin.createErrorStatus(0, WorkbenchNavigatorMessages.DropAdapter_canNotDropIntoClosedProject, null);
        }
        IContainer destination = this.getActualTarget(resource);
        if (destination.getType() == 8) {
            return WorkbenchNavigatorPlugin.createErrorStatus(0, WorkbenchNavigatorMessages.DropAdapter_resourcesCanNotBeSiblings, null);
        }
        IResource[] selectedResources = this.getSelectedResources(aDragSelection);
        String message = null;
        if (selectedResources.length == 0) {
            message = WorkbenchNavigatorMessages.DropAdapter_dropOperationErrorOther;
        } else {
            MoveFilesAndFoldersOperation operation = new MoveFilesAndFoldersOperation(this.getShell());
            message = operation.validateDestination(destination, selectedResources);
        }
        if (message != null) {
            return WorkbenchNavigatorPlugin.createErrorStatus(0, message, null);
        }
        return Status.OK_STATUS;
    }

    public IStatus handlePluginTransferDrop(IStructuredSelection aDragSelection, Object aDropTarget) {
        IContainer target = this.getActualTarget((IResource)aDropTarget);
        IResource[] resources = this.getSelectedResources(aDragSelection);
        MoveFilesAndFoldersOperation operation = new MoveFilesAndFoldersOperation(this.getShell());
        operation.copyResources(resources, target);
        if (target != null && target.isAccessible()) {
            try {
                target.refreshLocal(1, null);
            }
            catch (CoreException coreException) {}
        }
        return Status.OK_STATUS;
    }

    private IContainer getActualTarget(IResource mouseTarget) {
        if (mouseTarget.getType() == 1) {
            return mouseTarget.getParent();
        }
        return (IContainer)mouseTarget;
    }

    private IResource[] getSelectedResources() {
        ISelection selection = LocalSelectionTransfer.getTransfer().getSelection();
        if (selection instanceof IStructuredSelection) {
            return this.getSelectedResources((IStructuredSelection)selection);
        }
        return NO_RESOURCES;
    }

    private IResource[] getSelectedResources(IStructuredSelection selection) {
        ArrayList selectedResources = new ArrayList();
        Iterator i = selection.iterator();
        while (i.hasNext()) {
            IResource r;
            Object o = i.next();
            if (o instanceof IResource) {
                selectedResources.add(o);
                continue;
            }
            if (!(o instanceof IAdaptable)) continue;
            IAdaptable a = (IAdaptable)o;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = Class.forName("org.eclipse.core.resources.IResource");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((r = (IResource)a.getAdapter((Class)clazz)) == null) continue;
            selectedResources.add(r);
        }
        return selectedResources.toArray(new IResource[selectedResources.size()]);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private IStatus performResourceCopy(CommonDropAdapter dropAdapter, Shell shell, IResource[] sources) {
        MultiStatus problems = new MultiStatus("org.eclipse.ui", 1, WorkbenchNavigatorMessages.DropAdapter_problemsMoving, null);
        this.mergeStatus(problems, this.validateTarget(dropAdapter.getCurrentTarget(), dropAdapter.getCurrentTransfer(), dropAdapter.getCurrentOperation()));
        IContainer target = this.getActualTarget((IResource)dropAdapter.getCurrentTarget());
        boolean shouldLinkAutomatically = false;
        if (target.isVirtual()) {
            shouldLinkAutomatically = true;
            int i = 0;
            while (i < sources.length) {
                if (sources[i].getType() != 1 && sources[i].getLocation() != null) {
                    shouldLinkAutomatically = false;
                    break;
                }
                ++i;
            }
        }
        CopyFilesAndFoldersOperation operation = new CopyFilesAndFoldersOperation(shell);
        if (shouldLinkAutomatically) {
            operation.setCreateLinks(true);
            operation.copyResources(sources, target);
            return problems;
        } else {
            boolean allSourceAreLinksOrVirtualFolders = true;
            int i = 0;
            while (i < sources.length) {
                if (!sources[i].isVirtual() && !sources[i].isLinked()) {
                    allSourceAreLinksOrVirtualFolders = false;
                    break;
                }
                ++i;
            }
            if (!allSourceAreLinksOrVirtualFolders) {
                ImportTypeDialog dialog = new ImportTypeDialog(this.getShell(), dropAdapter.getCurrentOperation(), sources, target);
                dialog.setResource((IResource)target);
                if (dialog.open() != 0) return problems;
                if (dialog.getSelection() == 2) {
                    operation.setVirtualFolders(true);
                }
                if (dialog.getSelection() == 4) {
                    operation.setCreateLinks(true);
                }
                if (dialog.getVariable() != null) {
                    operation.setRelativeVariable(dialog.getVariable());
                }
                operation.copyResources(sources, target);
                return problems;
            } else {
                operation.copyResources(sources, target);
            }
        }
        return problems;
    }

    private IStatus performResourceMove(CommonDropAdapter dropAdapter, IResource[] sources) {
        MultiStatus problems = new MultiStatus("org.eclipse.ui", 1, WorkbenchNavigatorMessages.DropAdapter_problemsMoving, null);
        this.mergeStatus(problems, this.validateTarget(dropAdapter.getCurrentTarget(), dropAdapter.getCurrentTransfer(), dropAdapter.getCurrentOperation()));
        IContainer target = this.getActualTarget((IResource)dropAdapter.getCurrentTarget());
        boolean shouldLinkAutomatically = false;
        if (target.isVirtual()) {
            shouldLinkAutomatically = true;
            int i = 0;
            while (i < sources.length) {
                if (sources[i].isVirtual() || sources[i].isLinked()) {
                    shouldLinkAutomatically = false;
                    break;
                }
                ++i;
            }
        }
        if (shouldLinkAutomatically) {
            CopyFilesAndFoldersOperation operation = new CopyFilesAndFoldersOperation(this.getShell());
            operation.setCreateLinks(true);
            operation.copyResources(sources, target);
        } else {
            ReadOnlyStateChecker checker = new ReadOnlyStateChecker(this.getShell(), WorkbenchNavigatorMessages.MoveResourceAction_title, WorkbenchNavigatorMessages.MoveResourceAction_checkMoveMessage);
            sources = checker.checkReadOnlyResources(sources);
            MoveFilesAndFoldersOperation operation = new MoveFilesAndFoldersOperation(this.getShell());
            operation.copyResources(sources, target);
        }
        return problems;
    }

    private IStatus performFileDrop(CommonDropAdapter anAdapter, Object data) {
        final CommonDropAdapter finalAdapter = anAdapter;
        MultiStatus problems = new MultiStatus("org.eclipse.ui", 0, WorkbenchNavigatorMessages.DropAdapter_problemImporting, null);
        this.mergeStatus(problems, this.validateTarget(anAdapter.getCurrentTarget(), anAdapter.getCurrentTransfer(), anAdapter.getCurrentOperation()));
        final IContainer target = this.getActualTarget((IResource)anAdapter.getCurrentTarget());
        final String[] names = (String[])data;
        Display.getCurrent().asyncExec(new Runnable(){

            public void run() {
                ResourceDropAdapterAssistant.this.getShell().forceActive();
                CopyFilesAndFoldersOperation operation = new CopyFilesAndFoldersOperation(ResourceDropAdapterAssistant.this.getShell());
                ImportTypeDialog dialog = new ImportTypeDialog(ResourceDropAdapterAssistant.this.getShell(), finalAdapter.getCurrentOperation(), names, target);
                dialog.setResource((IResource)target);
                int type = dialog.open() == 0 ? dialog.getSelection() : 0;
                switch (type) {
                    case 1: {
                        operation.copyFiles(names, target);
                        break;
                    }
                    case 2: {
                        if (dialog.getVariable() != null) {
                            operation.setRelativeVariable(dialog.getVariable());
                        }
                        operation.createVirtualFoldersAndLinks(names, target);
                        break;
                    }
                    case 4: {
                        if (dialog.getVariable() != null) {
                            operation.setRelativeVariable(dialog.getVariable());
                        }
                        operation.linkFiles(names, target);
                        break;
                    }
                }
            }
        });
        return problems;
    }

    private IStatus validateTarget(Object target, TransferData transferType, int dropOperation) {
        if (!(target instanceof IResource)) {
            return WorkbenchNavigatorPlugin.createInfoStatus(WorkbenchNavigatorMessages.DropAdapter_targetMustBeResource);
        }
        IResource resource = (IResource)target;
        if (!resource.isAccessible()) {
            return WorkbenchNavigatorPlugin.createErrorStatus(WorkbenchNavigatorMessages.DropAdapter_canNotDropIntoClosedProject);
        }
        IContainer destination = this.getActualTarget(resource);
        if (destination.getType() == 8) {
            return WorkbenchNavigatorPlugin.createErrorStatus(WorkbenchNavigatorMessages.DropAdapter_resourcesCanNotBeSiblings);
        }
        String message = null;
        if (LocalSelectionTransfer.getTransfer().isSupportedType(transferType)) {
            IResource[] selectedResources = this.getSelectedResources();
            if (selectedResources.length == 0) {
                message = WorkbenchNavigatorMessages.DropAdapter_dropOperationErrorOther;
            } else if (dropOperation == 1 || dropOperation == 4) {
                CopyFilesAndFoldersOperation operation = new CopyFilesAndFoldersOperation(this.getShell());
                if (operation.validateDestination(destination, selectedResources) != null) {
                    operation.setVirtualFolders(true);
                    message = operation.validateDestination(destination, selectedResources);
                }
            } else {
                MoveFilesAndFoldersOperation operation = new MoveFilesAndFoldersOperation(this.getShell());
                if (operation.validateDestination(destination, selectedResources) != null) {
                    operation.setVirtualFolders(true);
                    message = operation.validateDestination(destination, selectedResources);
                }
            }
        } else if (FileTransfer.getInstance().isSupportedType(transferType)) {
            String[] sourceNames = (String[])FileTransfer.getInstance().nativeToJava(transferType);
            if (sourceNames == null) {
                sourceNames = new String[]{};
            }
            CopyFilesAndFoldersOperation copyOperation = new CopyFilesAndFoldersOperation(this.getShell());
            message = copyOperation.validateImportDestination(destination, sourceNames);
        }
        if (message != null) {
            return WorkbenchNavigatorPlugin.createErrorStatus(message);
        }
        return Status.OK_STATUS;
    }

    private void mergeStatus(MultiStatus status, IStatus toMerge) {
        if (!toMerge.isOK()) {
            status.merge(toMerge);
        }
    }

    private void openError(IStatus status) {
        if (status == null) {
            return;
        }
        String genericTitle = WorkbenchNavigatorMessages.DropAdapter_title;
        int codes = 6;
        if (!status.isMultiStatus()) {
            ErrorDialog.openError((Shell)this.getShell(), (String)genericTitle, null, (IStatus)status, (int)codes);
            return;
        }
        IStatus[] children = status.getChildren();
        if (children.length == 1) {
            ErrorDialog.openError((Shell)this.getShell(), (String)status.getMessage(), null, (IStatus)children[0], (int)codes);
            return;
        }
        ErrorDialog.openError((Shell)this.getShell(), (String)genericTitle, null, (IStatus)status, (int)codes);
    }
}

