/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.xwt.tools.ui.designer.editor.outline;

import java.text.MessageFormat;
import org.eclipse.e4.xwt.metadata.IMetaclass;
import org.eclipse.e4.xwt.tools.ui.designer.core.editor.outline.OutlineLableProvider;
import org.eclipse.e4.xwt.tools.ui.designer.parts.DiagramEditPart;
import org.eclipse.e4.xwt.tools.ui.designer.parts.ViewerEditPart;
import org.eclipse.e4.xwt.tools.ui.designer.parts.WidgetEditPart;
import org.eclipse.e4.xwt.tools.ui.designer.resources.ImageShop;
import org.eclipse.e4.xwt.tools.ui.designer.utils.XWTUtility;
import org.eclipse.e4.xwt.tools.ui.xaml.XamlAttribute;
import org.eclipse.e4.xwt.tools.ui.xaml.XamlNode;
import org.eclipse.e4.xwt.tools.ui.xaml.tools.AnnotationTools;
import org.eclipse.gef.EditPart;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Widget;

public class OutlinePageLabelProvider
extends OutlineLableProvider {
    public String getText(Object element) {
        if (element instanceof IStructuredSelection) {
            element = ((IStructuredSelection)element).getFirstElement();
        }
        if (element instanceof EditPart) {
            Object model = ((EditPart)element).getModel();
            if (model instanceof XamlNode) {
                return this.getText((XamlNode)model);
            }
            if (element instanceof DiagramEditPart) {
                return " ";
            }
        }
        return super.getText(element);
    }

    private String getText(XamlNode node) {
        if (AnnotationTools.isAnnotated((XamlNode)node, (String)"Filter_DATA")) {
            return "(filler)";
        }
        String name = node.getName();
        IMetaclass metaclass = XWTUtility.getMetaclass(node);
        if (metaclass != null) {
            XamlAttribute nameAttr;
            XamlAttribute textAttr = node.getAttribute("text");
            if (textAttr == null) {
                textAttr = node.getAttribute("text", "http://www.eclipse.org/xwt/presentation");
            }
            if ((nameAttr = node.getAttribute("name", "http://www.eclipse.org/xwt/presentation")) == null) {
                nameAttr = node.getAttribute("name", "http://www.eclipse.org/xwt");
            }
            String value = null;
            if (nameAttr != null && nameAttr.getValue() != null) {
                value = MessageFormat.format("\"{0}\"", nameAttr.getValue());
            } else if (textAttr != null && textAttr.getValue() != null) {
                value = MessageFormat.format("\"{0}\"", textAttr.getValue());
            }
            if (value != null) {
                name = MessageFormat.format("{0} - {1}", name, value);
            }
        }
        return name;
    }

    public Image getImage(Object element) {
        if (element instanceof IStructuredSelection) {
            element = ((IStructuredSelection)element).getFirstElement();
        }
        if (element instanceof WidgetEditPart) {
            Widget widget = ((WidgetEditPart)((Object)element)).getWidget();
            return ImageShop.getImageForWidget(widget);
        }
        if (element instanceof ViewerEditPart) {
            Viewer viewer = ((ViewerEditPart)((Object)element)).getJfaceViewer();
            if (viewer != null) {
                String name = viewer.getClass().getSimpleName().toLowerCase();
                return ImageShop.getObj16(name);
            }
        } else if (element instanceof DiagramEditPart) {
            return ImageShop.get("/icons/full/tools/xaml.png");
        }
        return super.getImage(element);
    }
}

