/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jem.util.emf.workbench;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jem.internal.util.emf.workbench.EMFWorkbenchContextFactory;
import org.eclipse.jem.util.emf.workbench.ISynchronizerExtender;
import org.eclipse.jem.util.emf.workbench.ProjectResourceSet;
import org.eclipse.jem.util.plugin.JEMUtilPlugin;

public class ResourceSetWorkbenchSynchronizer
implements IResourceChangeListener {
    protected IProject project;
    protected ResourceSet resourceSet;
    protected Set extenders;
    protected IResourceDelta currentProjectDelta;
    private int currentEventType = -1;

    public ResourceSetWorkbenchSynchronizer(ResourceSet aResourceSet, IProject aProject) {
        this.resourceSet = aResourceSet;
        this.project = aProject;
        if (aResourceSet != null && aResourceSet instanceof ProjectResourceSet) {
            ((ProjectResourceSet)aResourceSet).setSynchronizer(this);
        }
        this.initialize();
    }

    public IProject getProject() {
        return this.project;
    }

    public void resourceChanged(IResourceChangeEvent event) {
        this.currentEventType = event.getType();
        this.currentProjectDelta = null;
        if ((this.currentEventType == 2 || this.currentEventType == 4) && event.getResource().equals((Object)this.getProject())) {
            this.notifyExtendersOfClose();
            this.release();
        }
    }

    protected synchronized void notifyExtendersIfNecessary() {
        if (this.currentEventType != 1 || this.extenders == null || this.currentProjectDelta == null) {
            return;
        }
        for (ISynchronizerExtender extender : this.extenders) {
            extender.projectChanged(this.currentProjectDelta);
        }
    }

    protected synchronized void notifyExtendersOfClose() {
        if (this.extenders != null && !this.extenders.isEmpty()) {
            for (ISynchronizerExtender extender : this.extenders) {
                extender.projectClosed();
            }
        }
    }

    protected IWorkspace getWorkspace() {
        if (this.getProject() == null) {
            return ResourcesPlugin.getWorkspace();
        }
        return this.getProject().getWorkspace();
    }

    protected void initialize() {
        this.getWorkspace().addResourceChangeListener((IResourceChangeListener)this, 15);
    }

    public void dispose() {
        this.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
    }

    protected void release() {
        if (JEMUtilPlugin.isActivated()) {
            try {
                if (this.resourceSet instanceof ProjectResourceSet) {
                    ((ProjectResourceSet)this.resourceSet).release();
                }
            }
            finally {
                EMFWorkbenchContextFactory.INSTANCE.removeCachedProject(this.getProject());
                this.dispose();
            }
        }
    }

    public synchronized void addExtender(ISynchronizerExtender extender) {
        if (this.extenders == null) {
            this.extenders = new HashSet(3);
        }
        this.extenders.add(extender);
    }

    public void removeExtender(ISynchronizerExtender extender) {
        if (this.extenders == null) {
            return;
        }
        this.extenders.remove(extender);
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + '(' + (this.getProject() != null ? this.getProject().getName() : "null") + ')';
    }

    public void preSave(IFile aFile) {
    }
}

