/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.internal.search;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.pde.api.tools.internal.builder.Reference;
import org.eclipse.pde.api.tools.internal.provisional.ApiPlugin;
import org.eclipse.pde.api.tools.internal.provisional.VisibilityModifiers;
import org.eclipse.pde.api.tools.internal.provisional.descriptors.IComponentDescriptor;
import org.eclipse.pde.api.tools.internal.provisional.descriptors.IFieldDescriptor;
import org.eclipse.pde.api.tools.internal.provisional.descriptors.IMemberDescriptor;
import org.eclipse.pde.api.tools.internal.provisional.descriptors.IMethodDescriptor;
import org.eclipse.pde.api.tools.internal.provisional.descriptors.IReferenceTypeDescriptor;
import org.eclipse.pde.api.tools.internal.search.IReferenceDescriptor;
import org.eclipse.pde.api.tools.internal.util.Signatures;
import org.eclipse.pde.api.tools.internal.util.Util;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class XmlReferenceDescriptorWriter {
    public static final String TYPE_REFERENCES = "type_references";
    public static final String METHOD_REFERENCES = "method_references";
    public static final String FIELD_REFERENCES = "field_references";
    private static final Integer V_ILLEGAL = new Integer(22);
    private String fLocation = null;
    private HashMap fReferenceMap = null;
    private DocumentBuilder parser = null;
    private IComponentDescriptor alternate;

    public XmlReferenceDescriptorWriter(String location) {
        this.fLocation = location;
        try {
            this.parser = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            this.parser.setErrorHandler(new DefaultHandler());
        }
        catch (FactoryConfigurationError fce) {
            ApiPlugin.log(fce);
        }
        catch (ParserConfigurationException pce) {
            ApiPlugin.log(pce);
        }
    }

    public void writeReferences(IReferenceDescriptor[] references) {
        if (this.fLocation != null) {
            try {
                try {
                    File parent = new File(this.fLocation);
                    if (!parent.exists()) {
                        parent.mkdirs();
                    }
                    this.collateResults(references);
                    this.writeXML(parent);
                }
                catch (Exception e) {
                    ApiPlugin.log(e);
                    if (this.fReferenceMap != null) {
                        this.fReferenceMap.clear();
                        this.fReferenceMap = null;
                    }
                }
            }
            finally {
                if (this.fReferenceMap != null) {
                    this.fReferenceMap.clear();
                    this.fReferenceMap = null;
                }
            }
        }
    }

    private void collateResults(IReferenceDescriptor[] references) throws CoreException {
        if (this.fReferenceMap == null) {
            this.fReferenceMap = new HashMap();
        }
        Integer type = null;
        Integer visibility = null;
        String id = null;
        String tname = null;
        HashMap rmap = null;
        HashMap mmap = null;
        HashMap vmap = null;
        HashMap<String, HashSet<IReferenceDescriptor>> tmap = null;
        HashSet<IReferenceDescriptor> reflist = null;
        IComponentDescriptor rcomponent = null;
        IComponentDescriptor mcomponent = null;
        int i = 0;
        while (i < references.length) {
            rcomponent = references[i].getReferencedComponent();
            id = this.getId(rcomponent);
            rmap = (HashMap)this.fReferenceMap.get(id);
            if (rmap == null) {
                rmap = new HashMap();
                this.fReferenceMap.put(id, rmap);
            }
            if ((mmap = (HashMap)rmap.get(id = this.getId(mcomponent = references[i].getComponent()))) == null) {
                mmap = new HashMap();
                rmap.put(id, mmap);
            }
            if ((vmap = (HashMap)mmap.get(visibility = (references[i].getReferenceFlags() & 1) > 0 ? V_ILLEGAL : new Integer(references[i].getVisibility()))) == null) {
                vmap = new HashMap();
                mmap.put(visibility, vmap);
            }
            if ((tmap = (HashMap<String, HashSet<IReferenceDescriptor>>)vmap.get(type = new Integer(references[i].getReferenceType()))) == null) {
                tmap = new HashMap<String, HashSet<IReferenceDescriptor>>();
                vmap.put(type, tmap);
            }
            if ((reflist = (HashSet<IReferenceDescriptor>)tmap.get(tname = this.getText(references[i].getReferencedMember()))) == null) {
                reflist = new HashSet<IReferenceDescriptor>();
                tmap.put(tname, reflist);
            }
            reflist.add(references[i]);
            ++i;
        }
    }

    String getId(IComponentDescriptor component) throws CoreException {
        StringBuffer buffer = new StringBuffer();
        buffer.append(component.getId()).append(" ").append('(').append(component.getVersion()).append(')');
        return buffer.toString();
    }

    private String getFormattedTypeName(String groupname) {
        if (TYPE_REFERENCES.equals(groupname)) {
            return "Types";
        }
        if (METHOD_REFERENCES.equals(groupname)) {
            return "Methods";
        }
        if (FIELD_REFERENCES.equals(groupname)) {
            return "Fields";
        }
        return "unknown references";
    }

    private String getRefTypeName(int type) {
        switch (type) {
            case 1: {
                return TYPE_REFERENCES;
            }
            case 3: {
                return METHOD_REFERENCES;
            }
            case 2: {
                return FIELD_REFERENCES;
            }
        }
        return "unknown_reference_kinds";
    }

    private void writeXML(File parent) throws CoreException, FileNotFoundException, IOException {
        HashMap vismap = null;
        HashMap typemap = null;
        HashMap rmap = null;
        HashMap mmap = null;
        Integer type = null;
        Integer vis = null;
        String id = null;
        String referee = null;
        File root = null;
        File location = null;
        File base = null;
        Iterator iter = this.fReferenceMap.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            referee = id = (String)entry.getKey();
            base = new File(parent, id);
            if (!base.exists()) {
                base.mkdir();
            }
            rmap = (HashMap)entry.getValue();
            Iterator iter2 = rmap.entrySet().iterator();
            while (iter2.hasNext()) {
                Map.Entry entry2 = iter2.next();
                id = (String)entry2.getKey();
                root = new File(base, id);
                if (!root.exists()) {
                    root.mkdir();
                }
                mmap = (HashMap)entry2.getValue();
                Iterator iter4 = mmap.entrySet().iterator();
                while (iter4.hasNext()) {
                    Map.Entry entry3 = iter4.next();
                    vis = (Integer)entry3.getKey();
                    location = new File(root, VisibilityModifiers.getVisibilityName(vis));
                    if (!location.exists()) {
                        location.mkdir();
                    }
                    vismap = (HashMap)entry3.getValue();
                    Iterator iter3 = vismap.entrySet().iterator();
                    while (iter3.hasNext()) {
                        Map.Entry entry4 = iter3.next();
                        type = (Integer)entry4.getKey();
                        typemap = (HashMap)entry4.getValue();
                        this.writeGroup(id, referee, location, this.getRefTypeName(type), typemap, vis);
                    }
                }
            }
        }
    }

    private void writeGroup(String origin, String referee, File parent, String name, HashMap map, int visibility) throws CoreException, FileNotFoundException, IOException {
        if (parent.exists()) {
            BufferedWriter writer = null;
            try {
                Document doc = null;
                Element root = null;
                int count = 0;
                File out = new File(parent, String.valueOf(name) + ".xml");
                if (out.exists()) {
                    block21: {
                        try {
                            block20: {
                                FileInputStream inputStream = null;
                                try {
                                    try {
                                        inputStream = new FileInputStream(out);
                                        doc = this.parser.parse(inputStream);
                                    }
                                    catch (IOException e) {
                                        e.printStackTrace();
                                        if (inputStream != null) {
                                            inputStream.close();
                                        }
                                        break block20;
                                    }
                                }
                                catch (Throwable throwable) {
                                    if (inputStream != null) {
                                        inputStream.close();
                                    }
                                    throw throwable;
                                }
                                if (inputStream != null) {
                                    inputStream.close();
                                }
                            }
                            if (doc != null) break block21;
                            return;
                        }
                        catch (SAXException se) {
                            se.printStackTrace();
                        }
                    }
                    root = doc.getDocumentElement();
                    String value = root.getAttribute("reference_count");
                    count = Integer.parseInt(value);
                }
                doc = Util.newDocument();
                root = doc.createElement("references");
                doc.appendChild(root);
                root.setAttribute("reference_visibility", Integer.toString(visibility));
                root.setAttribute("origin", origin);
                root.setAttribute("referee", referee);
                root.setAttribute("name", this.getFormattedTypeName(name));
                if (this.alternate != null) {
                    root.setAttribute("alternate", this.getId(this.alternate));
                }
            }
            finally {
                if (writer != null) {
                    writer.close();
                }
            }
        }
    }

    private void addMemberDetails(Element element, IMemberDescriptor member) {
        switch (member.getElementType()) {
            case 2: {
                element.setAttribute("type", ((IReferenceTypeDescriptor)member).getQualifiedName());
                break;
            }
            case 5: {
                IReferenceTypeDescriptor encl = member.getEnclosingType();
                element.setAttribute("type", encl.getQualifiedName());
                element.setAttribute("member", member.getName());
                break;
            }
            case 6: {
                IReferenceTypeDescriptor encl = member.getEnclosingType();
                element.setAttribute("type", encl.getQualifiedName());
                element.setAttribute("member", member.getName());
                element.setAttribute("signature", ((IMethodDescriptor)member).getSignature());
            }
        }
    }

    private Element findTypeElement(Element root, String tname) {
        if (tname == null) {
            return null;
        }
        Element kelement = null;
        NodeList nodes = root.getElementsByTagName("target");
        int i = 0;
        while (i < nodes.getLength()) {
            kelement = (Element)nodes.item(i);
            if (tname.equals(kelement.getAttribute("name"))) {
                return kelement;
            }
            ++i;
        }
        return null;
    }

    private Element findKindElement(Element root, Integer kind) {
        Element kelement = null;
        NodeList nodes = root.getElementsByTagName("reference_kind");
        int i = 0;
        while (i < nodes.getLength()) {
            kelement = (Element)nodes.item(i);
            if (kind.toString().equals(kelement.getAttribute("kind"))) {
                return kelement;
            }
            ++i;
        }
        return null;
    }

    private void writeReference(Document document, Element parent, IReferenceDescriptor reference) throws CoreException {
        Element kelement = null;
        Integer kind = new Integer(reference.getReferenceKind());
        kelement = this.findKindElement(parent, kind);
        if (kelement == null) {
            kelement = document.createElement("reference_kind");
            kelement.setAttribute("reference_kind_name", Reference.getReferenceText(kind));
            kelement.setAttribute("kind", kind.toString());
            kelement.setAttribute("flags", Integer.toString(reference.getReferenceFlags()));
            parent.appendChild(kelement);
        }
        Element relement = document.createElement("reference");
        IMemberDescriptor member = reference.getMember();
        relement.setAttribute("origin", this.getText(member));
        Object[] messages = reference.getProblemMessages();
        if (messages != null) {
            relement.setAttribute("message_arguments", this.getText(messages));
        }
        this.addMemberDetails(relement, member);
        member = reference.getReferencedMember();
        if (member != null) {
            relement.setAttribute("linenumber", Integer.toString(reference.getLineNumber()));
            kelement.appendChild(relement);
        }
    }

    String getText(Object[] array) {
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < array.length) {
            buffer.append(array[i].toString());
            if (i < array.length - 1) {
                buffer.append(",");
            }
            ++i;
        }
        return buffer.toString();
    }

    private String getText(IMemberDescriptor member) throws CoreException {
        switch (member.getElementType()) {
            case 2: {
                return Signatures.getQualifiedTypeSignature((IReferenceTypeDescriptor)member);
            }
            case 6: {
                return Signatures.getQualifiedMethodSignature((IMethodDescriptor)member);
            }
            case 5: {
                return Signatures.getQualifiedFieldSignature((IFieldDescriptor)member);
            }
        }
        return null;
    }

    public void setAlternate(IComponentDescriptor other) {
        this.alternate = other;
    }
}

