/*******************************************************************************
 * Copyright (c) 2006, 2009 Soyatec (http://www.soyatec.com) and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Soyatec - initial API and implementation
 *******************************************************************************/
package org.eclipse.e4.xwt.tools.ui.xaml;

import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

/**
 * <!-- begin-user-doc --> A representation of the model object '<em><b>Node</b></em>'. <!-- end-user-doc -->
 * 
 * <p>
 * The following features are supported:
 * <ul>
 * <li>{@link org.eclipse.e4.xwt.tools.ui.xaml.XamlNode#getName <em>Name</em>}</li>
 * <li>{@link org.eclipse.e4.xwt.tools.ui.xaml.XamlNode#getPrefix <em>Prefix</em>}</li>
 * <li>{@link org.eclipse.e4.xwt.tools.ui.xaml.XamlNode#getNamespace <em>Namespace</em>}</li>
 * <li>{@link org.eclipse.e4.xwt.tools.ui.xaml.XamlNode#getValue <em>Value</em>}</li>
 * <li>{@link org.eclipse.e4.xwt.tools.ui.xaml.XamlNode#getChildNodes <em>Child Nodes</em>}</li>
 * <li>{@link org.eclipse.e4.xwt.tools.ui.xaml.XamlNode#getAttributes <em>Attributes</em>}</li>
 * <li>{@link org.eclipse.e4.xwt.tools.ui.xaml.XamlNode#getId <em>Id</em>}</li>
 * <li>{@link org.eclipse.e4.xwt.tools.ui.xaml.XamlNode#getComments <em>Comments</em>}</li>
 * </ul>
 * </p>
 * 
 * @see org.eclipse.e4.xwt.tools.ui.xaml.XamlPackage#getXamlNode()
 * @model abstract="true"
 * @generated
 */
public interface XamlNode extends AnnotatedObject {
	/**
	 * Returns the value of the '<em><b>Name</b></em>' attribute. <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Name</em>' attribute isn't clear, there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * 
	 * @return the value of the '<em>Name</em>' attribute.
	 * @see #setName(String)
	 * @see org.eclipse.e4.xwt.tools.ui.xaml.XamlPackage#getXamlNode_Name()
	 * @model required="true"
	 * @generated
	 */
	String getName();

	/**
	 * Sets the value of the '{@link org.eclipse.e4.xwt.tools.ui.xaml.XamlNode#getName <em>Name</em>}' attribute. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @param value
	 *            the new value of the '<em>Name</em>' attribute.
	 * @see #getName()
	 * @generated
	 */
	void setName(String value);

	/**
	 * Returns the value of the '<em><b>Prefix</b></em>' attribute. <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Prefix</em>' attribute isn't clear, there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * 
	 * @return the value of the '<em>Prefix</em>' attribute.
	 * @see #setPrefix(String)
	 * @see org.eclipse.e4.xwt.tools.ui.xaml.XamlPackage#getXamlNode_Prefix()
	 * @model required="true"
	 * @generated
	 */
	String getPrefix();

	/**
	 * Sets the value of the '{@link org.eclipse.e4.xwt.tools.ui.xaml.XamlNode#getPrefix <em>Prefix</em>}' attribute. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @param value
	 *            the new value of the '<em>Prefix</em>' attribute.
	 * @see #getPrefix()
	 * @generated
	 */
	void setPrefix(String value);

	/**
	 * Returns the value of the '<em><b>Namespace</b></em>' attribute. <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Namespace</em>' attribute isn't clear, there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * 
	 * @return the value of the '<em>Namespace</em>' attribute.
	 * @see #setNamespace(String)
	 * @see org.eclipse.e4.xwt.tools.ui.xaml.XamlPackage#getXamlNode_Namespace()
	 * @model required="true"
	 * @generated
	 */
	String getNamespace();

	/**
	 * Sets the value of the '{@link org.eclipse.e4.xwt.tools.ui.xaml.XamlNode#getNamespace <em>Namespace</em>}' attribute. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @param value
	 *            the new value of the '<em>Namespace</em>' attribute.
	 * @see #getNamespace()
	 * @generated
	 */
	void setNamespace(String value);

	/**
	 * Returns the value of the '<em><b>Value</b></em>' attribute. <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Value</em>' attribute isn't clear, there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * 
	 * @return the value of the '<em>Value</em>' attribute.
	 * @see #setValue(String)
	 * @see org.eclipse.e4.xwt.tools.ui.xaml.XamlPackage#getXamlNode_Value()
	 * @model
	 * @generated
	 */
	String getValue();

	/**
	 * Sets the value of the '{@link org.eclipse.e4.xwt.tools.ui.xaml.XamlNode#getValue <em>Value</em>}' attribute. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @param value
	 *            the new value of the '<em>Value</em>' attribute.
	 * @see #getValue()
	 * @generated
	 */
	void setValue(String value);

	/**
	 * Returns the value of the '<em><b>Child Nodes</b></em>' containment reference list. The list contents are of type {@link org.eclipse.e4.xwt.tools.ui.xaml.XamlElement}. <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Child Nodes</em>' containment reference list isn't clear, there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * 
	 * @return the value of the '<em>Child Nodes</em>' containment reference list.
	 * @see org.eclipse.e4.xwt.tools.ui.xaml.XamlPackage#getXamlNode_ChildNodes()
	 * @model containment="true"
	 * @generated
	 */
	EList<XamlElement> getChildNodes();

	/**
	 * Returns the value of the '<em><b>Attributes</b></em>' containment reference list. The list contents are of type {@link org.eclipse.e4.xwt.tools.ui.xaml.XamlAttribute}. <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Attributes</em>' containment reference list isn't clear, there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * 
	 * @return the value of the '<em>Attributes</em>' containment reference list.
	 * @see org.eclipse.e4.xwt.tools.ui.xaml.XamlPackage#getXamlNode_Attributes()
	 * @model containment="true"
	 * @generated
	 */
	EList<XamlAttribute> getAttributes();

	/**
	 * Returns the value of the '<em><b>Id</b></em>' attribute. <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Id</em>' attribute isn't clear, there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * 
	 * @return the value of the '<em>Id</em>' attribute.
	 * @see #setId(String)
	 * @see org.eclipse.e4.xwt.tools.ui.xaml.XamlPackage#getXamlNode_Id()
	 * @model id="true"
	 * @generated
	 */
	String getId();

	/**
	 * Sets the value of the '{@link org.eclipse.e4.xwt.tools.ui.xaml.XamlNode#getId <em>Id</em>}' attribute. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @param value
	 *            the new value of the '<em>Id</em>' attribute.
	 * @see #getId()
	 * @generated
	 */
	void setId(String value);

	/**
	 * Returns the value of the '<em><b>Comments</b></em>' containment reference list. The list contents are of type {@link org.eclipse.e4.xwt.tools.ui.xaml.Comment}. <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Comments</em>' containment reference list isn't clear, there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * 
	 * @return the value of the '<em>Comments</em>' containment reference list.
	 * @see org.eclipse.e4.xwt.tools.ui.xaml.XamlPackage#getXamlNode_Comments()
	 * @model containment="true"
	 * @generated
	 */
	EList<Comment> getComments();

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @model
	 * @generated
	 */
	XamlAttribute getAttribute(String name, String namespace);

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @model
	 * @generated
	 */
	XamlAttribute getAttribute(String name);

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @model
	 * @generated
	 */
	XamlElement getChild(String name, String namespace);

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @model
	 * @generated
	 */
	XamlElement getChild(String name);

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @model
	 * @generated
	 */
	XamlElement getChild(int index);

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @model kind="operation"
	 * @generated
	 */
	XamlDocument getOwnerDocument();

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @model
	 * @generated
	 */
	EList<String> attributeNames();

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @model
	 * @generated
	 */
	EList<String> attributeNames(String namespace);

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @model
	 * @generated
	 */
	EList<String> attributeNamespaces();

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @model kind="operation"
	 * @generated
	 */
	XamlNode getParent();

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @model dataType="org.eclipse.e4.xwt.tools.ui.xaml.Node" documentDataType="org.eclipse.e4.xwt.tools.ui.xaml.Document"
	 * @generated
	 */
	Node generate(Document document, Map<String, Object> options);

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @model kind="operation"
	 * @generated
	 */
	String getFlatValue();

} // XamlNode
